/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.LoadBalancerEventListener;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.Duration;

abstract class LoadBalancer
implements ConnectionFactory {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final String loadBalancerName;
    private final List<MonitoredConnectionFactory> monitoredFactories;
    private final ReferenceCountedObject.Reference scheduler;
    private final Object stateLock = new Object();
    private volatile LdapException lastFailure;
    private final LoadBalancerEventListener listener;
    private final Object listenerLock = new Object();
    private int offlineFactoriesCount;
    private final long monitoringIntervalMS;
    private ScheduledFuture<?> monitoringFuture;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    LoadBalancer(String loadBalancerName, Collection<? extends ConnectionFactory> factories, Options options) {
        Reject.ifNull((Object[])new Object[]{loadBalancerName, factories, options});
        this.loadBalancerName = loadBalancerName;
        this.monitoredFactories = new ArrayList<MonitoredConnectionFactory>(factories.size());
        int i = 0;
        for (ConnectionFactory connectionFactory : factories) {
            this.monitoredFactories.add(new MonitoredConnectionFactory(connectionFactory, i++));
        }
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull((ScheduledExecutorService)options.get(Connections.LOAD_BALANCER_SCHEDULER));
        this.monitoringIntervalMS = ((Duration)options.get(Connections.LOAD_BALANCER_MONITORING_INTERVAL)).to(TimeUnit.MILLISECONDS);
        this.listener = (LoadBalancerEventListener)options.get(Connections.LOAD_BALANCER_EVENT_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.monitoringFuture != null) {
                    this.monitoringFuture.cancel(false);
                    this.monitoringFuture = null;
                }
            }
            Utils.closeSilently(this.monitoredFactories);
            this.scheduler.release();
        }
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.loadBalancerName);
        builder.append('(');
        Utils.joinAsString((StringBuilder)builder, (String)",", this.monitoredFactories);
        builder.append(')');
        return builder.toString();
    }

    final ConnectionFactory getMonitoredConnectionFactory(int initialIndex) throws LdapException {
        int maxIndex = this.monitoredFactories.size();
        int index = initialIndex;
        do {
            MonitoredConnectionFactory factory;
            if (!(factory = this.monitoredFactories.get(index)).isOperational.get()) continue;
            return factory;
        } while ((index = (index + 1) % maxIndex) != initialIndex);
        throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, "No operational connection factories available", this.lastFailure);
    }

    final String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    private final class MonitorRunnable
    implements Runnable {
        private MonitorRunnable() {
        }

        @Override
        public void run() {
            for (MonitoredConnectionFactory factory : LoadBalancer.this.monitoredFactories) {
                factory.checkIfAvailable();
            }
        }
    }

    private final class MonitoredConnectionFactory
    implements ConnectionFactory,
    LdapResultHandler<Connection> {
        private final ConnectionFactory factory;
        private final AtomicBoolean isOperational = new AtomicBoolean(true);
        private volatile Promise<?, LdapException> pendingConnectPromise;
        private final int index;

        private MonitoredConnectionFactory(ConnectionFactory factory, int index) {
            this.factory = factory;
            this.index = index;
        }

        @Override
        public void close() {
            this.factory.close();
        }

        @Override
        public Connection getConnection() throws LdapException {
            Connection connection;
            try {
                connection = this.factory.getConnection();
            }
            catch (LdapException e) {
                this.notifyOffline(e);
                int nextIndex = (this.index + 1) % LoadBalancer.this.monitoredFactories.size();
                return LoadBalancer.this.getMonitoredConnectionFactory(nextIndex).getConnection();
            }
            this.notifyOnline();
            return connection;
        }

        @Override
        public Promise<Connection, LdapException> getConnectionAsync() {
            return this.factory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, Connection, LdapException>(){

                public Promise<Connection, LdapException> apply(Connection value) throws LdapException {
                    MonitoredConnectionFactory.this.notifyOnline();
                    return Promises.newResultPromise((Object)value);
                }
            }, (AsyncFunction)new AsyncFunction<LdapException, Connection, LdapException>(){

                public Promise<Connection, LdapException> apply(LdapException error) throws LdapException {
                    MonitoredConnectionFactory.this.notifyOffline(error);
                    int nextIndex = (MonitoredConnectionFactory.this.index + 1) % LoadBalancer.this.monitoredFactories.size();
                    return LoadBalancer.this.getMonitoredConnectionFactory(nextIndex).getConnectionAsync();
                }
            });
        }

        @Override
        public void handleException(LdapException exception) {
            this.notifyOffline(exception);
        }

        @Override
        public void handleResult(Connection connection) {
            connection.close();
            this.notifyOnline();
        }

        public String toString() {
            return this.factory.toString();
        }

        private synchronized void checkIfAvailable() {
            if (!this.isOperational.get() && (this.pendingConnectPromise == null || this.pendingConnectPromise.isDone())) {
                logger.debug(LocalizableMessage.raw((CharSequence)"Attempting reconnect to offline factory '%s'", (Object[])new Object[]{this}));
                this.pendingConnectPromise = this.factory.getConnectionAsync().thenOnResult((ResultHandler)this).thenOnException((ExceptionHandler)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyOffline(LdapException error) {
            LoadBalancer.this.lastFailure = error;
            if (this.isOperational.getAndSet(false)) {
                Object object = LoadBalancer.this.listenerLock;
                synchronized (object) {
                    try {
                        LoadBalancer.this.listener.handleConnectionFactoryOffline(this.factory, error);
                    }
                    catch (RuntimeException e) {
                        this.handleListenerException(e);
                    }
                }
                object = LoadBalancer.this.stateLock;
                synchronized (object) {
                    LoadBalancer.this.offlineFactoriesCount++;
                    if (LoadBalancer.this.offlineFactoriesCount == 1) {
                        logger.debug(LocalizableMessage.raw((CharSequence)"Starting monitoring thread", (Object[])new Object[0]));
                        LoadBalancer.this.monitoringFuture = ((ScheduledExecutorService)LoadBalancer.this.scheduler.get()).scheduleWithFixedDelay(new MonitorRunnable(), 0L, LoadBalancer.this.monitoringIntervalMS, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyOnline() {
            if (!this.isOperational.getAndSet(true)) {
                Object object = LoadBalancer.this.listenerLock;
                synchronized (object) {
                    try {
                        LoadBalancer.this.listener.handleConnectionFactoryOnline(this.factory);
                    }
                    catch (RuntimeException e) {
                        this.handleListenerException(e);
                    }
                }
                object = LoadBalancer.this.stateLock;
                synchronized (object) {
                    LoadBalancer.this.offlineFactoriesCount--;
                    if (LoadBalancer.this.offlineFactoriesCount == 0) {
                        logger.debug(LocalizableMessage.raw((CharSequence)"Stopping monitoring thread", (Object[])new Object[0]));
                        LoadBalancer.this.monitoringFuture.cancel(false);
                        LoadBalancer.this.monitoringFuture = null;
                    }
                }
            }
        }

        private void handleListenerException(RuntimeException e) {
            logger.error(LocalizableMessage.raw((CharSequence)"A run-time error occurred while processing a load-balancer event", (Object[])new Object[]{e}));
        }
    }
}

