/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.reactive.ReactiveHandler;
import com.forgerock.reactive.Stream;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import org.forgerock.opendj.ldap.CommonLDAPOptions;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.spi.LDAPListenerImpl;
import org.forgerock.opendj.ldap.spi.LdapMessages;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class LDAPListener
extends CommonLDAPOptions
implements Closeable {
    public static final Option<Integer> CONNECT_MAX_BACKLOG = Option.withDefault((Object)50);
    public static final Option<Integer> REQUEST_MAX_SIZE_IN_BYTES = Option.withDefault((Object)0x500000);
    public static final Option<Integer> MAX_CONCURRENT_REQUESTS = Option.withDefault((Object)1024);
    private final LDAPListenerImpl impl;
    private TransportProvider provider;

    public LDAPListener(int port, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> factory) throws IOException {
        this(port, factory, Options.defaultOptions());
    }

    public LDAPListener(int port, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> factory, Options options) throws IOException {
        this(Collections.singleton(new InetSocketAddress(port)), factory, options);
    }

    public LDAPListener(Set<InetSocketAddress> addresses, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> factory) throws IOException {
        this(addresses, factory, Options.defaultOptions());
    }

    public LDAPListener(Set<InetSocketAddress> addresses, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> factory, Options options) throws IOException {
        Reject.ifNull((Object[])new Object[]{addresses, factory, options});
        this.provider = LDAPListener.getTransportProvider(options);
        this.impl = this.provider.getLDAPListener(addresses, factory, options);
    }

    public LDAPListener(String host, int port, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> factory) throws IOException {
        this(host, port, factory, Options.defaultOptions());
    }

    public LDAPListener(String host, int port, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> factory, Options options) throws IOException {
        this(Collections.singleton(new InetSocketAddress(host, port)), factory, options);
    }

    @Override
    public void close() {
        this.impl.close();
    }

    public Set<InetSocketAddress> getSocketAddresses() {
        return this.impl.getSocketAddresses();
    }

    public InetSocketAddress firstSocketAddress() {
        return this.impl.getSocketAddresses().iterator().next();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return this.impl.toString();
    }
}

