/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

public enum ConditionResult {
    FALSE("false"),
    UNDEFINED("undefined"),
    TRUE("true");

    private static final boolean[] BOOLEAN_MAP;
    private static final ConditionResult[][] LOGICAL_AND;
    private static final ConditionResult[] LOGICAL_NOT;
    private static final ConditionResult[][] LOGICAL_OR;
    private final String resultName;

    public static ConditionResult and() {
        return TRUE;
    }

    public static ConditionResult and(ConditionResult r) {
        return r;
    }

    public static ConditionResult and(ConditionResult ... results) {
        ConditionResult result;
        ConditionResult finalResult = TRUE;
        ConditionResult[] conditionResultArray = results;
        int n = conditionResultArray.length;
        for (int i = 0; i < n && (finalResult = ConditionResult.and(finalResult, result = conditionResultArray[i])) != FALSE; ++i) {
        }
        return finalResult;
    }

    public static ConditionResult and(ConditionResult r1, ConditionResult r2) {
        return LOGICAL_AND[r1.ordinal()][r2.ordinal()];
    }

    public static ConditionResult not(ConditionResult r) {
        return LOGICAL_NOT[r.ordinal()];
    }

    public static ConditionResult or() {
        return FALSE;
    }

    public static ConditionResult or(ConditionResult r) {
        return r;
    }

    public static ConditionResult or(ConditionResult ... results) {
        ConditionResult result;
        ConditionResult finalResult = FALSE;
        ConditionResult[] conditionResultArray = results;
        int n = conditionResultArray.length;
        for (int i = 0; i < n && (finalResult = ConditionResult.or(finalResult, result = conditionResultArray[i])) != TRUE; ++i) {
        }
        return finalResult;
    }

    public static ConditionResult or(ConditionResult r1, ConditionResult r2) {
        return LOGICAL_OR[r1.ordinal()][r2.ordinal()];
    }

    public static ConditionResult valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    private ConditionResult(String resultName) {
        this.resultName = resultName;
    }

    public boolean toBoolean() {
        return BOOLEAN_MAP[this.ordinal()];
    }

    public String toString() {
        return this.resultName;
    }

    static {
        BOOLEAN_MAP = new boolean[]{false, false, true};
        LOGICAL_AND = new ConditionResult[][]{{FALSE, FALSE, FALSE}, {FALSE, UNDEFINED, UNDEFINED}, {FALSE, UNDEFINED, TRUE}};
        LOGICAL_NOT = new ConditionResult[]{TRUE, UNDEFINED, FALSE};
        LOGICAL_OR = new ConditionResult[][]{{FALSE, UNDEFINED, TRUE}, {UNDEFINED, UNDEFINED, TRUE}, {TRUE, TRUE, TRUE}};
    }
}

