/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.concurrent.ThreadLocalRandom;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class AffinityControl
implements Control {
    public static final String OID = "1.3.6.1.4.1.36733.2.1.5.2";
    public static final ControlDecoder<AffinityControl> DECODER = new ControlDecoder<AffinityControl>(){

        @Override
        public AffinityControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull((Object)control);
            if (control instanceof AffinityControl) {
                return (AffinityControl)control;
            }
            if (!control.getOID().equals(AffinityControl.OID)) {
                throw DecodeException.error(CoreMessages.ERR_CONNECTION_AFFINITY_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)AffinityControl.OID));
            }
            if (!control.hasValue()) {
                throw DecodeException.error(CoreMessages.ERR_CONNECTION_AFFINITY_CONTROL_DECODE_NULL.get());
            }
            return new AffinityControl(control.getValue(), control.isCritical());
        }

        @Override
        public String getOID() {
            return AffinityControl.OID;
        }
    };
    private final ByteString affinityValue;
    private final boolean isCritical;

    public static AffinityControl newControl(ByteString affinityValue, boolean isCritical) {
        Reject.ifNull((Object)affinityValue);
        return new AffinityControl(affinityValue, isCritical);
    }

    public static AffinityControl newControl(boolean isCritical) {
        byte[] randomValue = new byte[5];
        ThreadLocalRandom.current().nextBytes(randomValue);
        return new AffinityControl(ByteString.valueOfBytes(randomValue), isCritical);
    }

    private AffinityControl(ByteString affinityValue, boolean isCritical) {
        this.affinityValue = affinityValue;
        this.isCritical = isCritical;
    }

    public ByteString getAffinityValue() {
        return this.affinityValue;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return this.affinityValue;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AffinityControl(oid=");
        builder.append(this.getOID());
        builder.append(", affinityValue(hex)=");
        builder.append(this.affinityValue.toHexString());
        builder.append(", isCritical=");
        builder.append(this.isCritical);
        builder.append(")");
        return builder.toString();
    }
}

