/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.elasticsearch;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;

public class ElasticsearchAuditEventHandlerConfiguration
extends EventHandlerConfiguration {
    @JsonPropertyDescription(value="audit.handlers.elasticsearch.connection")
    private ConnectionConfiguration connection = new ConnectionConfiguration();
    @JsonPropertyDescription(value="audit.handlers.elasticsearch.indexMapping")
    private IndexMappingConfiguration indexMapping = new IndexMappingConfiguration();
    @JsonPropertyDescription(value="audit.handlers.elasticsearch.buffering")
    private EventBufferingConfiguration buffering = new EventBufferingConfiguration();

    public ConnectionConfiguration getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionConfiguration connection) {
        this.connection = connection;
    }

    public IndexMappingConfiguration getIndexMapping() {
        return this.indexMapping;
    }

    public void setIndexMapping(IndexMappingConfiguration indexMapping) {
        this.indexMapping = indexMapping;
    }

    public EventBufferingConfiguration getBuffering() {
        return this.buffering;
    }

    public void setBuffering(EventBufferingConfiguration buffering) {
        this.buffering = buffering;
    }

    public boolean isUsableForQueries() {
        return true;
    }

    public static class EventBufferingConfiguration {
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.buffering.enabled")
        private boolean enabled;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.buffering.maxSize")
        private int maxSize;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.buffering.writeInterval")
        private String writeInterval;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.buffering.maxBatchedEvents")
        private int maxBatchedEvents;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public String getWriteInterval() {
            return this.writeInterval;
        }

        public void setWriteInterval(String writeInterval) {
            this.writeInterval = writeInterval;
        }

        public int getMaxBatchedEvents() {
            return this.maxBatchedEvents;
        }

        public void setMaxBatchedEvents(int maxBatchedEvents) {
            this.maxBatchedEvents = maxBatchedEvents;
        }
    }

    public static class IndexMappingConfiguration {
        private static final String DEFAULT_INDEX_NAME = "audit";
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.indexMapping.indexName")
        private String indexName;

        public String getIndexName() {
            return this.indexName != null && !this.indexName.isEmpty() ? this.indexName : DEFAULT_INDEX_NAME;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }
    }

    public static class ConnectionConfiguration {
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 9200;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.connection.useSSL")
        private boolean useSSL;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.connection.host")
        private String host;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.connection.port")
        private int port;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.connection.username")
        private String username;
        @JsonPropertyDescription(value="audit.handlers.elasticsearch.connection.password")
        private String password;

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public void setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
        }

        public String getHost() {
            return this.host != null && !this.host.isEmpty() ? this.host : DEFAULT_HOST;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port > 0 ? this.port : 9200;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

