/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.elasticsearch;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.forgerock.audit.Audit;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.events.handlers.buffering.BatchConsumer;
import org.forgerock.audit.events.handlers.buffering.BatchException;
import org.forgerock.audit.events.handlers.buffering.BatchPublisher;
import org.forgerock.audit.events.handlers.buffering.BufferedBatchPublisher;
import org.forgerock.audit.handlers.elasticsearch.ElasticsearchAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.elasticsearch.ElasticsearchQueryFilterVisitor;
import org.forgerock.audit.util.ElasticsearchUtil;
import org.forgerock.http.Client;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.apache.async.AsyncHttpClientProvider;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.spi.Loader;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.services.context.Context;
import org.forgerock.util.CloseSilentlyFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.query.QueryFilterVisitor;
import org.forgerock.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchAuditEventHandler
extends AuditEventHandlerBase
implements BatchConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchAuditEventHandler.class);
    private static final ElasticsearchQueryFilterVisitor ELASTICSEARCH_QUERY_FILTER_VISITOR = new ElasticsearchQueryFilterVisitor();
    private static final String QUERY = "query";
    private static final String GET = "GET";
    private static final String SEARCH = "/_search";
    private static final String BULK = "/_bulk";
    private static final String HITS = "hits";
    private static final String SOURCE = "_source";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final String TOTAL = "total";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final int BATCH_INDEX_AVERAGE_PER_EVENT_PAYLOAD_SIZE = 1280;
    private static final boolean ALWAYS_FLUSH_BATCH_QUEUE = true;
    private static final int DEFAULT_OFFSET = 0;
    private final String indexName;
    private final String basicAuthHeaderValue;
    private final String baseUri;
    private final String bulkUri;
    private final ElasticsearchAuditEventHandlerConfiguration configuration;
    private final Client client;
    private final BatchPublisher batchIndexer;
    private final HttpClientHandler defaultHttpClientHandler;

    public ElasticsearchAuditEventHandler(ElasticsearchAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData, @Audit Client client) {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        this.configuration = (ElasticsearchAuditEventHandlerConfiguration)((Object)Reject.checkNotNull((Object)((Object)configuration)));
        if (client == null) {
            this.defaultHttpClientHandler = this.defaultHttpClientHandler();
            this.client = new Client((Handler)this.defaultHttpClientHandler);
        } else {
            this.defaultHttpClientHandler = null;
            this.client = client;
        }
        this.indexName = configuration.getIndexMapping().getIndexName();
        this.basicAuthHeaderValue = this.buildBasicAuthHeaderValue();
        this.baseUri = this.buildBaseUri();
        this.bulkUri = this.buildBulkUri();
        ElasticsearchAuditEventHandlerConfiguration.EventBufferingConfiguration bufferConfig = configuration.getBuffering();
        if (bufferConfig.isEnabled()) {
            Duration writeInterval = bufferConfig.getWriteInterval() == null || bufferConfig.getWriteInterval().isEmpty() ? null : Duration.duration((String)bufferConfig.getWriteInterval());
            this.batchIndexer = BufferedBatchPublisher.newBuilder((BatchConsumer)this).capacity(bufferConfig.getMaxSize()).writeInterval(writeInterval).maxBatchEvents(bufferConfig.getMaxBatchedEvents()).averagePerEventPayloadSize(1280).autoFlush(true).build();
        } else {
            this.batchIndexer = null;
        }
    }

    public void startup() throws ResourceException {
        if (this.batchIndexer != null) {
            this.batchIndexer.startup();
        }
    }

    public void shutdown() throws ResourceException {
        if (this.batchIndexer != null) {
            this.batchIndexer.shutdown();
        }
        if (this.defaultHttpClientHandler != null) {
            try {
                this.defaultHttpClientHandler.close();
            }
            catch (IOException e) {
                throw ResourceException.newResourceException((int)500, (String)"An error occurred while closing the default HTTP client handler", (Throwable)e);
            }
        }
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, final String topic, QueryRequest query, final QueryResourceHandler handler) {
        int pageSize;
        int n = pageSize = query.getPageSize() <= 0 ? 10 : query.getPageSize();
        final int offset = query.getPagedResultsOffset() != 0 ? query.getPagedResultsOffset() : (query.getPagedResultsCookie() != null ? Integer.valueOf(query.getPagedResultsCookie()) : 0);
        JsonValue payload = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)QUERY, (Object)((JsonValue)query.getQueryFilter().accept((QueryFilterVisitor)ELASTICSEARCH_QUERY_FILTER_VISITOR, null)).getObject())}));
        try {
            Request request = this.createRequest(GET, this.buildSearchUri(topic, pageSize, offset), payload.getObject());
            return this.client.send(request).then(CloseSilentlyFunction.closeSilently((Function)new Function<Response, QueryResponse, ResourceException>(){

                public QueryResponse apply(Response response) throws ResourceException {
                    if (!response.getStatus().isSuccessful()) {
                        String message = "Elasticsearch response (" + ElasticsearchAuditEventHandler.this.indexName + "/" + topic + ElasticsearchAuditEventHandler.SEARCH + "): " + response.getEntity();
                        throw ResourceException.newResourceException((int)response.getStatus().getCode(), (String)message);
                    }
                    try {
                        JsonValue events = JsonValue.json((Object)response.getEntity().getJson());
                        for (JsonValue event : events.get(ElasticsearchAuditEventHandler.HITS).get(ElasticsearchAuditEventHandler.HITS)) {
                            handler.handleResource(org.forgerock.json.resource.Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)ElasticsearchUtil.denormalizeJson((JsonValue)event.get(ElasticsearchAuditEventHandler.SOURCE))));
                        }
                        int totalResults = events.get(ElasticsearchAuditEventHandler.HITS).get(ElasticsearchAuditEventHandler.TOTAL).asInteger();
                        String pagedResultsCookie = pageSize + offset >= totalResults ? null : Integer.toString(pageSize + offset);
                        return org.forgerock.json.resource.Responses.newQueryResponse((String)pagedResultsCookie, (CountPolicy)CountPolicy.EXACT, (int)totalResults);
                    }
                    catch (IOException e) {
                        throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
                    }
                }
            }), Responses.noopExceptionFunction());
        }
        catch (URISyntaxException e) {
            return new InternalServerErrorException(e.getMessage(), (Throwable)e).asPromise();
        }
    }

    public Promise<ResourceResponse, ResourceException> readEvent(Context context, final String topic, final String resourceId) {
        Request request;
        try {
            request = this.createRequest(GET, this.buildEventUri(topic, resourceId), null);
        }
        catch (Exception e) {
            String error = String.format("Unable to read audit entry for topic=%s, _id=%s", topic, resourceId);
            LOGGER.error(error, (Throwable)e);
            return new InternalServerErrorException(error, (Throwable)e).asPromise();
        }
        return this.client.send(request).then(CloseSilentlyFunction.closeSilently((Function)new Function<Response, ResourceResponse, ResourceException>(){

            public ResourceResponse apply(Response response) throws ResourceException {
                if (!response.getStatus().isSuccessful()) {
                    throw ElasticsearchAuditEventHandler.resourceException(ElasticsearchAuditEventHandler.this.indexName, topic, resourceId, response);
                }
                try {
                    JsonValue jsonValue = JsonValue.json((Object)response.getEntity().getJson());
                    jsonValue = ElasticsearchUtil.denormalizeJson((JsonValue)jsonValue.get(ElasticsearchAuditEventHandler.SOURCE));
                    jsonValue.put("_id", (Object)resourceId);
                    return org.forgerock.json.resource.Responses.newResourceResponse((String)resourceId, null, (JsonValue)jsonValue);
                }
                catch (IOException e) {
                    throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
                }
            }
        }), Responses.noopExceptionFunction());
    }

    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String topic, JsonValue event) {
        if (this.batchIndexer == null) {
            return this.publishSingleEvent(topic, event);
        }
        if (!this.batchIndexer.offer(topic, event)) {
            return new ServiceUnavailableException("Elasticsearch batch indexer full, so dropping audit event " + this.indexName + "/" + topic + "/" + event.get("_id").asString()).asPromise();
        }
        return org.forgerock.json.resource.Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event).asPromise();
    }

    protected Promise<ResourceResponse, ResourceException> publishSingleEvent(final String topic, final JsonValue event) {
        final String resourceId = event.get("_id").asString();
        event.remove("_id");
        try {
            String jsonPayload = ElasticsearchUtil.normalizeJson((JsonValue)event);
            event.put("_id", (Object)resourceId);
            Request request = this.createRequest(PUT, this.buildEventUri(topic, resourceId), jsonPayload);
            return this.client.send(request).then(CloseSilentlyFunction.closeSilently((Function)new Function<Response, ResourceResponse, ResourceException>(){

                public ResourceResponse apply(Response response) throws ResourceException {
                    if (!response.getStatus().isSuccessful()) {
                        throw ElasticsearchAuditEventHandler.resourceException(ElasticsearchAuditEventHandler.this.indexName, topic, resourceId, response);
                    }
                    return org.forgerock.json.resource.Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event);
                }
            }), Responses.noopExceptionFunction());
        }
        catch (Exception e) {
            String error = String.format("Unable to create audit entry for topic=%s, _id=%s", topic, resourceId);
            LOGGER.error(error, (Throwable)e);
            return new InternalServerErrorException(error, (Throwable)e).asPromise();
        }
    }

    public void addToBatch(String topic, JsonValue event, StringBuilder payload) throws BatchException {
        try {
            String resourceId = event.get("_id").asString();
            event.remove("_id");
            String jsonPayload = ElasticsearchUtil.normalizeJson((JsonValue)event);
            event.put("_id", (Object)resourceId);
            payload.append("{ \"index\" : { \"_type\" : ").append(ElasticsearchUtil.OBJECT_MAPPER.writeValueAsString((Object)topic)).append(", \"_id\" : ").append(ElasticsearchUtil.OBJECT_MAPPER.writeValueAsString((Object)resourceId)).append(" } }\n").append(jsonPayload).append('\n');
        }
        catch (IOException e) {
            throw new BatchException("Unexpected error while adding to batch", (Throwable)e);
        }
    }

    public Promise<Void, BatchException> publishBatch(String payload) {
        Request request;
        try {
            request = this.createRequest(POST, this.buildBulkUri(), payload);
        }
        catch (URISyntaxException e) {
            return Promises.newExceptionPromise((Exception)new BatchException("Incorrect URI", (Throwable)e));
        }
        return this.client.send(request).then(CloseSilentlyFunction.closeSilently(this.processBatchResponse()), Responses.noopExceptionFunction());
    }

    private Function<Response, Void, BatchException> processBatchResponse() {
        return new Function<Response, Void, BatchException>(){

            public Void apply(Response response) throws BatchException {
                try {
                    if (!response.getStatus().isSuccessful()) {
                        throw new BatchException("Elasticsearch batch index failed: " + response.getEntity());
                    }
                    JsonValue responseJson = JsonValue.json((Object)response.getEntity().getJson());
                    if (responseJson.get("errors").asBoolean().booleanValue()) {
                        JsonValue items = responseJson.get("items");
                        int n = items.size();
                        ArrayList<JsonValue> failureItems = new ArrayList<JsonValue>(n);
                        for (int i = 0; i < n; ++i) {
                            JsonValue item = items.get(i).get("index");
                            Integer status = item.get("status").asInteger();
                            if (status < 400) continue;
                            failureItems.add(item);
                        }
                        String message = "One or more Elasticsearch batch index entries failed: " + ElasticsearchUtil.OBJECT_MAPPER.writeValueAsString(failureItems);
                        throw new BatchException(message);
                    }
                }
                catch (IOException e) {
                    throw new BatchException("Unexpected error while publishing batch", (Throwable)e);
                }
                return null;
            }
        };
    }

    protected String buildBasicAuthHeaderValue() {
        if (this.basicAuthHeaderValue != null) {
            return this.basicAuthHeaderValue;
        }
        ElasticsearchAuditEventHandlerConfiguration.ConnectionConfiguration connection = this.configuration.getConnection();
        if (connection.getUsername() == null || connection.getUsername().isEmpty() || connection.getPassword() == null || connection.getPassword().isEmpty()) {
            return null;
        }
        String credentials = connection.getUsername() + ":" + connection.getPassword();
        return "Basic " + Base64.encode((byte[])credentials.getBytes());
    }

    protected String buildEventUri(String topic, String eventId) {
        return this.buildBaseUri() + "/" + topic + "/" + eventId;
    }

    protected String buildBulkUri() {
        if (this.bulkUri != null) {
            return this.bulkUri;
        }
        return this.buildBaseUri() + BULK;
    }

    protected String buildSearchUri(String topic, int pageSize, int offset) {
        return this.buildBaseUri() + "/" + topic + SEARCH + "?size=" + pageSize + "&from=" + offset;
    }

    protected String buildBaseUri() {
        if (this.baseUri != null) {
            return this.baseUri;
        }
        ElasticsearchAuditEventHandlerConfiguration.ConnectionConfiguration connection = this.configuration.getConnection();
        return (connection.isUseSSL() ? "https" : "http") + "://" + connection.getHost() + ":" + connection.getPort() + "/" + this.indexName;
    }

    protected static ResourceException resourceException(String indexName, String topic, String resourceId, Response response) {
        if (response.getStatus().getCode() == 404) {
            return new NotFoundException("Object " + resourceId + " not found in " + indexName + "/" + topic);
        }
        String message = "Elasticsearch response (" + indexName + "/" + topic + "/" + resourceId + "): " + response.getEntity();
        return ResourceException.newResourceException((int)response.getStatus().getCode(), (String)message);
    }

    private Request createRequest(String method, String uri, Object payload) throws URISyntaxException {
        Request request = new Request();
        request.setMethod(method);
        request.setUri(uri);
        if (payload != null) {
            request.getHeaders().put("Content-Type", (Object)"application/json; charset=UTF-8");
            request.setEntity(payload);
        }
        if (this.basicAuthHeaderValue != null) {
            request.getHeaders().put("Authorization", (Object)this.basicAuthHeaderValue);
        }
        return request;
    }

    private HttpClientHandler defaultHttpClientHandler() {
        try {
            return new HttpClientHandler(Options.defaultOptions().set(HttpClientHandler.OPTION_LOADER, (Object)new Loader(){

                public <S> S load(Class<S> service, Options options) {
                    return service.cast(new AsyncHttpClientProvider());
                }
            }));
        }
        catch (HttpApplicationException e) {
            throw new RuntimeException("Error while building default HTTP Client", e);
        }
    }
}

