/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.CLI;
import com.persistit.Persistit;
import com.persistit.Task;
import com.persistit.VolumeSpecification;
import com.persistit.exception.CorruptVolumeException;
import com.persistit.exception.InvalidVolumeSpecificationException;
import com.persistit.exception.PersistitIOException;
import com.persistit.util.ArgParser;
import com.persistit.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

class VolumeHeader {
    private static final String[] ARGS_TEMPLATE = new String[]{"path|string:|Volume file name"};
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final byte[] SIGNATURE = Util.stringToBytes("PERSISTIT VOLUME");
    private static final int SIZE = 1024;
    private static final int CURRENT_VERSION = 221;
    private static final int MIN_SUPPORTED_VERSION = 210;
    private static final int MAX_SUPPORTED_VERSION = 299;

    VolumeHeader() {
    }

    static boolean verifySignature(byte[] bytes) {
        return Util.bytesEqual(bytes, 0, SIGNATURE);
    }

    static boolean putSignature(byte[] bytes) {
        return Util.changeBytes(bytes, 0, SIGNATURE);
    }

    static int getVersion(byte[] bytes) {
        return Util.getInt(bytes, 16);
    }

    static void putVersion(byte[] bytes) {
        Util.putInt(bytes, 16, 221);
    }

    static int getPageSize(byte[] bytes) {
        return Util.getInt(bytes, 20);
    }

    static void putPageSize(byte[] bytes, int value) {
        Util.putInt(bytes, 20, value);
    }

    static long getTimestamp(byte[] bytes) {
        return Util.getLong(bytes, 24);
    }

    static boolean changeTimestamp(byte[] bytes, long value) {
        return Util.changeLong(bytes, 24, value);
    }

    static long getId(byte[] bytes) {
        return Util.getLong(bytes, 32);
    }

    static void putId(byte[] bytes, long value) {
        Util.putLong(bytes, 32, value);
    }

    static long getReadCounter(byte[] bytes) {
        return Util.getLong(bytes, 40);
    }

    static boolean changeReadCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 40, value);
    }

    static long getWriteCounter(byte[] bytes) {
        return Util.getLong(bytes, 48);
    }

    static boolean changeWriteCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 48, value);
    }

    static long getGetCounter(byte[] bytes) {
        return Util.getLong(bytes, 56);
    }

    static boolean changeGetCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 56, value);
    }

    static long getOpenTime(byte[] bytes) {
        return Util.getLong(bytes, 64);
    }

    static boolean changeOpenTime(byte[] bytes, long value) {
        return Util.changeLong(bytes, 64, value);
    }

    static long getCreateTime(byte[] bytes) {
        return Util.getLong(bytes, 72);
    }

    static boolean changeCreateTime(byte[] bytes, long value) {
        return Util.changeLong(bytes, 72, value);
    }

    static long getLastReadTime(byte[] bytes) {
        return Util.getLong(bytes, 80);
    }

    static boolean changeLastReadTime(byte[] bytes, long value) {
        return Util.changeLong(bytes, 80, value);
    }

    static long getLastWriteTime(byte[] bytes) {
        return Util.getLong(bytes, 88);
    }

    static boolean changeLastWriteTime(byte[] bytes, long value) {
        return Util.changeLong(bytes, 88, value);
    }

    static long getLastExtensionTime(byte[] bytes) {
        return Util.getLong(bytes, 96);
    }

    static boolean changeLastExtensionTime(byte[] bytes, long value) {
        return Util.changeLong(bytes, 96, value);
    }

    static long getNextAvailablePage(byte[] bytes) {
        return Util.getLong(bytes, 104) + 1L;
    }

    static boolean changeNextAvailablePage(byte[] bytes, long value) {
        return Util.changeLong(bytes, 104, value - 1L);
    }

    static long getExtendedPageCount(byte[] bytes) {
        return Util.getLong(bytes, 112);
    }

    static boolean changeExtendedPageCount(byte[] bytes, long value) {
        return Util.changeLong(bytes, 112, value);
    }

    static long getExtensionPages(byte[] bytes) {
        return Util.getLong(bytes, 120);
    }

    static boolean changeExtensionPages(byte[] bytes, long value) {
        return Util.changeLong(bytes, 120, value);
    }

    static long getMaximumPages(byte[] bytes) {
        return Util.getLong(bytes, 128);
    }

    static boolean changeMaximumPages(byte[] bytes, long value) {
        return Util.changeLong(bytes, 128, value);
    }

    static long getDirectoryRoot(byte[] bytes) {
        return Util.getLong(bytes, 144);
    }

    static boolean changeDirectoryRoot(byte[] bytes, long value) {
        return Util.changeLong(bytes, 144, value);
    }

    static long getGarbageRoot(byte[] bytes) {
        return Util.getLong(bytes, 152);
    }

    static boolean changeGarbageRoot(byte[] bytes, long value) {
        return Util.changeLong(bytes, 152, value);
    }

    static long getfetchCounter(byte[] bytes) {
        return Util.getLong(bytes, 160);
    }

    static boolean changeFetchCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 160, value);
    }

    static long getTraverseCounter(byte[] bytes) {
        return Util.getLong(bytes, 168);
    }

    static boolean changeTraverseCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 168, value);
    }

    static long getStoreCounter(byte[] bytes) {
        return Util.getLong(bytes, 176);
    }

    static boolean changeStoreCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 176, value);
    }

    static long getRemoveCounter(byte[] bytes) {
        return Util.getLong(bytes, 184);
    }

    static boolean changeRemoveCounter(byte[] bytes, long value) {
        return Util.changeLong(bytes, 184, value);
    }

    static long getInitialPages(byte[] bytes) {
        return Util.getLong(bytes, 192);
    }

    static boolean changeInitialPages(byte[] bytes, long value) {
        return Util.changeLong(bytes, 192, value);
    }

    static long getGlobalTimestamp(byte[] bytes) {
        return Util.getLong(bytes, 200);
    }

    static boolean changeGlobalTimestamp(byte[] bytes, long value) {
        return Util.changeLong(bytes, 200, value);
    }

    public static boolean verifyVolumeHeader(VolumeSpecification specification, long systemTimestamp) throws CorruptVolumeException, InvalidVolumeSpecificationException, PersistitIOException {
        FileInputStream stream = null;
        try {
            File file = new File(specification.getPath());
            if (file.exists()) {
                long id;
                int pageSize;
                int version;
                if (file.isFile()) {
                    stream = new FileInputStream(file);
                    byte[] bytes = new byte[1024];
                    int readSize = stream.read(bytes);
                    if (readSize < 1024) {
                        throw new CorruptVolumeException("Volume file " + file + " too short: " + readSize);
                    }
                    if (!VolumeHeader.verifySignature(bytes)) {
                        throw new CorruptVolumeException("Invalid signature");
                    }
                    version = VolumeHeader.getVersion(bytes);
                    if (version < 210 || version > 299) {
                        throw new CorruptVolumeException("Version " + version + " is not supported by Persistit version " + Persistit.version());
                    }
                    pageSize = VolumeHeader.getPageSize(bytes);
                    long nextAvailablePage = VolumeHeader.getNextAvailablePage(bytes);
                    id = VolumeHeader.getId(bytes);
                    long totalPages = file.length() / (long)pageSize;
                    if (totalPages < nextAvailablePage) {
                        throw new CorruptVolumeException(String.format("Volume has been truncated: minimum required/actual lengths=%,d/%,d bytes", nextAvailablePage * (long)pageSize, file.length()));
                    }
                    long globalTimestamp = VolumeHeader.getGlobalTimestamp(bytes);
                    if (globalTimestamp > systemTimestamp) {
                        throw new CorruptVolumeException("Volume " + file + " has a global timestamp greater than system timestamp: " + globalTimestamp + " > " + systemTimestamp);
                    }
                } else {
                    throw new CorruptVolumeException("Volume file " + file + " is a directory");
                }
                specification.setVersion(version);
                specification.setPageSize(pageSize);
                specification.setId(id);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw new PersistitIOException(ioe);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getCurrentVersion() {
        return 221;
    }

    @CLI.Cmd(value="volumeinfo")
    static VolumeInfoTask createTask(@CLI.Arg(value="file|string:|Volume file") String file) throws Exception {
        return new VolumeInfoTask(file);
    }

    public static void main(String[] args) throws Exception {
        ArgParser ap = new ArgParser("VolumeHeader", args, ARGS_TEMPLATE).strict();
        if (ap.isUsageOnly()) {
            return;
        }
        VolumeInfoTask task = new VolumeInfoTask(ap.getStringValue("path"));
        task.setMessageWriter(new PrintWriter(System.out));
        ((Task)task).runTask();
    }

    private static class VolumeInfoTask
    extends Task {
        String _volumeFileName;

        private VolumeInfoTask(String fileName) {
            this._volumeFileName = fileName;
        }

        @Override
        protected void runTask() throws Exception {
            File file = new File(this._volumeFileName);
            FileInputStream stream = new FileInputStream(file);
            byte[] bytes = new byte[1024];
            int readSize = stream.read(bytes);
            stream.close();
            if (readSize < 1024) {
                throw new CorruptVolumeException(String.format("File %s of size %,d is too short to be a Volume file\n", file, readSize));
            }
            if (!VolumeHeader.verifySignature(bytes)) {
                throw new CorruptVolumeException(String.format("File %s is not a Volume file: Invalid signature", file));
            }
            this.postMessage(String.format("%30s: %s", "File", file), 0);
            this.outn("ID", VolumeHeader.getId(bytes));
            this.outn("Page size", VolumeHeader.getPageSize(bytes));
            this.outd("Creation time", VolumeHeader.getCreateTime(bytes));
            this.outd("Last open time", VolumeHeader.getOpenTime(bytes));
            this.outd("Last extension time", VolumeHeader.getLastExtensionTime(bytes));
            this.outd("Last read time", VolumeHeader.getLastReadTime(bytes));
            this.outd("Last write time", VolumeHeader.getLastWriteTime(bytes));
            this.outn("Global timestamp", VolumeHeader.getGlobalTimestamp(bytes));
            this.outn("Timestamp", VolumeHeader.getTimestamp(bytes));
            this.outn("Version", VolumeHeader.getVersion(bytes));
            this.outn("Directory root", VolumeHeader.getDirectoryRoot(bytes));
            this.outn("Garbage root", VolumeHeader.getGarbageRoot(bytes));
            this.outn("Initial pages", VolumeHeader.getInitialPages(bytes));
            this.outn("Next available page", VolumeHeader.getNextAvailablePage(bytes));
            this.outn("Extended page count", VolumeHeader.getExtendedPageCount(bytes));
            this.outn("Pages per extension", VolumeHeader.getExtensionPages(bytes));
            this.outn("Maximum pages", VolumeHeader.getMaximumPages(bytes));
            this.outn("Fetch counter", VolumeHeader.getfetchCounter(bytes));
            this.outn("Get counter", VolumeHeader.getGetCounter(bytes));
            this.outn("Read counter", VolumeHeader.getReadCounter(bytes));
            this.outn("Remove counter", VolumeHeader.getRemoveCounter(bytes));
            this.outn("Store counter", VolumeHeader.getStoreCounter(bytes));
            this.outn("Traverse counter", VolumeHeader.getTraverseCounter(bytes));
            this.outn("Write counter", VolumeHeader.getWriteCounter(bytes));
        }

        private void outd(String legend, long value) {
            this.postMessage(String.format("%30s: %s", legend, SDF.format(new Date(value))), 0);
        }

        private void outn(String legend, long value) {
            this.postMessage(String.format("%30s: %,12d", legend, value), 0);
        }

        @Override
        public String getStatus() {
            return "";
        }
    }
}

