/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.KeyFilter;
import com.persistit.KeyParser;
import com.persistit.Tree;
import com.persistit.Volume;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class TreeSelector {
    private static final char WILD_MULTI = '*';
    private static final char WILD_ONE = '?';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char NUL = '\u0000';
    private static final String CAN_BE_QUOTED = "*?,";
    private static final String REGEX_QUOTE = "^$*+?()[].";
    private final List<Selector> _terms = new ArrayList<Selector>();

    public static TreeSelector parseSelector(String spec, boolean regex, char quote) {
        TreeSelector treeSelector = new TreeSelector();
        if ("*".equals(spec)) {
            return treeSelector;
        }
        Selector s = new Selector();
        State state = State.V;
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        int size = spec.length() + 1;
        block6: for (int index = 0; index < size; ++index) {
            char c;
            char c2 = c = index + 1 < size ? spec.charAt(index) : (char)'\u0000';
            if (quoted) {
                sb.append(c);
                quoted = false;
                continue;
            }
            if (c == quote && index < size - 2 && CAN_BE_QUOTED.indexOf(spec.charAt(index + 1)) > 0) {
                quoted = true;
                continue;
            }
            switch (state) {
                case V: {
                    if (c == '\u0000' && sb.length() == 0) continue block6;
                    if (c == '*' && !regex) {
                        sb.append(".*");
                        continue block6;
                    }
                    if (c == '?' && !regex) {
                        sb.append(".");
                        continue block6;
                    }
                    if (!regex && REGEX_QUOTE.indexOf(c) != -1) {
                        sb.append('\\');
                        sb.append(c);
                        continue block6;
                    }
                    if (c == ':' || c == ',' || c == '\u0000') {
                        s._vpattern = Pattern.compile(sb.toString());
                        sb.setLength(0);
                        if (c == ':') {
                            state = State.T;
                            continue block6;
                        }
                        treeSelector._terms.add(s);
                        s = new Selector();
                        state = State.V;
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case T: {
                    if (c == '*' && !regex) {
                        sb.append(".*");
                        continue block6;
                    }
                    if (c == '?' && !regex) {
                        sb.append(".");
                        continue block6;
                    }
                    if (!regex && REGEX_QUOTE.indexOf(c) != -1) {
                        sb.append('\\');
                        sb.append(c);
                        continue block6;
                    }
                    if (c == '{' || c == ',' || c == '\u0000') {
                        s._tpattern = Pattern.compile(sb.toString());
                        sb.setLength(0);
                        if (c == '{') {
                            state = State.K;
                            sb.append(c);
                            continue block6;
                        }
                        treeSelector._terms.add(s);
                        s = new Selector();
                        state = State.V;
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case K: {
                    sb.append(c);
                    if (c != '}' && c != '\u0000') continue block6;
                    s._keyFilter = new KeyParser(sb.toString()).parseKeyFilter();
                    treeSelector._terms.add(s);
                    s = new Selector();
                    sb.setLength(0);
                    state = State.C;
                    continue block6;
                }
                case C: {
                    if (c == ',' || c == '\u0000') {
                        state = State.V;
                        continue block6;
                    }
                    throw new IllegalArgumentException("at index=" + index);
                }
            }
        }
        return treeSelector;
    }

    public boolean isSelectAll() {
        return this._terms.isEmpty();
    }

    public int size() {
        return this._terms.size();
    }

    public boolean isSelected(Volume volume) {
        return this.isVolumeNameSelected(volume.getName());
    }

    public boolean isSelected(Tree tree) {
        return this.isTreeNameSelected(tree.getVolume().getName(), tree.getName());
    }

    public boolean isVolumeNameSelected(String volumeName) {
        if (this._terms.isEmpty()) {
            return true;
        }
        for (Selector selector : this._terms) {
            if (selector._vpattern != null && !selector._vpattern.matcher(volumeName).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isVolumeOnlySelection(String volumeName) {
        if (this._terms.isEmpty()) {
            return true;
        }
        for (Selector selector : this._terms) {
            if (selector._vpattern != null && !selector._vpattern.matcher(volumeName).matches() || selector._tpattern != null || selector._keyFilter != null) continue;
            return true;
        }
        return false;
    }

    public boolean isTreeNameSelected(String volumeName, String treeName) {
        if (this._terms.isEmpty()) {
            return true;
        }
        for (Selector selector : this._terms) {
            if (selector._vpattern != null && !selector._vpattern.matcher(volumeName).matches() || selector._tpattern != null && !selector._tpattern.matcher(treeName).matches()) continue;
            return true;
        }
        return false;
    }

    public KeyFilter keyFilter(String volumeName, String treeName) {
        KeyFilter kf = null;
        for (Selector selector : this._terms) {
            if (selector._vpattern != null && !selector._vpattern.matcher(volumeName).matches() || selector._tpattern != null && !selector._tpattern.matcher(treeName).matches()) continue;
            if (kf == null) {
                kf = selector._keyFilter;
                if (kf != null) continue;
                kf = new KeyFilter();
                continue;
            }
            throw new IllegalStateException("Non-unique KeyFilters for tree " + volumeName + "/" + treeName);
        }
        return kf;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Selector ts : this._terms) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(ts.toString());
        }
        return sb.toString();
    }

    private static enum State {
        V,
        T,
        K,
        C;

    }

    private static class Selector {
        Pattern _vpattern;
        Pattern _tpattern;
        KeyFilter _keyFilter;

        private Selector() {
        }

        private boolean isNull() {
            return this._vpattern == null && this._tpattern == null && this._keyFilter == null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._vpattern);
            if (this._tpattern != null) {
                sb.append(':');
                sb.append(this._tpattern);
                if (this._keyFilter != null) {
                    sb.append(this._keyFilter);
                }
            }
            return sb.toString();
        }
    }
}

