/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.TimestampAllocator;
import com.persistit.TransactionIndex;
import com.persistit.TransactionStatus;
import com.persistit.exception.RetryException;
import java.util.concurrent.locks.ReentrantLock;

class TransactionIndexBucket {
    final TransactionIndex _transactionIndex;
    final int _hashIndex;
    volatile long _floor = Long.MAX_VALUE;
    volatile TransactionStatus _current;
    int _currentCount;
    volatile TransactionStatus _aborted;
    int _abortedCount;
    volatile TransactionStatus _longRunning;
    int _longRunningCount;
    volatile TransactionStatus _free;
    int _freeCount;
    int _droppedCount;
    long _activeTransactionFloor;
    ReentrantLock _lock = new ReentrantLock(true);
    Accumulator.Delta _freeDeltaList;
    int _freeDeltaCount;

    TransactionIndexBucket(TransactionIndex transactionIndex, int hashIndex) {
        this._transactionIndex = transactionIndex;
        this._hashIndex = hashIndex;
    }

    void lock() {
        this._lock.lock();
    }

    void unlock() {
        this._lock.unlock();
    }

    TransactionStatus allocateTransactionStatus() throws InterruptedException {
        assert (this._lock.isHeldByCurrentThread());
        TransactionStatus status = this._free;
        if (status != null) {
            if (status.isLocked()) {
                status.briefLock(500L);
            }
            assert (!status.isLocked());
            this._free = status.getNext();
            --this._freeCount;
            status.setNext(null);
            return status;
        }
        return new TransactionStatus(this);
    }

    void addCurrent(TransactionStatus status) {
        assert (this._lock.isHeldByCurrentThread());
        status.setNext(this._current);
        if (status.getTs() < this._floor) {
            this._floor = status.getTs();
        }
        this._current = status;
        ++this._currentCount;
    }

    void addAborted(TransactionStatus status) {
        assert (this._lock.isHeldByCurrentThread());
        status.setNext(this._aborted);
        this._aborted = status;
        ++this._abortedCount;
    }

    int getIndex() {
        return this._hashIndex;
    }

    TransactionStatus getCurrent() {
        return this._current;
    }

    TransactionStatus getAborted() {
        return this._aborted;
    }

    TransactionStatus getLongRunning() {
        return this._longRunning;
    }

    long getFloor() {
        return this._floor;
    }

    int getCurrentCount() {
        return this._currentCount;
    }

    int getLongRunningCount() {
        return this._longRunningCount;
    }

    int getAbortedCount() {
        return this._abortedCount;
    }

    int getFreeCount() {
        return this._freeCount;
    }

    int getDroppedCount() {
        return this._droppedCount;
    }

    TimestampAllocator getTimestampAllocator() {
        return this._transactionIndex.getTimestampAllocator();
    }

    boolean hasFloorMoved() {
        return this._activeTransactionFloor != this._transactionIndex.getActiveTransactionFloor();
    }

    void notifyCompleted(TransactionStatus status, long timestamp) {
        assert (this._lock.isHeldByCurrentThread());
        long ts = status.getTs();
        if (ts >= this.getFloor()) {
            for (TransactionStatus s = this.getCurrent(); s != null; s = s.getNext()) {
                if (s != status) continue;
                status.completeAndUnlock(timestamp);
                if (s.getTs() == this.getFloor() || this.hasFloorMoved()) {
                    this.reduce();
                }
                return;
            }
        } else {
            TransactionStatus previous = null;
            for (TransactionStatus s = this.getLongRunning(); s != null; s = s.getNext()) {
                if (s == status) {
                    TransactionStatus next = s.getNext();
                    assert (s.getTc() != Long.MAX_VALUE);
                    status.completeAndUnlock(timestamp);
                    boolean moved = false;
                    if (s.getTc() == Long.MIN_VALUE) {
                        this.aggregate(s, false);
                        s.setNext(this._aborted);
                        this._aborted = s;
                        ++this._abortedCount;
                        moved = true;
                    } else assert (s.getTc() >= this._activeTransactionFloor);
                    if (moved) {
                        if (previous == null) {
                            this._longRunning = next;
                        } else {
                            previous.setNext(next);
                        }
                        --this._longRunningCount;
                    }
                    return;
                }
                previous = s;
            }
        }
        throw new IllegalStateException("No such transaction  " + status);
    }

    void reduce() {
        assert (this._lock.isHeldByCurrentThread());
        boolean hasMoved = this.hasFloorMoved();
        this._activeTransactionFloor = this._transactionIndex.getActiveTransactionFloor();
        boolean more = true;
        while (more) {
            more = false;
            TransactionStatus previous = null;
            long newFloor = Long.MAX_VALUE;
            TransactionStatus status = this._current;
            while (status != null) {
                TransactionStatus next = status.getNext();
                assert (status.getTs() >= this._floor);
                boolean aborted = this.isAborted(status);
                boolean committed = this.isCommitted(status);
                if (status.getTs() == this._floor) {
                    boolean moved = false;
                    if (committed && this.isObsolete(status)) {
                        this.aggregate(status, true);
                        this.free(status);
                        moved = true;
                    } else if (aborted) {
                        this.aggregate(status, false);
                        status.setNext(this._aborted);
                        this._aborted = status;
                        ++this._abortedCount;
                        moved = true;
                    } else if (this._currentCount > this._transactionIndex.getLongRunningThreshold()) {
                        status.setNext(this._longRunning);
                        this._longRunning = status;
                        ++this._longRunningCount;
                        moved = true;
                    }
                    if (moved) {
                        if (previous != null) {
                            previous.setNext(next);
                        } else {
                            this._current = next;
                        }
                        --this._currentCount;
                        status = next;
                        more = true;
                    } else {
                        newFloor = this._floor;
                        previous = status;
                    }
                } else {
                    if (status.getTs() < newFloor) {
                        newFloor = status.getTs();
                    }
                    previous = status;
                }
                status = next;
            }
            this._floor = newFloor;
        }
        if (hasMoved) {
            this.cleanup(this._activeTransactionFloor);
        }
    }

    void cleanup(long activeTransactionFloor) {
        TransactionStatus next;
        assert (this._lock.isHeldByCurrentThread());
        TransactionStatus previous = null;
        TransactionStatus status = this._aborted;
        while (status != null) {
            next = status.getNext();
            assert (status.getTc() == Long.MIN_VALUE);
            if (status.getMvvCount() == 0 && status.getTa() < activeTransactionFloor && status.isNotified()) {
                this.aggregate(status, false);
                if (previous == null) {
                    this._aborted = next;
                } else {
                    previous.setNext(next);
                }
                --this._abortedCount;
                this.free(status);
            } else {
                previous = status;
            }
            status = next;
        }
        previous = null;
        status = this._longRunning;
        while (status != null) {
            next = status.getNext();
            if (status.isNotified() && this.isCommitted(status) && this.isObsolete(status)) {
                this.aggregate(status, true);
                if (previous == null) {
                    this._longRunning = next;
                } else {
                    previous.setNext(next);
                }
                --this._longRunningCount;
                this.free(status);
            } else {
                previous = status;
            }
            status = next;
        }
    }

    int resetMVVCounts(long timestamp) {
        TransactionStatus status;
        int count = 0;
        for (status = this._current; status != null; status = status.getNext()) {
            if (status.getTc() != Long.MIN_VALUE || status.getTs() >= timestamp || status.getMvvCount() <= 0) continue;
            status.setMvvCount(0);
            ++count;
        }
        for (status = this._aborted; status != null; status = status.getNext()) {
            assert (status.getTc() == Long.MIN_VALUE);
            if (status.getTs() >= timestamp || status.getMvvCount() <= 0) continue;
            status.setMvvCount(0);
            ++count;
        }
        return count;
    }

    boolean isEmpty() {
        return this._abortedCount + this._currentCount + this._longRunningCount == 0;
    }

    private boolean isAborted(TransactionStatus status) {
        return status.getTc() == Long.MIN_VALUE && status.isNotified();
    }

    private boolean isCommitted(TransactionStatus status) {
        return status.getTc() > 0L && status.getTc() != Long.MAX_VALUE && status.isNotified();
    }

    private boolean isObsolete(TransactionStatus status) {
        return status.getTc() < this._activeTransactionFloor;
    }

    private void aggregate(TransactionStatus status, boolean committed) {
        assert (this._lock.isHeldByCurrentThread());
        Accumulator.Delta delta = status.takeDelta();
        while (delta != null) {
            if (committed) {
                delta.getAccumulator().aggregate(this._hashIndex, delta);
            }
            delta.setAccumulator(null);
            delta = this.freeDelta(delta);
        }
    }

    long getAccumulatorSnapshot(Accumulator accumulator, long timestamp, int step) throws RetryException, InterruptedException {
        assert (this._lock.isHeldByCurrentThread());
        long value = accumulator.getBucketValue(this._hashIndex);
        value = this.accumulatorSnapshotHelper(this._current, accumulator, timestamp, step, value);
        value = this.accumulatorSnapshotHelper(this._longRunning, accumulator, timestamp, step, value);
        return value;
    }

    private long accumulatorSnapshotHelper(TransactionStatus start, Accumulator accumulator, long timestamp, int step, long initialValue) throws RetryException, InterruptedException {
        long value = initialValue;
        for (TransactionStatus status = start; status != null; status = status.getNext()) {
            Accumulator.Delta delta;
            long tc = status.getTc();
            if (status.getTs() == timestamp) {
                for (delta = status.getDelta(); delta != null; delta = delta.getNext()) {
                    if (delta.getAccumulator() != accumulator || delta.getStep() > step) continue;
                    value = accumulator.applyValue(value, delta.getValue());
                }
                continue;
            }
            if (tc > 0L && tc != Long.MAX_VALUE && tc < timestamp) {
                for (delta = status.getDelta(); delta != null; delta = delta.getNext()) {
                    if (delta.getAccumulator() != accumulator) continue;
                    value = accumulator.applyValue(value, delta.getValue());
                }
                continue;
            }
            if (tc >= 0L || tc == Long.MIN_VALUE || -tc >= timestamp) continue;
            status.briefLock(10L);
            this._transactionIndex.incrementAccumulatorSnapshotRetryCounter();
            throw RetryException.SINGLE;
        }
        return value;
    }

    void checkpointAccumulatorSnapshots(long timestamp) throws RetryException, InterruptedException {
        assert (this._lock.isHeldByCurrentThread());
        this.accumulatorCheckpointHelper(this._current, timestamp);
        this.accumulatorCheckpointHelper(this._longRunning, timestamp);
    }

    private void accumulatorCheckpointHelper(TransactionStatus start, long timestamp) throws RetryException, InterruptedException {
        for (TransactionStatus status = start; status != null; status = status.getNext()) {
            long tc = status.getTc();
            if (tc > 0L && tc != Long.MAX_VALUE && tc < timestamp) {
                for (Accumulator.Delta delta = status.getDelta(); delta != null; delta = delta.getNext()) {
                    Accumulator accumulator = delta.getAccumulator();
                    long newValue = accumulator.applyValue(accumulator.getCheckpointTemp(), delta.getValue());
                    accumulator.setCheckpointTemp(newValue);
                }
                continue;
            }
            if (tc >= 0L || tc == Long.MIN_VALUE || -tc >= timestamp) continue;
            status.briefLock(10L);
            this._transactionIndex.incrementAccumulatorCheckpointRetryCounter();
            throw RetryException.SINGLE;
        }
    }

    private void free(TransactionStatus status) {
        assert (this._lock.isHeldByCurrentThread());
        if (this._freeCount < this._transactionIndex.getMaxFreeListSize()) {
            status.setNext(this._free);
            this._free = status;
            ++this._freeCount;
        } else {
            ++this._droppedCount;
        }
    }

    private Accumulator.Delta freeDelta(Accumulator.Delta delta) {
        Accumulator.Delta next = delta.getNext();
        if (this._freeDeltaCount < this._transactionIndex.getMaxFreeDeltaListSize()) {
            delta.setNext(this._freeDeltaList);
            this._freeDeltaList = delta;
            ++this._freeDeltaCount;
        }
        return next;
    }

    Accumulator.Delta allocateDelta() {
        Accumulator.Delta delta = this._freeDeltaList;
        if (delta != null) {
            this._freeDeltaList = delta.getNext();
            --this._freeDeltaCount;
            return delta;
        }
        return new Accumulator.Delta();
    }

    public String toString() {
        return String.format("<floor=%s current=[%s]\n    aborted=[%s]\n    long=[%s]\n    free=[%s]>", TransactionIndex.minMaxString(this._floor), this.listString(this._current), this.listString(this._aborted), this.listString(this._longRunning), this.listString(this._free));
    }

    String listString(TransactionStatus list) {
        StringBuilder sb = new StringBuilder();
        for (TransactionStatus status = list; status != null; status = status.getNext()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(status);
        }
        return sb.toString();
    }
}

