/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.Persistit;
import com.persistit.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;

public class KeyParser {
    private final String _source;
    private final StringBuilder _sb = new StringBuilder();
    boolean _dp;
    private int _index;
    private final int _start;
    private final int _end;

    public KeyParser(String source) {
        this._source = source;
        this._index = 0;
        this._start = 0;
        this._end = source.length();
    }

    public KeyParser(String source, int offset, int size) {
        if (offset < 0 || offset + size > source.length()) {
            throw new IllegalArgumentException();
        }
        this._source = source;
        this._start = offset;
        this._end = offset + size;
        this._index = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseKey(Key key) {
        int index = this._index;
        boolean result = false;
        boolean first = true;
        try {
            if (this.matchNonWhiteChar(123)) {
                while (true) {
                    int c;
                    if ((c = this.getNonWhiteChar()) == 125) {
                        result = true;
                        break;
                    }
                    if (first) {
                        this.back();
                    } else if (c != 44) break;
                    if (!this.parseKeySegment(key)) break;
                    first = false;
                }
                if (result) {
                    result = this.getNonWhiteChar() == -1;
                }
            }
        }
        finally {
            if (!result) {
                this._index = index;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyFilter parseKeyFilter() {
        int saveIndex = this._index;
        ArrayList<KeyFilter.Term> vector = new ArrayList<KeyFilter.Term>();
        boolean result = false;
        boolean minDepthSet = false;
        boolean maxDepthSet = false;
        int minDepth = 0;
        int maxDepth = Integer.MAX_VALUE;
        Key workKey = new Key((Persistit)null);
        ProtoTerm protoTerm = new ProtoTerm();
        int depth = 0;
        try {
            if (this.matchNonWhiteChar(123)) {
                while (true) {
                    int c;
                    if ((c = this.getNonWhiteChar()) == 125) {
                        result = true;
                        break;
                    }
                    if (depth == 0) {
                        this.back();
                    } else if (c != 44) break;
                    c = this.getNonWhiteChar();
                    if (c == 62 && !minDepthSet) {
                        minDepth = depth + 1;
                        minDepthSet = true;
                        c = this.getNonWhiteChar();
                    }
                    if (c == 123) {
                        KeyFilter.Term[] array = this.parseFilterTermArray(workKey, protoTerm);
                        if (array == null || !this.matchNonWhiteChar(125)) break;
                        vector.add(KeyFilter.orTerm(array));
                    } else {
                        this.back();
                        KeyFilter.Term term = this.parseFilterTerm(workKey, protoTerm);
                        if (term == null) break;
                        vector.add(term);
                    }
                    if (this.matchNonWhiteChar(60) && !maxDepthSet) {
                        maxDepth = depth + 1;
                        maxDepthSet = true;
                    }
                    ++depth;
                }
                if (result) {
                    result = this.getNonWhiteChar() == -1;
                }
            }
        }
        finally {
            if (!result) {
                this._index = saveIndex;
            }
        }
        if (!result) {
            return null;
        }
        KeyFilter.Term[] terms = new KeyFilter.Term[vector.size()];
        for (int index = 0; index < terms.length; ++index) {
            terms[index] = (KeyFilter.Term)vector.get(index);
        }
        return new KeyFilter(terms, minDepth, maxDepth);
    }

    public int getIndex() {
        return this._index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseKeySegment(Key key) {
        int index = this._index;
        int size = key.getEncodedSize();
        boolean result = false;
        try {
            int c = this.getNonWhiteChar();
            if (c == 34 && this.matchQuotedStringTail()) {
                result = true;
                key.append(this._sb);
            } else if (c == 40) {
                this.back();
                if (this.matchExactString("(boolean)")) {
                    result = true;
                    if (this.matchExactString("true")) {
                        key.append(true);
                    } else if (this.matchExactString("false")) {
                        key.append(false);
                    } else {
                        result = false;
                    }
                } else if (this.matchExactString("(byte)")) {
                    if (this.matchNumber(false, false)) {
                        key.append(Byte.parseByte(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(short)")) {
                    if (this.matchNumber(false, false)) {
                        key.append(Short.parseShort(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(char)")) {
                    if (this.matchNumber(false, false)) {
                        key.append((char)Integer.parseInt(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(int)")) {
                    if (this.matchNumber(false, false)) {
                        key.append(Integer.parseInt(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(long)")) {
                    if (this.matchNumber(false, false)) {
                        key.append(Long.parseLong(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(float)")) {
                    if (this.matchNumber(true, false)) {
                        key.append(Float.parseFloat(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(double)")) {
                    if (this.matchNumber(true, false)) {
                        key.append(Double.parseDouble(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(java.math.BigInteger)") || this.matchExactString("(BigInteger)")) {
                    if (this.matchNumber(false, false)) {
                        key.append(new BigInteger(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(java.math.BigDecimal)") || this.matchExactString("(BigDecimal)")) {
                    if (this.matchNumber(true, false)) {
                        key.append(new BigDecimal(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(java.lang.String)") || this.matchExactString("(String)")) {
                    c = this.getNonWhiteChar();
                    if (c == 34 && this.matchQuotedStringTail()) {
                        key.append(this._sb);
                        result = true;
                    }
                } else if (this.matchExactString("(java.util.Date)") || this.matchExactString("(Date)")) {
                    if (this.matchNumber(true, true)) {
                        key.append(Key.SDF.parse(this._sb.toString()));
                        result = true;
                    }
                } else if (this.matchExactString("(byte[])") && this.matchUntil(44, 125)) {
                    this.back();
                    key.append(Util.hexToBytes(this._sb.toString()));
                    result = true;
                }
            } else {
                this.back();
                if (this.matchNumber(true, false)) {
                    if (this._dp) {
                        key.append(Double.parseDouble(this._sb.toString()));
                    } else {
                        key.append(Integer.parseInt(this._sb.toString()));
                    }
                    result = true;
                } else if (this.matchExactString("null")) {
                    key.append(null);
                    result = true;
                } else if (this.matchExactString("true")) {
                    key.append(true);
                    result = true;
                } else if (this.matchExactString("false")) {
                    key.append(false);
                    result = true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
        }
        finally {
            if (!result) {
                this._index = index;
                key.setEncodedSize(size);
            }
        }
        return result;
    }

    private KeyFilter.Term[] parseFilterTermArray(Key workKey, ProtoTerm protoTerm) {
        int c;
        ArrayList<KeyFilter.Term> list = new ArrayList<KeyFilter.Term>();
        do {
            KeyFilter.Term term;
            if ((term = this.parseFilterTerm(workKey, protoTerm)) == null) {
                return null;
            }
            list.add(term);
            c = this.getNonWhiteChar();
            if (c != 125) continue;
            this.back();
            KeyFilter.Term[] array = new KeyFilter.Term[list.size()];
            for (int index = 0; index < array.length; ++index) {
                array[index] = (KeyFilter.Term)list.get(index);
            }
            return array;
        } while (c == 44);
        return null;
    }

    private KeyFilter.Term parseFilterTerm(Key workKey, ProtoTerm protoTerm) {
        int c = this.getNonWhiteChar();
        if (c == 42) {
            return KeyFilter.ALL;
        }
        this.back();
        protoTerm._leftBytes = null;
        protoTerm._rightBytes = null;
        protoTerm._leftInclusive = true;
        protoTerm._rightInclusive = true;
        KeyFilter.Term term = null;
        boolean okay = this.parseKeyFilterRange(workKey, protoTerm);
        if (okay) {
            term = protoTerm.term();
        } else {
            c = this.getNonWhiteChar();
            if (c == 40 || c == 91) {
                protoTerm._leftInclusive = c == 91;
                okay = this.parseKeyFilterRange(workKey, protoTerm);
                if (okay && ((c = this.getNonWhiteChar()) == 41 || c == 93)) {
                    protoTerm._rightInclusive = c == 93;
                    term = protoTerm.term();
                }
            }
        }
        return term;
    }

    boolean parseKeyFilterRange(Key workKey, ProtoTerm protoTerm) {
        workKey.clear();
        int c = this.getNonWhiteChar();
        this.back();
        if (c == 58) {
            workKey.append(Key.BEFORE);
        } else if (!this.parseKeySegment(workKey)) {
            return false;
        }
        protoTerm._leftBytes = KeyParser.segmentBytes(workKey);
        protoTerm._rightBytes = null;
        if (this.matchNonWhiteChar(58)) {
            workKey.clear();
            c = this.getNonWhiteChar();
            this.back();
            if (c == 41 || c == 93 || c == 44 || c == 125 || c == -1) {
                workKey.append(Key.AFTER);
            } else if (!this.parseKeySegment(workKey)) {
                return false;
            }
            protoTerm._rightBytes = KeyParser.segmentBytes(workKey);
        }
        return true;
    }

    static byte[] segmentBytes(Key key) {
        int start = key.getIndex();
        int end = key.nextElementIndex(start);
        if (end == -1) {
            end = key.getEncodedSize();
        }
        byte[] bytes = new byte[end - start];
        System.arraycopy(key.getEncodedBytes(), start, bytes, 0, end - start);
        return bytes;
    }

    private int getNonWhiteChar() {
        int c = this.getChar();
        while (c == 32 || c == 9 || c == 10 || c == 13) {
            c = this.getChar();
        }
        return c;
    }

    private boolean matchNonWhiteChar(int c) {
        return this.getNonWhiteChar() == c ? true : this.back();
    }

    private boolean matchUntil(int c1, int c2) {
        int c;
        this._sb.setLength(0);
        while ((c = this.getChar()) != -1) {
            if (c == c1 || c == c2) {
                return true;
            }
            this._sb.append((char)c);
        }
        return false;
    }

    private boolean matchNumber(boolean decimalPoint, boolean tzsign) {
        this._sb.setLength(0);
        this._dp = false;
        int c = this.getNonWhiteChar();
        if (!(c == 45 || c >= 48 && c <= 57 || c == 46 && decimalPoint)) {
            this.back();
            return false;
        }
        this._sb.append((char)c);
        if (c == 46) {
            decimalPoint = false;
            this._dp = true;
        }
        while ((c = this.getChar()) >= 48 && c <= 57 || decimalPoint && c == 46 || tzsign & (c == 45 || c == 43)) {
            this._sb.append((char)c);
            if (c == 46) {
                decimalPoint = false;
                this._dp = true;
            }
            if (c != 45 && c != 43) continue;
            tzsign = false;
        }
        this.back();
        return true;
    }

    private boolean matchExactString(String s) {
        if (this._source.regionMatches(this._index, s, 0, s.length())) {
            this._index += s.length();
            return true;
        }
        return false;
    }

    private boolean matchQuotedStringTail() {
        boolean escape = false;
        this._sb.setLength(0);
        int c;
        while ((c = this.getChar()) != -1) {
            if (c == 92) {
                if (escape) {
                    this._sb.append('\\');
                }
                escape = !escape;
                continue;
            }
            if (escape) {
                switch (c) {
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        c = this.unicode();
                        if (c != -1) break;
                        return false;
                    }
                }
                this._sb.append((char)c);
                escape = false;
                continue;
            }
            if (c == 92) {
                escape = true;
                continue;
            }
            if (c == 34) {
                return true;
            }
            this._sb.append((char)c);
        }
        return false;
    }

    private int unicode() {
        if (this._index + 4 > this._end) {
            return -1;
        }
        int u = Integer.parseInt(this._source.substring(this._index, this._index + 4), 16);
        this._index += 4;
        return u;
    }

    private int getChar() {
        if (this._index >= 0 && this._index < this._end) {
            return this._source.charAt(this._index++);
        }
        return -1;
    }

    private boolean back() {
        if (this._index > this._start) {
            --this._index;
        }
        return false;
    }

    private static class ProtoTerm {
        byte[] _leftBytes;
        byte[] _rightBytes;
        boolean _leftInclusive;
        boolean _rightInclusive;

        private ProtoTerm() {
        }

        private KeyFilter.Term term() {
            if (this._rightBytes == null) {
                return new KeyFilter.SimpleTerm(this._leftBytes);
            }
            return new KeyFilter.RangeTerm(this._leftBytes, this._rightBytes, this._leftInclusive, this._rightInclusive);
        }
    }
}

