/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.BufferPool;
import com.persistit.CLI;
import com.persistit.CleanupManager;
import com.persistit.Key;
import com.persistit.MVV;
import com.persistit.Persistit;
import com.persistit.Task;
import com.persistit.Tree;
import com.persistit.TreeSelector;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.InUseException;
import com.persistit.exception.PersistitException;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.util.ArrayList;
import java.util.BitSet;

public class IntegrityCheck
extends Task {
    static final int MAX_FAULTS = 200;
    static final int MAX_HOLES_TO_FIX = 1000;
    static final int MAX_WALK_RIGHT = 1000;
    static final int MAX_PRUNING_ERRORS = 50;
    private Volume _currentVolume;
    private Tree _currentTree;
    private LongBitSet _usedPageBits = new LongBitSet();
    private long _totalPages = 0L;
    private long _pagesVisited = 0L;
    private final Counters _counters = new Counters();
    private final Buffer[] _edgeBuffers = new Buffer[20];
    private final long[] _edgePages = new long[20];
    private final int[] _edgePositions = new int[20];
    private final Key[] _edgeKeys = new Key[20];
    private int _treeDepth = -1;
    private TreeSelector _treeSelector;
    private boolean _suspendUpdates;
    private boolean _fixHoles;
    private boolean _prune;
    private boolean _pruneAndClear;
    private boolean _csv;
    private final ArrayList<Fault> _faults = new ArrayList();
    private final ArrayList<CleanupManager.CleanupIndexHole> _holes = new ArrayList();
    private final Value _value = new Value((Persistit)null);
    private final MVVVisitor _versionVisitor = new MVVVisitor();
    private final Buffer.VerifyVisitor _visitor = new Buffer.VerifyVisitor(){

        @Override
        protected void visitDataRecord(Key key, int foundAt, int tail, int klength, int offset, int length, byte[] bytes) throws PersistitException {
            MVV.visitAllVersions(IntegrityCheck.this._versionVisitor, bytes, offset, length);
            if (((IntegrityCheck)IntegrityCheck.this)._versionVisitor._count > 0) {
                IntegrityCheck.this._counters._mvvCount++;
                int voffset = ((IntegrityCheck)IntegrityCheck.this)._versionVisitor._lastOffset;
                int vlength = length - (voffset - offset);
                Counters counters = IntegrityCheck.this._counters;
                counters._mvvOverhead = counters._mvvOverhead + (long)(length - vlength);
                if (vlength == 1 && bytes[voffset] == 49) {
                    IntegrityCheck.this._counters._mvvOverhead++;
                    IntegrityCheck.this._counters._mvvAntiValues++;
                }
            }
        }
    };

    @CLI.Cmd(value="icheck")
    public static IntegrityCheck icheck(@CLI.Arg(value="trees|string|Tree selector: Volumes/Trees to check") String treeSelectorString, @CLI.Arg(value="_flag|r|Use regex expression") boolean regex, @CLI.Arg(value="_flag|u|Don't freeze updates (Default is to freeze updates)") boolean dontSuspendUpdates, @CLI.Arg(value="_flag|h|Fix index holes") boolean fixHoles, @CLI.Arg(value="_flag|p|Prune MVV values") boolean prune, @CLI.Arg(value="_flag|P|Prune MVV values and clear TransactionIndex") boolean pruneAndClear, @CLI.Arg(value="_flag|v|Verbose results") boolean verbose, @CLI.Arg(value="_flag|c|Format as CSV") boolean csv) throws Exception {
        IntegrityCheck task = new IntegrityCheck();
        task._treeSelector = TreeSelector.parseSelector(treeSelectorString, regex, '\\');
        task._fixHoles = fixHoles;
        task._prune = prune | pruneAndClear;
        task._pruneAndClear = pruneAndClear;
        task._suspendUpdates = !dontSuspendUpdates;
        task._csv = csv;
        task.setMessageLogVerbosity(verbose ? 1 : 0);
        return task;
    }

    IntegrityCheck() {
    }

    public IntegrityCheck(Persistit persistit) {
        super(persistit);
        this._persistit = persistit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTask() {
        if (this._pruneAndClear && !this._treeSelector.isSelectAll()) {
            this.postMessage("The pruneAndClear (-P) flag requires all trees (trees=*) to be selected", 0);
            return;
        }
        boolean freeze = !this._persistit.isUpdateSuspended() && this._suspendUpdates;
        boolean needsToDrain = false;
        if (freeze) {
            this._persistit.setUpdateSuspended(true);
            needsToDrain = true;
        }
        if (this._csv) {
            this.postMessage("Volume,Tree,Faults,IndexPages,IndexBytes,DataPages,DataBytes,LongRecordPages,LongRecordBytes,MvvPages,MvvRecords,MvvOverhead,MvvAntiValues,IndexHoles,PrunedPages", 0);
        }
        long startTimestamp = this._persistit.getTimestampAllocator().updateTimestamp();
        try {
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            long _totalPages = 0L;
            for (Volume volume : this._persistit.getVolumes()) {
                if (!this._treeSelector.isSelected(volume)) continue;
                volumes.add(volume);
                _totalPages += volume.getStorage().getNextAvailablePage();
            }
            Volume previousVolume = null;
            for (Tree tree : this._persistit.getSelectedTrees(this._treeSelector)) {
                Volume volume = tree.getVolume();
                boolean checkWholeVolume = false;
                if (volume != previousVolume) {
                    this.reset();
                    if (tree == volume.getDirectoryTree()) {
                        checkWholeVolume = true;
                    }
                }
                previousVolume = volume;
                try {
                    if (needsToDrain) {
                        needsToDrain = false;
                        Util.sleep(3000L);
                    }
                    if (checkWholeVolume) {
                        this.checkVolume(volume);
                        continue;
                    }
                    this.checkTree(tree);
                }
                catch (PersistitException pe) {
                    this.postMessage(pe.toString(), 0);
                }
            }
            this._currentVolume = null;
            this._currentTree = null;
            int n = this._faults.size();
            if (this._csv) {
                this.postMessage(String.format("\"%s\",\"%s\",%d,%s", "*", "*", n, this._counters.toCSV()), 0);
            } else {
                this.postMessage("Total " + this.toString(), 0);
            }
            if (this._pruneAndClear) {
                if (this._faults.isEmpty() && this._counters._mvvPageCount == this._counters._prunedPageCount && this._counters._pruningErrorCount == 0L) {
                    int count = this._persistit.getTransactionIndex().resetMVVCounts(startTimestamp);
                    this.postMessage(String.format("%,d aborted transactions were cleared by pruning", count), 0);
                } else {
                    this.postMessage("PruneAndClear failed to remove all aborted MMVs", 0);
                }
            }
            this.endMessage(0);
        }
        catch (PersistitException e) {
            this.postMessage(e.toString(), 0);
            this.endMessage(0);
        }
        finally {
            if (freeze) {
                this._persistit.setUpdateSuspended(false);
            }
        }
    }

    private String resourceName() {
        return this._currentTree == null ? this._currentVolume.getName() : this._currentVolume.getName() + ":" + this._currentTree.getName();
    }

    private String resourceName(Volume vol) {
        return vol.getName();
    }

    private String resourceName(Tree tree) {
        return tree.getVolume().getName() + ":" + tree.getName();
    }

    private String plural(int n, String m) {
        if (n == 1) {
            return "1 " + m;
        }
        return String.format("%,d %ss", n, m);
    }

    private void addFault(String description, long page, int level, int position) {
        Fault fault = new Fault(this.resourceName(), this, description, page, this._treeDepth, level, position);
        if (this._faults.size() < 200) {
            this._faults.add(fault);
        }
        this.postMessage(fault.toString(), 1);
    }

    private void addGarbageFault(String description, long page, int level, int position) {
        Fault fault = new Fault(this.resourceName(), this, description, page, 3, level, position);
        if (this._faults.size() < 200) {
            this._faults.add(fault);
        }
        this.postMessage(fault.toString(), 1);
    }

    private void initTree(Tree tree) {
        this._currentVolume = tree.getVolume();
        this._currentTree = tree;
        this._holes.clear();
        this._treeDepth = tree.getDepth();
        int index = 20;
        while (--index >= 0) {
            this._edgeBuffers[index] = null;
            this._edgePages[index] = 0L;
            this._edgeKeys[index] = null;
            this._edgePositions[index] = 0;
        }
    }

    public boolean isSuspendUpdates() {
        return this._suspendUpdates;
    }

    public void setSuspendUpdates(boolean suspendUpdates) {
        this._suspendUpdates = suspendUpdates;
    }

    public void setCsvMode(boolean csvMode) {
        this._csv = csvMode;
    }

    public boolean isCsvMode() {
        return this._csv;
    }

    public boolean isFixHolesEnabled() {
        return this._fixHoles;
    }

    public boolean isPruneEnabled() {
        return this._prune;
    }

    public void setFixHolesEnabled(boolean fixHoles) {
        this._fixHoles = fixHoles;
    }

    public void setPruneEnabled(boolean prune) {
        this._prune = prune;
    }

    public boolean hasFaults() {
        return this._faults.size() > 0;
    }

    public Fault[] getFaults() {
        return this._faults.toArray(new Fault[this._faults.size()]);
    }

    public long getIndexPageCount() {
        return this._counters._indexPageCount;
    }

    public long getDataPageCount() {
        return this._counters._dataPageCount;
    }

    public long getLongRecordPageCount() {
        return this._counters._longRecordPageCount;
    }

    public long getIndexByteCount() {
        return this._counters._indexBytesInUse;
    }

    public long getDataByteCount() {
        return this._counters._dataBytesInUse;
    }

    public long getLongRecordByteCount() {
        return this._counters._longRecordBytesInUse;
    }

    public long getMvvCount() {
        return this._counters._mvvCount;
    }

    public long getMvvOverhead() {
        return this._counters._mvvOverhead;
    }

    public long getMvvAntiValues() {
        return this._counters._mvvAntiValues;
    }

    public long getIndexHoleCount() {
        return this._counters._indexHoleCount;
    }

    public long getPrunedPagesCount() {
        return this._counters._prunedPageCount;
    }

    public long getPruningErrorCount() {
        return this._counters._pruningErrorCount;
    }

    public long getGarbagePageCount() {
        return this._counters._garbagePageCount;
    }

    public double getProgress() {
        if (this._totalPages == 0L) {
            return 1.0;
        }
        return (double)this._pagesVisited / (double)this._totalPages;
    }

    @Override
    public String getStatusDetail() {
        if (this._faults.isEmpty()) {
            return this.getStatus() + " - no faults";
        }
        StringBuilder sb = new StringBuilder();
        for (Fault fault : this._faults) {
            sb.append(fault);
            sb.append(Util.NEW_LINE);
        }
        sb.append(this.getStatus());
        return sb.toString();
    }

    @Override
    public String getStatus() {
        if (this._currentVolume == null) {
            return null;
        }
        return this._pagesVisited + "/" + this._totalPages + " (" + this.resourceName() + ")";
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder(String.format("Faults:%,3d %s", this._faults.size(), this._counters));
        if (details) {
            for (int index = 0; index < this._faults.size(); ++index) {
                sb.append(Util.NEW_LINE);
                sb.append("        ");
                sb.append(this._faults.get(index));
            }
        }
        return sb.toString();
    }

    private void reset() {
        this._currentVolume = null;
        this._currentTree = null;
        this._usedPageBits = new LongBitSet();
        this._totalPages = 0L;
        this._pagesVisited = 0L;
    }

    public boolean checkVolume(Volume volume) throws PersistitException {
        this.reset();
        int faults = this._faults.size();
        if (!this._csv) {
            this.postMessage("Volume " + this.resourceName(volume) + " - checking", 1);
        }
        Counters counters = new Counters(this._counters);
        this._currentVolume = volume;
        String[] treeNames = volume.getTreeNames();
        this._totalPages = volume.getStorage().getNextAvailablePage();
        Tree directoryTree = volume.getDirectoryTree();
        if (directoryTree != null) {
            this.checkTree(directoryTree);
        }
        for (int index = 0; index < treeNames.length; ++index) {
            Tree tree = volume.getTree(treeNames[index], false);
            if (tree == null) continue;
            this.checkTree(tree);
        }
        long garbageRoot = volume.getStructure().getGarbageRoot();
        this.checkGarbage(garbageRoot);
        counters.difference(this._counters);
        faults = this._faults.size() - faults;
        if (this._csv) {
            this.postMessage(String.format("\"%s\",\"%s\",%d,%s", this.resourceName(volume), "*", faults, counters.toCSV()), 0);
        } else {
            this.postMessage("Volume " + this.resourceName(volume) + String.format(" Faults:%,3d ", faults) + counters.toString(), 1);
        }
        return faults == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTree(Tree tree) throws PersistitException {
        String messageStart = this._csv ? String.format("\"%s\",\"%s\"", tree.getVolume().getName(), tree.getName()) : "  Tree " + this.resourceName(tree);
        Counters treeCounters = new Counters(this._counters);
        int faults = this._faults.size();
        if (!tree.claim(true)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            try {
                this.initTree(tree);
                this.checkTree(new Key(this._persistit), 0L, tree.getRootPageAddr(), this._treeDepth - 1, tree);
            }
            catch (Throwable throwable) {
                for (int index = 0; index < 20; ++index) {
                    Buffer buffer = this._edgeBuffers[index];
                    if (buffer == null) continue;
                    buffer.release();
                    this._edgeBuffers[index] = null;
                    this._edgePages[index] = 0L;
                }
                this._currentTree = null;
                throw throwable;
            }
            for (int index = 0; index < 20; ++index) {
                Buffer buffer = this._edgeBuffers[index];
                if (buffer == null) continue;
                buffer.release();
                this._edgeBuffers[index] = null;
                this._edgePages[index] = 0L;
            }
            this._currentTree = null;
        }
        finally {
            tree.release();
        }
        faults = this._faults.size() - faults;
        treeCounters.difference(this._counters);
        if (this._counters._indexHoleCount > 0L) {
            this.postMessage("  Tree " + this.resourceName(tree) + " has " + this.plural((int)this._counters._indexHoleCount, "unindexed page"), 0);
            if (this._fixHoles) {
                int offered = 0;
                for (CleanupManager.CleanupIndexHole hole : this._holes) {
                    if (!this._persistit.getCleanupManager().offer(hole)) continue;
                    ++offered;
                }
                this.postMessage("    - enqueued " + offered + " for repair", 0);
            }
        }
        if (this._csv) {
            this.postMessage(String.format("%s,%d,%s", messageStart, faults, treeCounters.toCSV()), 0);
        } else {
            this.postMessage(String.format("%s - Faults:%,3d ", messageStart, faults) + treeCounters.toString(), 1);
        }
        return faults == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTree(Key parentKey, long parent, long page, int level, Tree tree) throws PersistitException {
        if (level >= 20) {
            this.addFault("Tree is too deep", page, level, 0);
        }
        if (this._usedPageBits.get(page)) {
            this.addFault("Page has more than one parent", page, level, 0);
        }
        if (page == 0L) {
            this.addFault("Page 0 not allowed in tree structure", page, level, 0);
        }
        this._usedPageBits.set(page, true);
        Buffer buffer = this.getPage(page);
        ++this._pagesVisited;
        try {
            if (parent == 0L && buffer.getRightSibling() != 0L) {
                this.addFault("Tree root has a right sibling", page, 0, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Key key;
            Buffer leftSibling = null;
            if (this._edgeBuffers[level] != null) {
                key = this._edgeKeys[level];
                leftSibling = this.walkRight(level, page, key, tree);
                int compare = key.compareTo(parentKey);
                if (compare != 0) {
                    this.addFault("left sibling final key is " + (compare < 0 ? "less than" : "greater than") + " parent key", page, level, 0);
                }
            } else {
                this._edgeKeys[level] = key = new Key(parentKey);
            }
            Debug.$assert0.t(leftSibling != buffer);
            this._edgeBuffers[level] = buffer;
            this._edgePages[level] = page;
            if (leftSibling != null) {
                leftSibling.release();
            }
            this._edgeKeys[level] = key;
            if (this.checkPageType(buffer, level, tree) && this.verifyPage(buffer, page, level, key, tree)) {
                if (buffer.isDataPage()) {
                    this._counters._dataPageCount++;
                    Counters compare = this._counters;
                    compare._dataBytesInUse = compare._dataBytesInUse + (long)(buffer.getBufferSize() - buffer.getAvailableSize() - 48);
                    int p = 32;
                    while ((p = buffer.nextLongRecord(this._value, p)) != -1) {
                        this.verifyLongRecord(this._value, page, p);
                        p += 4;
                    }
                } else if (buffer.isIndexPage()) {
                    long child;
                    int foundAt;
                    this._counters._indexPageCount++;
                    Counters p = this._counters;
                    p._indexBytesInUse = p._indexBytesInUse + (long)(buffer.getBufferSize() - buffer.getAvailableSize() - 56);
                    key.clear();
                    int p2 = 32;
                    while (!(((foundAt = buffer.nextKey(key, p2)) & 1) == 0 || (child = buffer.getPointer(foundAt)) == -1L && buffer.isAfterRightEdge(foundAt))) {
                        if (child <= 0L || child > 0x7FFFFFFEL) {
                            this.addFault("Invalid index pointer value " + child, page, level, foundAt);
                        }
                        this.checkTree(key, page, child, level - 1, tree);
                        p2 += 4;
                    }
                } else {
                    throw new RuntimeException("should never happen!");
                }
            }
            buffer = null;
        }
        finally {
            if (buffer != null) {
                this._edgeBuffers[level] = null;
                this._edgePages[level] = 0L;
                buffer.release();
            }
        }
    }

    private void checkGarbage(long garbageRootPage) throws PersistitException {
        long garbagePageAddress = garbageRootPage;
        boolean first = true;
        while (garbagePageAddress != 0L) {
            Buffer garbageBuffer = this.getPage(garbagePageAddress);
            if (first) {
                this._edgePages[0] = garbagePageAddress;
                first = false;
            }
            this.checkGarbagePage(garbageBuffer);
            ++this._pagesVisited;
            garbagePageAddress = garbageBuffer.getRightSibling();
            garbageBuffer.release();
        }
        this._edgePages[0] = 0L;
    }

    private void checkGarbagePage(Buffer garbageBuffer) throws PersistitException {
        long page = garbageBuffer.getPageAddress();
        if (!garbageBuffer.isGarbagePage()) {
            this.addGarbageFault("Unexpected page type " + garbageBuffer.getPageType() + " expected a garbage page", page, 1, 0);
            return;
        }
        if (this._usedPageBits.get(page)) {
            this.addGarbageFault("Garbage page is referenced by multiple parents", page, 1, 0);
            return;
        }
        this._counters._garbagePageCount++;
        int next = garbageBuffer.getAlloc();
        int size = garbageBuffer.getBufferSize();
        int count = (size - next) / 32;
        if (count * 32 != size - next) {
            this.addGarbageFault("Garbage page is malformed: _alloc=" + next + " is not at a multiple of " + 32 + " bytes", page, 1, 0);
        }
        this._usedPageBits.set(page, true);
        this._edgePages[1] = page;
        for (int p = garbageBuffer.getAlloc(); p < garbageBuffer.getBufferSize(); p += 32) {
            long left = garbageBuffer.getGarbageChainLeftPage(next);
            long right = garbageBuffer.getGarbageChainRightPage(next);
            this._edgePositions[1] = p;
            this.checkGarbageChain(left, right);
        }
        this._edgePages[1] = 0L;
    }

    private void checkGarbageChain(long left, long right) throws PersistitException {
        long page;
        this._edgePages[2] = page = left;
        while (page != 0L && page != right) {
            if (this._usedPageBits.get(page)) {
                this.addGarbageFault("Page on garbage chain is referenced by multiple parents", page, 0, 0);
                return;
            }
            Buffer buffer = this.getPage(page);
            if (!(buffer.isDataPage() || buffer.isIndexPage() || buffer.isLongRecordPage())) {
                this.addGarbageFault("Page of type " + buffer.getPageTypeName() + " found on garbage page", page, 0, 0);
            }
            this._counters._garbagePageCount++;
            ++this._pagesVisited;
            page = buffer.getRightSibling();
            buffer.release();
        }
        this._edgePages[2] = 0L;
    }

    private boolean checkPageType(Buffer buffer, int level, Tree tree) {
        int type = buffer.getPageType();
        if (type != 1 + level) {
            this.addFault("Unexpected page type " + type, buffer.getPageAddress(), level, 0);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer walkRight(int level, long toPage, Key key, Tree tree) throws PersistitException {
        Buffer startingBuffer = this._edgeBuffers[level];
        if (startingBuffer == null) {
            return null;
        }
        Buffer buffer = startingBuffer;
        if (buffer.getPageAddress() == toPage) {
            this.addFault("Overlapping page", toPage, level, 0);
            return startingBuffer;
        }
        int walkCount = 1000;
        Buffer oldBuffer = null;
        try {
            while (buffer.getRightSibling() != toPage) {
                boolean ok;
                long page = buffer.getRightSibling();
                if (startingBuffer.getPageAddress() == page) {
                    this.addFault("Right pointer cycle", page, level, 0);
                    oldBuffer = buffer;
                    Buffer buffer2 = startingBuffer;
                    return buffer2;
                }
                this._counters._indexHoleCount++;
                int treeHandle = this._currentTree.getHandle();
                if (treeHandle != 0 && this._holes.size() < 1000) {
                    this._holes.add(new CleanupManager.CleanupIndexHole(this._currentTree.getHandle(), page, level));
                }
                if (page <= 0L || page > 0x7FFFFFFEL) {
                    this.addFault(String.format("Invalid right sibling address in page %,d after walking right %,d", buffer.getPageAddress(), walkCount), startingBuffer.getPageAddress(), level, 0);
                    key.clear();
                    oldBuffer = buffer;
                    Buffer buffer3 = startingBuffer;
                    return buffer3;
                }
                if (walkCount-- <= 0) {
                    this.addFault("More than 50 unindexed siblings", startingBuffer.getPageAddress(), level, 0);
                    key.clear();
                    oldBuffer = buffer;
                    Buffer buffer4 = startingBuffer;
                    return buffer4;
                }
                oldBuffer = buffer;
                buffer = this.getPage(page);
                if (oldBuffer != startingBuffer) {
                    oldBuffer.release();
                    oldBuffer = null;
                }
                if (!(ok = this.verifyPage(buffer, page, level, key, tree))) {
                    key.clear();
                    oldBuffer = buffer;
                    Buffer buffer5 = startingBuffer;
                    return buffer5;
                }
                ++this._pagesVisited;
            }
            if (startingBuffer != buffer) {
                startingBuffer.release();
            }
            Buffer buffer6 = buffer;
            return buffer6;
        }
        finally {
            if (oldBuffer != null && oldBuffer != startingBuffer) {
                oldBuffer.release();
                oldBuffer = null;
            }
        }
    }

    private boolean verifyPage(Buffer buffer, long page, int level, Key key, Tree tree) {
        if (buffer.getPageAddress() != page) {
            this.addFault("Buffer contains wrong page " + buffer.getPageAddress(), page, level, 0);
            return false;
        }
        try {
            if (buffer.isDataPage() || buffer.isIndexPage()) {
                long mvvCount = this._counters._mvvCount;
                PersistitException ipse = buffer.verify(key, this._visitor);
                if (ipse != null) {
                    this.addFault(ipse.getMessage(), page, level, 0);
                    key.clear();
                    return false;
                }
                if (this._counters._mvvCount > mvvCount) {
                    this._counters._mvvPageCount++;
                    if (this._prune && !this._currentVolume.isReadOnly() && this._counters._pruningErrorCount < 50L) {
                        try {
                            buffer.pruneMvvValues(tree, true, null);
                            this._counters._prunedPageCount++;
                        }
                        catch (PersistitException e) {
                            this._counters._pruningErrorCount++;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.addFault(e.toString(), page, level, 0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLongRecord(Value value, long page, int foundAt) throws PersistitException {
        int size = value.getEncodedSize();
        byte[] bytes = value.getEncodedBytes();
        if (size != 120) {
            this.addFault("Invalid long record stub size (" + size + ")", page, 0, foundAt);
            return false;
        }
        int longSize = Buffer.decodeLongRecordDescriptorSize(bytes, 0);
        long pointer = Buffer.decodeLongRecordDescriptorPointer(bytes, 0);
        if (longSize < 100) {
            this.addFault("Invalid long record size (" + longSize + ")", page, 0, foundAt);
        }
        if (pointer <= 0L || pointer > 0x7FFFFFFEL) {
            this.addFault("Invalid long record pointer (" + pointer + ")", page, 0, foundAt);
        }
        long fromPage = page;
        longSize -= 100;
        long longPage = pointer;
        while (longPage != 0L) {
            if (this._usedPageBits.get(longPage)) {
                this.addFault("Long record page " + longPage + " is multiply linked", page, 0, foundAt);
                break;
            }
            this._usedPageBits.set(longPage, true);
            if (longSize <= 0) {
                this.addFault("Long record chain too long at page " + longPage + " pointed to by " + fromPage, page, 0, foundAt);
                break;
            }
            Buffer longBuffer = null;
            try {
                longBuffer = this.getPage(longPage);
                if (!longBuffer.isLongRecordPage()) {
                    this.addFault("Invalid long record page " + longPage + ": type=" + longBuffer.getPageTypeName(), page, 0, foundAt);
                    break;
                }
                int segmentSize = longBuffer.getBufferSize() - 32;
                if (segmentSize > longSize) {
                    segmentSize = longSize;
                }
                longSize -= segmentSize;
                Counters counters = this._counters;
                counters._longRecordBytesInUse = counters._longRecordBytesInUse + (long)segmentSize;
                this._counters._longRecordPageCount++;
                fromPage = longPage;
                longPage = longBuffer.getRightSibling();
            }
            catch (Exception e) {
                this.addFault(e.toString() + " while verifying long record page " + longPage, page, 0, foundAt);
                break;
            }
            finally {
                if (longBuffer == null) continue;
                longBuffer.release();
            }
        }
        return true;
    }

    private Buffer getPage(long page) throws PersistitException {
        this.poll();
        BufferPool pool = this._currentVolume.getPool();
        Buffer buffer = pool.get(this._currentVolume, page, this.isPruneEnabled() && !this._currentVolume.isReadOnly(), true);
        return buffer;
    }

    private static class LongBitSet {
        BitSet _bitSet = new BitSet();

        private LongBitSet() {
        }

        public void set(long index, boolean value) {
            if (index > Integer.MAX_VALUE) {
                throw new RuntimeException("Large page addresses not implemented yet.");
            }
            if (value) {
                this._bitSet.set((int)index);
            } else {
                this._bitSet.clear((int)index);
            }
        }

        public boolean get(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new RuntimeException("Large page addresses not implemented yet.");
            }
            return this._bitSet.get((int)index);
        }
    }

    public static class Fault {
        String _treeName;
        String _description;
        long[] _path;
        int _level;
        int _depth;
        int _position;

        Fault(String treeName, IntegrityCheck work, String description, long page, int depth, int level, int position) {
            this._treeName = treeName;
            this._description = description;
            this._depth = depth;
            this._path = new long[this._depth - level];
            int index = this._depth;
            while (--index > level) {
                if (index >= work._edgeBuffers.length) {
                    this._path[index - level] = 0L;
                    continue;
                }
                this._path[index - level] = work._edgePages[index];
            }
            this._path[0] = page;
            this._level = level;
            this._depth = work._treeDepth;
            this._position = position;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("  Tree ");
            sb.append(this._treeName);
            sb.append(" ");
            sb.append(this._description);
            sb.append(" (path ");
            int index = this._depth;
            while (--index >= this._level) {
                if (index < this._depth - 1) {
                    sb.append("->");
                }
                sb.append(String.format("%,d", this._path[index - this._level]));
            }
            if (this._position != 0) {
                sb.append(":");
                sb.append(this._position & 0xFFFC);
            }
            sb.append(")");
            if (this._depth >= 0) {
                sb.append(" depth=");
                sb.append(this._depth);
            }
            return sb.toString();
        }
    }

    private static class MVVVisitor
    implements MVV.VersionVisitor {
        int _lastOffset;
        int _count;

        private MVVVisitor() {
        }

        @Override
        public void init() throws PersistitException {
            this._lastOffset = 0;
            this._count = 0;
        }

        @Override
        public void sawVersion(long version, int offset, int valueLength) throws PersistitException {
            if (version != 0L) {
                ++this._count;
                this._lastOffset = offset;
            }
        }
    }

    private static class Counters {
        private long _indexPageCount = 0L;
        private long _dataPageCount = 0L;
        private long _indexBytesInUse = 0L;
        private long _dataBytesInUse = 0L;
        private long _longRecordPageCount = 0L;
        private long _longRecordBytesInUse = 0L;
        private long _indexHoleCount = 0L;
        private long _mvvPageCount = 0L;
        private long _mvvCount = 0L;
        private long _mvvOverhead = 0L;
        private long _mvvAntiValues = 0L;
        private long _pruningErrorCount = 0L;
        private long _prunedPageCount = 0L;
        private long _garbagePageCount = 0L;
        private static final String CSV_HEADERS = "IndexPages,IndexBytes,DataPages,DataBytes,LongRecordPages,LongRecordBytes,MvvPages,MvvRecords,MvvOverhead,MvvAntiValues,IndexHoles,PrunedPages";

        Counters() {
        }

        Counters(Counters counters) {
            this._indexPageCount = counters._indexPageCount;
            this._dataPageCount = counters._dataPageCount;
            this._indexBytesInUse = counters._indexBytesInUse;
            this._dataBytesInUse = counters._dataBytesInUse;
            this._longRecordPageCount = counters._longRecordPageCount;
            this._longRecordBytesInUse = counters._longRecordBytesInUse;
            this._indexHoleCount = counters._indexHoleCount;
            this._mvvPageCount = counters._mvvPageCount;
            this._mvvCount = counters._mvvCount;
            this._mvvOverhead = counters._mvvOverhead;
            this._mvvAntiValues = counters._mvvAntiValues;
            this._pruningErrorCount = counters._pruningErrorCount;
            this._prunedPageCount = counters._prunedPageCount;
            this._garbagePageCount = counters._garbagePageCount;
        }

        void difference(Counters counters) {
            this._indexPageCount = counters._indexPageCount - this._indexPageCount;
            this._dataPageCount = counters._dataPageCount - this._dataPageCount;
            this._indexBytesInUse = counters._indexBytesInUse - this._indexBytesInUse;
            this._dataBytesInUse = counters._dataBytesInUse - this._dataBytesInUse;
            this._longRecordPageCount = counters._longRecordPageCount - this._longRecordPageCount;
            this._longRecordBytesInUse = counters._longRecordBytesInUse - this._longRecordBytesInUse;
            this._indexHoleCount = counters._indexHoleCount - this._indexHoleCount;
            this._mvvPageCount = counters._mvvPageCount - this._mvvPageCount;
            this._mvvCount = counters._mvvCount - this._mvvCount;
            this._mvvOverhead = counters._mvvOverhead - this._mvvOverhead;
            this._mvvAntiValues = counters._mvvAntiValues - this._mvvAntiValues;
            this._pruningErrorCount = counters._pruningErrorCount - this._pruningErrorCount;
            this._prunedPageCount = counters._prunedPageCount - this._prunedPageCount;
            this._garbagePageCount = counters._garbagePageCount - this._garbagePageCount;
        }

        public String toString() {
            return String.format("Index pages/bytes: %,d / %,d Data pages/bytes: %,d / %,d LongRec pages/bytes: %,d / %,d  MVV pages/records/bytes/antivalues: %,d / %,d / %,d / %,d  Holes %,d Pages pruned %,d", this._indexPageCount, this._indexBytesInUse, this._dataPageCount, this._dataBytesInUse, this._longRecordPageCount, this._longRecordBytesInUse, this._mvvPageCount, this._mvvCount, this._mvvOverhead, this._mvvAntiValues, this._indexHoleCount, this._prunedPageCount);
        }

        private String toCSV() {
            return String.format("%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d", this._indexPageCount, this._indexBytesInUse, this._dataPageCount, this._dataBytesInUse, this._longRecordPageCount, this._longRecordBytesInUse, this._mvvPageCount, this._mvvCount, this._mvvOverhead, this._mvvAntiValues, this._indexHoleCount, this._prunedPageCount);
        }
    }
}

