/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.forgerock.audit.handlers.jms.DeliveryModeConfig;
import org.forgerock.audit.handlers.jms.JmsAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.jms.JmsContextManager;
import org.forgerock.audit.handlers.jms.SessionModeConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(JmsResourceManager.class);
    private final ConnectionFactory connectionFactory;
    private final DeliveryModeConfig deliveryMode;
    private SessionModeConfig sessionMode;
    private Connection connection;
    private Topic topic;

    public JmsResourceManager(JmsAuditEventHandlerConfiguration configuration, JmsContextManager jmsContextManager) throws ResourceException {
        Reject.ifNull((Object)((Object)configuration.getDeliveryMode()), (String)"JMS Delivery Mode is required");
        Reject.ifNull((Object)((Object)configuration.getSessionMode()), (String)"JMS Session Mode is required");
        this.sessionMode = configuration.getSessionMode();
        this.deliveryMode = configuration.getDeliveryMode();
        this.connectionFactory = jmsContextManager.getConnectionFactory();
        this.topic = jmsContextManager.getTopic();
        Reject.ifNull((Object)this.connectionFactory, (String)"Null ConnectionFactory is not permitted.");
        Reject.ifNull((Object)this.topic, (String)"Null topic is not permitted.");
    }

    public void openConnection() throws JMSException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        logger.debug("JMS Connection created and started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws JMSException {
        if (null != this.connection) {
            try {
                this.connection.close();
                logger.debug("JMS Connection closed");
            }
            finally {
                this.connection = null;
            }
        }
    }

    public Session createSession() throws JMSException {
        if (null == this.connection) {
            throw new IllegalStateException("JMS Connection not available to create session. The JMS Audit Service requires a restart.");
        }
        return this.connection.createSession(false, this.sessionMode.getMode());
    }

    public MessageProducer createProducer(Session session) throws JMSException {
        MessageProducer producer = session.createProducer((Destination)this.topic);
        producer.setDeliveryMode(this.deliveryMode.getMode());
        return producer;
    }
}

