/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jms;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Collections;
import java.util.Map;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;
import org.forgerock.audit.handlers.jms.BatchPublisherConfiguration;
import org.forgerock.audit.handlers.jms.DeliveryModeConfig;
import org.forgerock.audit.handlers.jms.SessionModeConfig;
import org.forgerock.util.Reject;

public class JmsAuditEventHandlerConfiguration
extends EventHandlerConfiguration {
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.jms.deliveryMode")
    private DeliveryModeConfig deliveryMode;
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.jms.sessionMode")
    private SessionModeConfig sessionMode;
    @JsonPropertyDescription(value="audit.handlers.jms.batch")
    private BatchPublisherConfiguration batch = new BatchPublisherConfiguration();
    @JsonPropertyDescription(value="audit.handlers.jms.jndi")
    private JndiConfiguration jndi = new JndiConfiguration();

    public DeliveryModeConfig getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(DeliveryModeConfig deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public SessionModeConfig getSessionMode() {
        return this.sessionMode;
    }

    public void setSessionMode(SessionModeConfig sessionMode) {
        this.sessionMode = sessionMode;
    }

    public BatchPublisherConfiguration getBatch() {
        return this.batch;
    }

    public void setBatch(BatchPublisherConfiguration batch) {
        this.batch = batch;
    }

    public JndiConfiguration getJndi() {
        return this.jndi;
    }

    public void setJndi(JndiConfiguration jndi) {
        this.jndi = jndi;
    }

    public boolean isUsableForQueries() {
        return false;
    }

    public static class JndiConfiguration {
        @JsonPropertyDescription(value="audit.handlers.jms.contextProperties")
        private Map<String, String> contextProperties = Collections.emptyMap();
        @JsonPropertyDescription(value="audit.handlers.jms.topicName")
        private String topicName = "audit";
        @JsonPropertyDescription(value="audit.handlers.jms.connectionFactoryName")
        private String connectionFactoryName = "connectionFactory";

        public Map<String, String> getContextProperties() {
            return this.contextProperties;
        }

        public void setContextProperties(Map<String, String> contextProperties) {
            Reject.ifNull(contextProperties, (String)"The jndi context properties can't be null");
            this.contextProperties = Collections.unmodifiableMap(contextProperties);
        }

        public String getTopicName() {
            return this.topicName;
        }

        public void setJmsTopicName(String jmsTopicName) {
            this.topicName = jmsTopicName;
        }

        public String getConnectionFactoryName() {
            return this.connectionFactoryName;
        }

        public void setJmsConnectionFactoryName(String jmsConnectionFactoryName) {
            this.connectionFactoryName = jmsConnectionFactoryName;
        }
    }
}

