/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.OverflowException;

final class FileBuffer
implements Buffer {
    private RandomAccessFile raf;
    private final int limit;

    FileBuffer(File file, int limit) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, "rw");
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte read(int pos) throws IOException {
        this.notClosed();
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if ((long)pos < this.raf.length()) {
                this.raf.seek(pos);
                return (byte)this.raf.read();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int pos, byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int n = 0;
        if ((long)pos < this.raf.length()) {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(pos);
                n = this.raf.read(b, off, len);
                if (n == -1) {
                    n = 0;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(byte b) throws IOException {
        this.notClosed();
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            int rafLength = (int)Math.min(Integer.MAX_VALUE, this.raf.length());
            if (rafLength + 1 > this.limit) {
                throw new OverflowException();
            }
            this.raf.seek(rafLength);
            this.raf.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            int rafLength = (int)Math.min(Integer.MAX_VALUE, this.raf.length());
            if (rafLength + len > this.limit) {
                throw new OverflowException();
            }
            this.raf.seek(rafLength);
            this.raf.write(b, off, len);
        }
    }

    @Override
    public int length() throws IOException {
        this.notClosed();
        return (int)Math.min(Integer.MAX_VALUE, this.raf.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            finally {
                this.raf = null;
            }
        }
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    private void notClosed() throws IOException {
        if (this.raf == null) {
            throw new IOException("buffer is closed");
        }
    }
}

