/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.util.Reject;

public class ContentTypeHeader
extends Header {
    public static final String NAME = "Content-Type";
    private final String type;
    private final String charset;
    private final String boundary;
    private final Map<String, String> additionalParameters;

    public static ContentTypeHeader valueOf(Message message) {
        return ContentTypeHeader.valueOf(HeaderUtil.parseSingleValuedHeader(message, NAME));
    }

    public static ContentTypeHeader valueOf(String string) {
        List<String> parts = HeaderUtil.split(string, ';');
        if (parts.size() > 0) {
            String type = parts.remove(0);
            Map<String, String> parameters = HeaderUtil.parseParameters(parts);
            String charset = parameters.remove("charset");
            String boundary = parameters.remove("boundary");
            return new ContentTypeHeader(type, charset, boundary, parameters);
        }
        return new ContentTypeHeader(null, null, null);
    }

    public ContentTypeHeader() {
        this(null, null, null);
    }

    public ContentTypeHeader(String type, String charset, String boundary) {
        this(type, charset, boundary, Collections.emptyMap());
    }

    public ContentTypeHeader(String type, String charset, String boundary, Map<String, String> additionalParameters) {
        this.type = type;
        this.charset = charset;
        this.boundary = boundary;
        this.additionalParameters = (Map)Reject.checkNotNull(additionalParameters);
    }

    public String getType() {
        return this.type;
    }

    public Charset getCharset() {
        return this.charset != null ? Charset.forName(this.charset) : null;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        if (this.type == null || this.type.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        if (this.charset != null) {
            sb.append("; charset=").append(this.charset);
        }
        if (this.boundary != null) {
            sb.append("; boundary=").append(this.boundary);
        }
        for (String key : this.additionalParameters.keySet()) {
            sb.append("; ").append(key);
            String value = this.additionalParameters.get(key);
            if (value == null) continue;
            sb.append("=").append(value);
        }
        return sb.length() > 0 ? Collections.singletonList(sb.toString()) : Collections.emptyList();
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<ContentTypeHeader> {
        Factory() {
        }

        @Override
        public ContentTypeHeader parse(String value) {
            return ContentTypeHeader.valueOf(value);
        }
    }
}

