/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.io.PipeBufferedStream;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.Version;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.http.HttpContextFactory;
import org.forgerock.services.context.Context;
import org.forgerock.util.Utils;
import org.forgerock.util.encode.Base64url;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class HttpUtils {
    static final String CACHE_CONTROL = "no-cache";
    static final String CHARACTER_ENCODING = "UTF-8";
    static final Pattern CONTENT_TYPE_REGEX = Pattern.compile("^application/json([ ]*;[ ]*charset=utf-8)?$", 2);
    static final String CRLF = "\r\n";
    static final String ETAG_ANY = "*";
    static final String MIME_TYPE_APPLICATION_JSON = "application/json";
    static final String MIME_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    static final String HEADER_CACHE_CONTROL = "Cache-Control";
    static final String HEADER_ETAG = "ETag";
    static final String HEADER_IF_MATCH = "If-Match";
    static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    static final String HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    static final String HEADER_LOCATION = "Location";
    static final String HEADER_X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    static final Collection<String> RESTRICTED_HEADER_NAMES = Arrays.asList("Content-Type", "Accept-API-Version", "If-Modified-Since", "If-Unmodified-Since", "If-Match", "If-None-Match", "Cache-Control", "ETag", "Location", "X-HTTP-Method-Override", "Content-Disposition");
    static final String METHOD_DELETE = "DELETE";
    static final String METHOD_GET = "GET";
    static final String METHOD_HEAD = "HEAD";
    static final String METHOD_OPTIONS = "OPTIONS";
    static final String METHOD_PATCH = "PATCH";
    static final String METHOD_POST = "POST";
    static final String METHOD_PUT = "PUT";
    static final String METHOD_TRACE = "TRACE";
    public static final String PARAM_ACTION = HttpUtils.param("action");
    public static final String PARAM_FIELDS = HttpUtils.param("fields");
    public static final String PARAM_MIME_TYPE = HttpUtils.param("mimeType");
    public static final String PARAM_PAGE_SIZE = HttpUtils.param("pageSize");
    public static final String PARAM_PAGED_RESULTS_COOKIE = HttpUtils.param("pagedResultsCookie");
    public static final String PARAM_PAGED_RESULTS_OFFSET = HttpUtils.param("pagedResultsOffset");
    public static final String PARAM_PRETTY_PRINT = "_prettyPrint";
    public static final String PARAM_QUERY_EXPRESSION = HttpUtils.param("queryExpression");
    public static final String PARAM_QUERY_FILTER = HttpUtils.param("queryFilter");
    public static final String PARAM_QUERY_ID = HttpUtils.param("queryId");
    public static final String PARAM_SORT_KEYS = HttpUtils.param("sortKeys");
    public static final String PARAM_TOTAL_PAGED_RESULTS_POLICY = HttpUtils.param("totalPagedResultsPolicy");
    public static final String PARAM_CREST_API = HttpUtils.param("crestapi");
    public static final Version PROTOCOL_VERSION_1 = Version.version((int)1);
    public static final Version PROTOCOL_VERSION_2 = Version.version((int)2);
    public static final Version PROTOCOL_VERSION_2_1;
    public static final Version DEFAULT_PROTOCOL_VERSION;
    static final String FIELDS_DELIMITER = ",";
    static final String SORT_KEYS_DELIMITER = ",";
    static final ObjectMapper JSON_MAPPER;
    private static final String FILENAME = "filename";
    private static final String MIME_TYPE = "mimetype";
    private static final String CONTENT = "content";
    private static final String NAME = "name";
    private static final Pattern MULTIPART_FIELD_REGEX;
    private static final int PART_NAME = 1;
    private static final int PART_DATA_TYPE = 2;
    private static final String REFERENCE_TAG = "$ref";
    private static final int BUFFER_SIZE = 1024;
    private static final int EOF = -1;

    static ResourceException adapt(Throwable t) {
        if (t instanceof ResourceException) {
            return (ResourceException)t;
        }
        return new InternalServerErrorException(t);
    }

    static boolean asBooleanValue(String name, List<String> values) throws ResourceException {
        String value = HttpUtils.asSingleValue(name, values);
        return Boolean.parseBoolean(value);
    }

    static int asIntValue(String name, List<String> values) throws ResourceException {
        String value = HttpUtils.asSingleValue(name, values);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("The value '" + value + "' for parameter '" + name + "' could not be parsed as a valid integer");
        }
    }

    static String asSingleValue(String name, List<String> values) throws ResourceException {
        if (values == null || values.isEmpty()) {
            throw new BadRequestException("No values provided for the request parameter '" + name + "'");
        }
        if (values.size() > 1) {
            throw new BadRequestException("Multiple values provided for the single-valued request parameter '" + name + "'");
        }
        return values.get(0);
    }

    static Promise<Response, NeverThrowsException> fail(Request req, Throwable t) {
        return HttpUtils.fail0(req, null, t);
    }

    static Promise<Response, NeverThrowsException> fail(Request req, Response resp, Throwable t) {
        return HttpUtils.fail0(req, resp, t);
    }

    private static Promise<Response, NeverThrowsException> fail0(Request req, Response resp, Throwable t) {
        ResourceException re = HttpUtils.adapt(t);
        try {
            resp = resp == null ? HttpUtils.prepareResponse(req) : HttpUtils.prepareResponse(req, resp);
            resp.setStatus(Status.valueOf((int)re.getCode()));
            JsonGenerator writer = HttpUtils.getJsonGenerator(req, resp);
            Json.makeLocalizingObjectWriter((ObjectMapper)JSON_MAPPER, (Request)req).writeValue(writer, re.toJsonValue().getObject());
            Utils.closeSilently((Closeable[])new Closeable[]{writer});
            return Promises.newResultPromise((Object)resp);
        }
        catch (IOException ignored) {
            return Promises.newResultPromise((Object)Responses.newInternalServerError());
        }
        catch (MalformedHeaderException e) {
            return Promises.newResultPromise((Object)new Response(Status.BAD_REQUEST).setEntity((Object)"Malformed header"));
        }
    }

    public static RequestType determineRequestType(Request request) throws ResourceException {
        String method = HttpUtils.getMethod(request);
        if (METHOD_DELETE.equals(method)) {
            return RequestType.DELETE;
        }
        if (METHOD_GET.equals(method)) {
            if (HttpUtils.hasParameter(request, PARAM_QUERY_ID) || HttpUtils.hasParameter(request, PARAM_QUERY_EXPRESSION) || HttpUtils.hasParameter(request, PARAM_QUERY_FILTER)) {
                return RequestType.QUERY;
            }
            if (HttpUtils.hasParameter(request, PARAM_CREST_API)) {
                return RequestType.API;
            }
            return RequestType.READ;
        }
        if (METHOD_PATCH.equals(method)) {
            return RequestType.PATCH;
        }
        if (METHOD_POST.equals(method)) {
            return HttpUtils.determinePostRequestType(request);
        }
        if (METHOD_PUT.equals(method)) {
            return HttpUtils.determinePutRequestType(request);
        }
        throw new NotSupportedException("Method " + method + " not supported");
    }

    private static RequestType determinePostRequestType(Request request) throws ResourceException {
        List<String> parameter = HttpUtils.getParameter(request, PARAM_ACTION);
        boolean defactoCreate = HttpUtils.getRequestedProtocolVersion(request).compareTo(PROTOCOL_VERSION_2_1) >= 0 && (parameter == null || parameter.isEmpty());
        return defactoCreate || HttpUtils.asSingleValue(PARAM_ACTION, parameter).equalsIgnoreCase("create") ? RequestType.CREATE : RequestType.ACTION;
    }

    private static RequestType determinePutRequestType(Request request) throws BadRequestException {
        Version protocolVersion = HttpUtils.getRequestedProtocolVersion(request);
        String ifNoneMatch = HttpUtils.getIfNoneMatch(request);
        String ifMatch = HttpUtils.getIfMatch(request, protocolVersion);
        if (ifNoneMatch != null && !ETAG_ANY.equals(ifNoneMatch)) {
            throw new BadRequestException("\"" + ifNoneMatch + "\" is not a supported value for If-None-Match on PUT");
        }
        if (ETAG_ANY.equals(ifNoneMatch)) {
            return RequestType.CREATE;
        }
        if (ifNoneMatch == null && ifMatch == null && protocolVersion.getMajor() >= 2) {
            return RequestType.CREATE;
        }
        return RequestType.UPDATE;
    }

    static Version getRequestedResourceVersion(Request req) throws BadRequestException {
        return HttpUtils.getAcceptApiVersionHeader(req).getResourceVersion();
    }

    static Version getRequestedProtocolVersion(Request req) throws BadRequestException {
        Version protocolVersion = HttpUtils.getAcceptApiVersionHeader(req).getProtocolVersion();
        return protocolVersion != null ? protocolVersion : DEFAULT_PROTOCOL_VERSION;
    }

    private static AcceptApiVersionHeader getAcceptApiVersionHeader(Request req) throws BadRequestException {
        AcceptApiVersionHeader apiVersionHeader;
        try {
            apiVersionHeader = AcceptApiVersionHeader.valueOf((Message)req);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        HttpUtils.validateProtocolVersion(apiVersionHeader.getProtocolVersion());
        return apiVersionHeader;
    }

    private static void validateProtocolVersion(Version protocolVersion) throws BadRequestException {
        if (protocolVersion != null && protocolVersion.getMajor() > DEFAULT_PROTOCOL_VERSION.getMajor()) {
            throw new BadRequestException("Unsupported major version: " + protocolVersion);
        }
        if (protocolVersion != null && protocolVersion.getMinor() > DEFAULT_PROTOCOL_VERSION.getMinor()) {
            throw new BadRequestException("Unsupported minor version: " + protocolVersion);
        }
    }

    static String getIfMatch(Request req, Version protocolVersion) {
        String etag = req.getHeaders().getFirst(HEADER_IF_MATCH);
        if (etag != null) {
            if (etag.length() >= 2) {
                if (etag.charAt(0) == '\"') {
                    return etag.substring(1, etag.length() - 1);
                }
            } else if (etag.equals(ETAG_ANY) && protocolVersion.getMajor() < 2) {
                return null;
            }
        }
        return etag;
    }

    static String getIfNoneMatch(Request req) {
        String etag = req.getHeaders().getFirst(HEADER_IF_NONE_MATCH);
        if (etag != null) {
            if (etag.length() >= 2) {
                if (etag.charAt(0) == '\"') {
                    return etag.substring(1, etag.length() - 1);
                }
            } else if (etag.equals(ETAG_ANY)) {
                return ETAG_ANY;
            }
        }
        return etag;
    }

    static JsonValue getJsonContentIfPresent(Request req) throws ResourceException {
        return HttpUtils.getJsonContent0(req, true);
    }

    static JsonValue getJsonContent(Request req) throws ResourceException {
        return HttpUtils.getJsonContent0(req, false);
    }

    static JsonGenerator getJsonGenerator(Request req, Response resp) throws IOException {
        PipeBufferedStream pipeStream = new PipeBufferedStream();
        resp.setEntity((Object)pipeStream.getOut());
        JsonGenerator writer = JSON_MAPPER.getFactory().createGenerator(pipeStream.getIn());
        writer.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, true);
        List<String> values = HttpUtils.getParameter(req, PARAM_PRETTY_PRINT);
        if (values != null) {
            try {
                if (HttpUtils.asBooleanValue(PARAM_PRETTY_PRINT, values)) {
                    writer.useDefaultPrettyPrinter();
                }
            }
            catch (ResourceException e) {
                // empty catch block
            }
        }
        return writer;
    }

    static List<PatchOperation> getJsonPatchContent(Request req) throws ResourceException {
        return PatchOperation.valueOfList((JsonValue)new JsonValue(HttpUtils.parseJsonBody(req, false)));
    }

    static JsonValue getJsonActionContent(Request req) throws ResourceException {
        return new JsonValue(HttpUtils.parseJsonBody(req, true));
    }

    static String getMethod(Request req) {
        String method = req.getMethod();
        if (METHOD_POST.equals(method) && req.getHeaders().getFirst(HEADER_X_HTTP_METHOD_OVERRIDE) != null) {
            method = req.getHeaders().getFirst(HEADER_X_HTTP_METHOD_OVERRIDE);
        }
        return method;
    }

    static List<String> getParameter(Request req, String parameter) {
        for (Map.Entry p : req.getForm().entrySet()) {
            if (!((String)p.getKey()).equalsIgnoreCase(parameter)) continue;
            return (List)p.getValue();
        }
        return null;
    }

    static boolean hasParameter(Request req, String parameter) {
        return HttpUtils.getParameter(req, parameter) != null;
    }

    static Response prepareResponse(Request req) throws ResourceException {
        return HttpUtils.prepareResponse(req, new Response(Status.OK));
    }

    static Response prepareResponse(Request req, Response resp) throws ResourceException {
        try {
            resp.setStatus(Status.OK);
            String mimeType = (String)req.getForm().getFirst((Object)PARAM_MIME_TYPE);
            if (METHOD_GET.equalsIgnoreCase(HttpUtils.getMethod(req)) && mimeType != null && !mimeType.isEmpty()) {
                ContentType contentType = new ContentType(mimeType);
                resp.getHeaders().put((Header)new ContentTypeHeader(contentType.toString(), CHARACTER_ENCODING, null));
            } else {
                resp.getHeaders().put((Header)new ContentTypeHeader(MIME_TYPE_APPLICATION_JSON, CHARACTER_ENCODING, null));
            }
            resp.getHeaders().put(HEADER_CACHE_CONTROL, (Object)CACHE_CONTROL);
            return resp;
        }
        catch (ParseException e) {
            throw new BadRequestException("The mime type parameter '" + (String)req.getForm().getFirst((Object)PARAM_MIME_TYPE) + "' can't be parsed", (Throwable)e);
        }
    }

    static void rejectIfMatch(Request req) throws ResourceException {
        if (req.getHeaders().getFirst(HEADER_IF_MATCH) != null) {
            throw new PreconditionFailedException("If-Match not supported for " + HttpUtils.getMethod(req) + " requests");
        }
    }

    static void rejectIfNoneMatch(Request req) throws ResourceException, PreconditionFailedException {
        if (req.getHeaders().getFirst(HEADER_IF_NONE_MATCH) != null) {
            throw new PreconditionFailedException("If-None-Match not supported for " + HttpUtils.getMethod(req) + " requests");
        }
    }

    private static JsonValue getJsonContent0(Request req, boolean allowEmpty) throws ResourceException {
        Object body = HttpUtils.parseJsonBody(req, allowEmpty);
        if (body == null) {
            return new JsonValue(new LinkedHashMap(0));
        }
        if (!(body instanceof Map)) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON object");
        }
        return new JsonValue(body);
    }

    private static BodyPart getJsonRequestPart(MimeMultipart mimeMultiparts) throws BadRequestException, ResourceException {
        try {
            for (int i = 0; i < mimeMultiparts.getCount(); ++i) {
                BodyPart part = mimeMultiparts.getBodyPart(i);
                ContentType contentType = new ContentType(part.getContentType());
                if (!contentType.match(MIME_TYPE_APPLICATION_JSON)) continue;
                return part;
            }
            throw new BadRequestException("The request could not be processed because the multipart request does not include Content-Type: application/json");
        }
        catch (MessagingException e) {
            throw new BadRequestException("The request could not be processed because the request cant be parsed", (Throwable)e);
        }
        catch (IOException e) {
            throw HttpUtils.adapt(e);
        }
    }

    private static String getRequestPartData(MimeMultipart mimeMultiparts, String partName, String partDataType) throws IOException, MessagingException {
        ContentDisposition disposition;
        if (mimeMultiparts == null) {
            throw new BadRequestException("The request parameter is null when retrieving part data for part name: " + partName);
        }
        if (partDataType == null || partDataType.isEmpty()) {
            throw new BadRequestException("The request is requesting an unknown part field");
        }
        MimeBodyPart part = null;
        for (int i = 0; i < mimeMultiparts.getCount() && !(disposition = new ContentDisposition((part = (MimeBodyPart)mimeMultiparts.getBodyPart(i)).getHeader(CONTENT_DISPOSITION, null))).getParameter(NAME).equalsIgnoreCase(partName); ++i) {
        }
        if (part == null) {
            throw new BadRequestException("The request is missing a referenced part for part name: " + partName);
        }
        if (MIME_TYPE.equalsIgnoreCase(partDataType)) {
            return new ContentType(part.getContentType()).toString();
        }
        if (FILENAME.equalsIgnoreCase(partDataType)) {
            return part.getFileName();
        }
        if (CONTENT.equalsIgnoreCase(partDataType)) {
            return Base64url.encode((byte[])HttpUtils.toByteArray(part.getInputStream()));
        }
        throw new BadRequestException("The request could not be processed because the multipart request requests data from the part that isn't supported. Data requested: " + partDataType);
    }

    private static boolean isAReferenceJsonObject(JsonValue node) {
        return node.keys() != null && node.keys().size() == 1 && REFERENCE_TAG.equalsIgnoreCase((String)node.keys().iterator().next());
    }

    private static Object swapRequestPartsIntoContent(MimeMultipart mimeMultiparts, Object content) throws ResourceException {
        try {
            JsonValue root = new JsonValue(content);
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            stack.push(root);
            while (!stack.isEmpty()) {
                JsonValue node = (JsonValue)stack.pop();
                if (HttpUtils.isAReferenceJsonObject(node)) {
                    Matcher matcher = MULTIPART_FIELD_REGEX.matcher(node.get(REFERENCE_TAG).asString());
                    if (matcher.matches()) {
                        String partName = matcher.group(1);
                        String requestPartData = HttpUtils.getRequestPartData(mimeMultiparts, partName, matcher.group(2));
                        root.put(node.getPointer(), (Object)requestPartData);
                        continue;
                    }
                    throw new BadRequestException("Invalid reference tag '" + node.toString() + "'");
                }
                Iterator iter = node.iterator();
                while (iter.hasNext()) {
                    stack.push(iter.next());
                }
            }
            return root;
        }
        catch (IOException e) {
            throw HttpUtils.adapt(e);
        }
        catch (MessagingException e) {
            throw new BadRequestException("The request could not be processed because the request is not a valid multipart request");
        }
    }

    static boolean isMultiPartRequest(String unknownContentType) throws BadRequestException {
        try {
            if (unknownContentType == null) {
                return false;
            }
            ContentType contentType = new ContentType(unknownContentType);
            return contentType.match(MIME_TYPE_MULTIPART_FORM_DATA);
        }
        catch (ParseException e) {
            throw new BadRequestException("The request content type can't be parsed.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object parseJsonBody(Request req, boolean allowEmpty) throws ResourceException {
        try {
            JsonParser jsonParser;
            String contentType = req.getHeaders().getFirst(ContentTypeHeader.class);
            if (contentType == null && !allowEmpty) {
                throw new BadRequestException("The request could not be processed because the  content-type was not specified and is required");
            }
            boolean isMultiPartRequest = HttpUtils.isMultiPartRequest(contentType);
            MimeMultipart mimeMultiparts = null;
            if (isMultiPartRequest) {
                mimeMultiparts = new MimeMultipart((DataSource)new HttpServletRequestDataSource(req));
                BodyPart jsonPart = HttpUtils.getJsonRequestPart(mimeMultiparts);
                jsonParser = JSON_MAPPER.getFactory().createParser(jsonPart.getInputStream());
            } else {
                jsonParser = JSON_MAPPER.getFactory().createParser(req.getEntity().getRawContentInputStream());
            }
            try (JsonParser parser = jsonParser;){
                boolean hasTrailingGarbage;
                Object content = parser.readValueAs(Object.class);
                try {
                    hasTrailingGarbage = parser.nextToken() != null;
                }
                catch (JsonParseException e) {
                    hasTrailingGarbage = true;
                }
                if (hasTrailingGarbage) {
                    throw new BadRequestException("The request could not be processed because there is trailing data after the JSON content");
                }
                if (isMultiPartRequest) {
                    HttpUtils.swapRequestPartsIntoContent(mimeMultiparts, content);
                }
                Object object = content;
                return object;
            }
        }
        catch (JsonParseException e) {
            throw new BadRequestException("The request could not be processed because the provided content is not valid JSON", (Throwable)e).setDetail(new JsonValue((Object)e.getMessage()));
        }
        catch (JsonMappingException e) {
            if (!allowEmpty) throw new BadRequestException("The request could not be processed because it did not contain any JSON content", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            throw HttpUtils.adapt(e);
        }
        catch (MessagingException e) {
            throw new BadRequestException("The request could not be processed because it can't be parsed", (Throwable)e);
        }
    }

    private static String param(String field) {
        return "_" + field;
    }

    private HttpUtils() {
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int size;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((size = inputStream.read(data)) != -1) {
            byteArrayOutputStream.write(data, 0, size);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    static HttpContextFactory staticContextFactory(final Context parentContext) {
        return new HttpContextFactory(){

            @Override
            public Context createContext(Context parent, Request request) {
                return parentContext;
            }
        };
    }

    static {
        DEFAULT_PROTOCOL_VERSION = PROTOCOL_VERSION_2_1 = Version.version((int)2, (int)1);
        JSON_MAPPER = new ObjectMapper().registerModules(new Module[]{new Json.JsonValueModule(), new Json.LocalizableStringModule()});
        MULTIPART_FIELD_REGEX = Pattern.compile("^cid:(.*)#(filename|mimetype|content)$", 2);
    }

    private static class HttpServletRequestDataSource
    implements DataSource {
        private Request request;

        HttpServletRequestDataSource(Request request) {
            this.request = request;
        }

        public InputStream getInputStream() throws IOException {
            return this.request.getEntity().getRawContentInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getContentType() {
            return this.request.getHeaders().getFirst(ContentTypeHeader.class);
        }

        public String getName() {
            return "HttpServletRequestDataSource";
        }
    }
}

