/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.dbi.MemoryBudget;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.server.config.meta.JEBackendCfgDefn;
import org.forgerock.opendj.server.config.server.BackendCfg;
import org.forgerock.opendj.server.config.server.JEBackendCfg;
import org.opends.messages.BackendMessages;
import org.opends.messages.ConfigMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.MemoryQuota;
import org.opends.server.util.Platform;

class ConfigurableEnvironment {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final String ATTR_DATABASE_CACHE_PERCENT = "ds-cfg-db-cache-percent";
    private static final String ATTR_DATABASE_CACHE_SIZE = "ds-cfg-db-cache-size";
    private static final String ATTR_DATABASE_RUN_CLEANER = "ds-cfg-db-run-cleaner";
    private static final String ATTR_CLEANER_MIN_UTILIZATION = "ds-cfg-db-cleaner-min-utilization";
    private static final String ATTR_DATABASE_LOG_FILE_MAX = "ds-cfg-db-log-file-max";
    private static final String ATTR_EVICTOR_LRU_ONLY = "ds-cfg-db-evictor-lru-only";
    private static final String ATTR_EVICTOR_NODES_PER_SCAN = "ds-cfg-db-evictor-nodes-per-scan";
    private static final String ATTR_EVICTOR_CORE_THREADS = "ds-cfg-db-evictor-core-threads";
    private static final String ATTR_EVICTOR_MAX_THREADS = "ds-cfg-db-evictor-max-threads";
    private static final String ATTR_EVICTOR_KEEP_ALIVE = "ds-cfg-db-evictor-keep-alive";
    private static final String ATTR_CHECKPOINTER_BYTES_INTERVAL = "ds-cfg-db-checkpointer-bytes-interval";
    private static final String ATTR_CHECKPOINTER_WAKEUP_INTERVAL = "ds-cfg-db-checkpointer-wakeup-interval";
    private static final String ATTR_NUM_LOCK_TABLES = "ds-cfg-db-num-lock-tables";
    private static final String ATTR_NUM_CLEANER_THREADS = "ds-cfg-db-num-cleaner-threads";
    private static final String ATTR_LOG_FILECACHE_SIZE = "ds-cfg-db-log-filecache-size";
    private static final Map<String, String> attrMap = new HashMap<String, String>();
    private static final Map<String, Method> jebMethodMap = new HashMap<String, Method>();
    private static final Map<String, PropertyDefinition<?>> jebDefnMap = new HashMap();
    private static final List<String> ABBREVIATIONS = Arrays.asList("aci", "ip", "ssl", "dn", "rdn", "jmx", "smtp", "http", "https", "ldap", "ldaps", "ldif", "jdbc", "tcp", "tls", "pkcs11", "sasl", "gssapi", "md5", "je", "dse", "fifo", "vlv", "uuid", "md5", "sha1", "sha256", "sha384", "sha512", "tls", "db");

    ConfigurableEnvironment() {
    }

    private static String propNametoCamlCase(String hyphenated) {
        String[] components = hyphenated.split("\\-");
        StringBuilder buffer = new StringBuilder();
        for (String component : components) {
            if (ABBREVIATIONS.contains(component)) {
                buffer.append(component.toUpperCase());
                continue;
            }
            buffer.append(component.substring(0, 1).toUpperCase()).append(component.substring(1));
        }
        return buffer.toString();
    }

    private static void registerProp(String propertyName, String attrName) throws Exception {
        String baseName = attrName.substring(7);
        String methodBaseName = ConfigurableEnvironment.propNametoCamlCase(baseName);
        ConfigurableEnvironment.registerJebProp(attrName, methodBaseName);
        attrMap.put(propertyName, attrName);
    }

    private static void registerJebProp(String attrName, String methodBaseName) throws Exception {
        String propName;
        Class<JEBackendCfg> configClass = JEBackendCfg.class;
        JEBackendCfgDefn defn = JEBackendCfgDefn.getInstance();
        Class<?> defClass = defn.getClass();
        PropertyDefinition propDefn = (PropertyDefinition)defClass.getMethod(propName = "get" + methodBaseName + "PropertyDefinition", new Class[0]).invoke((Object)defn, new Object[0]);
        String methodPrefix = propDefn instanceof BooleanPropertyDefinition ? "is" : "get";
        String methodName = methodPrefix + methodBaseName;
        jebDefnMap.put(attrName, propDefn);
        jebMethodMap.put(attrName, configClass.getMethod(methodName, new Class[0]));
    }

    private static String getPropertyValue(BackendCfg cfg, String attrName, ByteString backendId) {
        try {
            PropertyDefinition<?> propDefn = jebDefnMap.get(attrName);
            Method method = jebMethodMap.get(attrName);
            if (propDefn instanceof DurationPropertyDefinition) {
                Long value = (Long)method.invoke((Object)cfg, new Object[0]);
                DurationPropertyDefinition durationPropDefn = (DurationPropertyDefinition)propDefn;
                value = 1000L * durationPropDefn.getBaseUnit().toMilliSeconds((double)value.longValue());
                return String.valueOf(value);
            }
            Object value = method.invoke((Object)cfg, new Object[0]);
            if (value != null) {
                return String.valueOf(value);
            }
            if (attrName.equals(ATTR_NUM_CLEANER_THREADS)) {
                value = Platform.computeNumberOfThreads((int)8, (float)1.0f);
                logger.debug(BackendMessages.INFO_ERGONOMIC_SIZING_OF_JE_CLEANER_THREADS, (Object)backendId, (Object)((Number)value));
            } else if (attrName.equals(ATTR_NUM_LOCK_TABLES)) {
                BigInteger tmp = BigInteger.valueOf(Platform.computeNumberOfThreads((int)1, (float)2.0f));
                value = tmp.nextProbablePrime();
                logger.debug(BackendMessages.INFO_ERGONOMIC_SIZING_OF_JE_LOCK_TABLES, (Object)backendId, (Object)((Number)value));
            }
            return String.valueOf(value);
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            return "";
        }
    }

    private static EnvironmentConfig defaultConfig() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setConfigParam("je.cleaner.expunge", "true");
        envConfig.setConfigParam("je.checkpointer.highPriority", "true");
        if (Runtime.getRuntime().maxMemory() > 0x10000000L) {
            envConfig.setConfigParam("je.cleaner.lookAheadCacheSize", String.valueOf(0x200000));
            envConfig.setConfigParam("je.log.iteratorReadSize", String.valueOf(0x200000));
            envConfig.setConfigParam("je.log.faultReadSize", String.valueOf(4096));
        }
        envConfig.setLockTimeout(0L, TimeUnit.MICROSECONDS);
        return envConfig;
    }

    static EnvironmentConfig parseConfigEntry(JEBackendCfg cfg) throws ConfigException {
        ConfigurableEnvironment.validateDbCacheSize(cfg.getDBCacheSize());
        EnvironmentConfig envConfig = ConfigurableEnvironment.defaultConfig();
        ConfigurableEnvironment.setDurability(envConfig, cfg.isDBTxnNoSync(), cfg.isDBTxnWriteNoSync());
        ConfigurableEnvironment.setJEProperties((BackendCfg)cfg, envConfig, cfg.dn().rdn().getFirstAVA().getAttributeValue());
        ConfigurableEnvironment.setDBLoggingLevel(envConfig, cfg.getDBLoggingLevel(), cfg.dn(), cfg.isDBLoggingFileHandlerOn());
        return ConfigurableEnvironment.setJEProperties(envConfig, cfg.getJEProperty(), attrMap);
    }

    private static void validateDbCacheSize(long dbCacheSize) throws ConfigException {
        if (dbCacheSize != 0L) {
            if (MemoryBudget.getRuntimeMaxMemory() < dbCacheSize) {
                throw new ConfigException(BackendMessages.ERR_BACKEND_CONFIG_CACHE_SIZE_GREATER_THAN_JVM_HEAP.get((Object)dbCacheSize, (Object)MemoryBudget.getRuntimeMaxMemory()));
            }
            if (dbCacheSize < 98304L) {
                throw new ConfigException(BackendMessages.ERR_CONFIG_JEB_CACHE_SIZE_TOO_SMALL.get((Object)dbCacheSize, (Object)98304L));
            }
            MemoryQuota memoryQuota = DirectoryServer.getInstance().getServerContext().getMemoryQuota();
            if (!memoryQuota.acquireMemory(dbCacheSize)) {
                logger.warn(BackendMessages.ERR_BACKEND_CONFIG_CACHE_SIZE_GREATER_THAN_JVM_HEAP.get((Object)dbCacheSize, (Object)memoryQuota.getMaxMemory()));
            }
        }
    }

    private static void setDurability(EnvironmentConfig envConfig, boolean dbTxnNoSync, boolean dbTxnWriteNoSync) throws ConfigException {
        if (dbTxnNoSync && dbTxnWriteNoSync) {
            throw new ConfigException(BackendMessages.ERR_CONFIG_JEB_DURABILITY_CONFLICT.get());
        }
        if (dbTxnNoSync) {
            envConfig.setDurability(Durability.COMMIT_NO_SYNC);
        } else if (dbTxnWriteNoSync) {
            envConfig.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        }
    }

    private static void setJEProperties(BackendCfg cfg, EnvironmentConfig envConfig, ByteString backendId) {
        for (Map.Entry<String, String> mapEntry : attrMap.entrySet()) {
            String jeProperty = mapEntry.getKey();
            String attrName = mapEntry.getValue();
            String value = ConfigurableEnvironment.getPropertyValue(cfg, attrName, backendId);
            envConfig.setConfigParam(jeProperty, value);
        }
    }

    private static void setDBLoggingLevel(EnvironmentConfig envConfig, String loggingLevel, DN dn, boolean loggingFileHandlerOn) throws ConfigException {
        Logger parent = Logger.getLogger("com.sleepycat.je");
        try {
            parent.setLevel(Level.parse(loggingLevel));
        }
        catch (Exception e) {
            throw new ConfigException(BackendMessages.ERR_JEB_INVALID_LOGGING_LEVEL.get((Object)loggingLevel, (Object)dn));
        }
        Level level = loggingFileHandlerOn ? Level.ALL : Level.OFF;
        envConfig.setConfigParam("com.sleepycat.je.util.FileHandler.level", level.getName());
    }

    private static EnvironmentConfig setJEProperties(EnvironmentConfig envConfig, SortedSet<String> jeProperties, Map<String, String> configAttrMap) throws ConfigException {
        if (jeProperties.isEmpty()) {
            return envConfig;
        }
        HashSet<String> uniqueJEProperties = new HashSet<String>();
        for (String jeEntry : jeProperties) {
            StringTokenizer st = new StringTokenizer(jeEntry, "=");
            if (st.countTokens() != 2) {
                throw new ConfigException(ConfigMessages.ERR_CONFIG_JE_PROPERTY_INVALID_FORM.get((Object)jeEntry));
            }
            String jePropertyName = st.nextToken();
            String jePropertyValue = st.nextToken();
            if (uniqueJEProperties.contains(jePropertyName)) {
                throw new ConfigException(ConfigMessages.ERR_CONFIG_JE_DUPLICATE_PROPERTY.get((Object)jePropertyName));
            }
            try {
                envConfig.setConfigParam(jePropertyName, jePropertyValue);
                if (configAttrMap.containsKey(jePropertyName)) {
                    LocalizableMessage message = ConfigMessages.ERR_CONFIG_JE_PROPERTY_SHADOWS_CONFIG.get((Object)jePropertyName, (Object)attrMap.get(jePropertyName));
                    throw new ConfigException(message);
                }
                uniqueJEProperties.add(jePropertyName);
            }
            catch (IllegalArgumentException e) {
                logger.traceException((Throwable)e);
                LocalizableMessage message = ConfigMessages.ERR_CONFIG_JE_PROPERTY_INVALID.get((Object)jeEntry, (Object)e.getMessage());
                throw new ConfigException(message, e.getCause());
            }
        }
        return envConfig;
    }

    static {
        try {
            ConfigurableEnvironment.registerProp("je.maxMemoryPercent", ATTR_DATABASE_CACHE_PERCENT);
            ConfigurableEnvironment.registerProp("je.maxMemory", ATTR_DATABASE_CACHE_SIZE);
            ConfigurableEnvironment.registerProp("je.cleaner.minUtilization", ATTR_CLEANER_MIN_UTILIZATION);
            ConfigurableEnvironment.registerProp("je.env.runCleaner", ATTR_DATABASE_RUN_CLEANER);
            ConfigurableEnvironment.registerProp("je.evictor.lruOnly", ATTR_EVICTOR_LRU_ONLY);
            ConfigurableEnvironment.registerProp("je.evictor.nodesPerScan", ATTR_EVICTOR_NODES_PER_SCAN);
            ConfigurableEnvironment.registerProp("je.evictor.coreThreads", ATTR_EVICTOR_CORE_THREADS);
            ConfigurableEnvironment.registerProp("je.evictor.maxThreads", ATTR_EVICTOR_MAX_THREADS);
            ConfigurableEnvironment.registerProp("je.evictor.keepAlive", ATTR_EVICTOR_KEEP_ALIVE);
            ConfigurableEnvironment.registerProp("je.log.fileMax", ATTR_DATABASE_LOG_FILE_MAX);
            ConfigurableEnvironment.registerProp("je.checkpointer.bytesInterval", ATTR_CHECKPOINTER_BYTES_INTERVAL);
            ConfigurableEnvironment.registerProp("je.checkpointer.wakeupInterval", ATTR_CHECKPOINTER_WAKEUP_INTERVAL);
            ConfigurableEnvironment.registerProp("je.lock.nLockTables", ATTR_NUM_LOCK_TABLES);
            ConfigurableEnvironment.registerProp("je.cleaner.threads", ATTR_NUM_CLEANER_THREADS);
            ConfigurableEnvironment.registerProp("je.log.fileCacheSize", ATTR_LOG_FILECACHE_SIZE);
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
        }
    }
}

