/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.handlers.jdbc.CleanupHelper;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEvent;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEventExecutor;
import org.forgerock.audit.handlers.jdbc.JdbcUtils;
import org.forgerock.util.Reject;
import org.forgerock.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferedJdbcAuditEventExecutor
implements JdbcAuditEventExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BufferedJdbcAuditEventExecutor.class);
    private final JdbcAuditEventExecutor delegate;
    private final LinkedBlockingQueue<JdbcAuditEvent> queue;
    private volatile boolean stopRequested;
    private final ScheduledExecutorService queueWatcher;
    private final ExecutorService workerPool;
    private final boolean autoFlush;
    private final int maxBatchedEvents;
    private final DataSource dataSource;

    public BufferedJdbcAuditEventExecutor(int capacity, boolean autoFlush, JdbcAuditEventExecutor delegate, Duration writeInterval, int threads, int maxBatchedEvents, DataSource dataSource) {
        Reject.ifNull((Object)delegate);
        this.autoFlush = autoFlush;
        this.delegate = delegate;
        this.queue = new LinkedBlockingQueue(capacity);
        this.stopRequested = false;
        this.dataSource = dataSource;
        this.queueWatcher = Executors.newScheduledThreadPool(1);
        this.workerPool = Executors.newFixedThreadPool(threads);
        this.queueWatcher.scheduleAtFixedRate(new QueueWatcherThread(this.workerPool), 0L, writeInterval.to(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        this.maxBatchedEvents = maxBatchedEvents;
    }

    @Override
    public void flush() {
        block4: while (true) {
            try {
                while (!this.queue.isEmpty()) {
                    ArrayList<JdbcAuditEvent> events = new ArrayList<JdbcAuditEvent>(this.maxBatchedEvents);
                    this.queue.drainTo(events, this.maxBatchedEvents);
                    try {
                        this.workerPool.submit(new DatabaseWriterTask(events, this.dataSource));
                        continue block4;
                    }
                    catch (RejectedExecutionException e) {
                        this.queue.addAll(events);
                    }
                }
                break;
            }
            catch (Exception e) {
                logger.error("Unable to create remaining entries in the queue.", (Throwable)e);
                break;
            }
        }
    }

    @Override
    public void close() {
        this.stopRequested = true;
        if (this.autoFlush) {
            this.flush();
        }
        this.shutdownPool(this.queueWatcher);
        this.shutdownPool(this.workerPool);
        this.delegate.close();
    }

    @Override
    public void createAuditEvent(JdbcAuditEvent event) throws AuditException {
        while (!this.stopRequested && !this.queue.offer(event)) {
        }
    }

    @Override
    public List<Map<String, Object>> readAuditEvent(JdbcAuditEvent event) throws AuditException {
        return this.delegate.readAuditEvent(event);
    }

    @Override
    public List<Map<String, Object>> queryAuditEvent(JdbcAuditEvent event) throws AuditException {
        return this.delegate.queryAuditEvent(event);
    }

    private Map<String, Collection<JdbcAuditEvent>> groupSqlTemplatesToEvents(Collection<JdbcAuditEvent> events) {
        HashMap<String, Collection<JdbcAuditEvent>> sqlTemplatesToEvents = new HashMap<String, Collection<JdbcAuditEvent>>();
        for (JdbcAuditEvent event : events) {
            Collection<JdbcAuditEvent> jdbcAuditEvents;
            String sql = event.getSql();
            if (sqlTemplatesToEvents.containsKey(sql)) {
                jdbcAuditEvents = (Collection)sqlTemplatesToEvents.get(sql);
                jdbcAuditEvents.add(event);
                continue;
            }
            jdbcAuditEvents = new ArrayList();
            jdbcAuditEvents.add(event);
            sqlTemplatesToEvents.put(event.getSql(), jdbcAuditEvents);
        }
        return sqlTemplatesToEvents;
    }

    private void shutdownPool(ExecutorService executorService) {
        try {
            executorService.shutdown();
            while (!executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                logger.debug("Waiting to terminate the executor service.");
            }
        }
        catch (InterruptedException ex) {
            logger.error("Unable to terminate the executor service", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    private class DatabaseWriterTask
    implements Runnable {
        private final Collection<JdbcAuditEvent> events;
        private final DataSource dataSource;

        public DatabaseWriterTask(Collection<JdbcAuditEvent> events, DataSource dataSource) {
            this.events = (Collection)Reject.checkNotNull(events);
            this.dataSource = dataSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.events.isEmpty()) {
                return;
            }
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                connection.setAutoCommit(false);
                Map sqlTemplatesToEvents = BufferedJdbcAuditEventExecutor.this.groupSqlTemplatesToEvents(this.events);
                for (Map.Entry sqlTemplate : sqlTemplatesToEvents.entrySet()) {
                    String key = (String)sqlTemplate.getKey();
                    try (PreparedStatement preparedStatement = connection.prepareStatement(key);){
                        for (JdbcAuditEvent event : (Collection)sqlTemplate.getValue()) {
                            preparedStatement.clearParameters();
                            try {
                                JdbcUtils.initializePreparedStatement(preparedStatement, event.getParams());
                                preparedStatement.addBatch();
                            }
                            catch (Exception e) {
                                logger.error("Unable to create event in the queue", (Throwable)e);
                            }
                        }
                        preparedStatement.executeBatch();
                    }
                    CleanupHelper.commit(connection);
                }
            }
            catch (SQLException e) {
                logger.error("Unable to create events in the queue.", (Throwable)e);
                CleanupHelper.rollback(connection);
            }
            finally {
                CleanupHelper.close(connection);
            }
        }
    }

    private class QueueWatcherThread
    implements Runnable {
        private final ExecutorService workerPool;

        QueueWatcherThread(ExecutorService workerPool) {
            this.workerPool = workerPool;
        }

        @Override
        public void run() {
            while (!BufferedJdbcAuditEventExecutor.this.stopRequested && !BufferedJdbcAuditEventExecutor.this.queue.isEmpty()) {
                ArrayList<JdbcAuditEvent> events = new ArrayList<JdbcAuditEvent>(BufferedJdbcAuditEventExecutor.this.maxBatchedEvents);
                BufferedJdbcAuditEventExecutor.this.queue.drainTo(events, BufferedJdbcAuditEventExecutor.this.maxBatchedEvents);
                try {
                    this.workerPool.submit(new DatabaseWriterTask(events, BufferedJdbcAuditEventExecutor.this.dataSource));
                }
                catch (RejectedExecutionException e) {
                    BufferedJdbcAuditEventExecutor.this.queue.addAll(events);
                }
            }
        }
    }
}

