/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueTraverseFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.time.Duration;

public final class JsonValueFunctions {
    private static final Function<JsonValue, Charset, JsonValueException> TO_CHARSET = new Function<JsonValue, Charset, JsonValueException>(){

        @Override
        public Charset apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : Charset.forName(value.asString());
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new JsonValueException(value, (Throwable)e);
            }
        }
    };
    private static final Function<JsonValue, Duration, JsonValueException> TO_DURATION = new Function<JsonValue, Duration, JsonValueException>(){

        @Override
        public Duration apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : Duration.duration(value.asString());
            }
            catch (IllegalArgumentException iae) {
                throw new JsonValueException(value, (Throwable)iae);
            }
        }
    };
    private static final Function<JsonValue, File, JsonValueException> TO_FILE = new Function<JsonValue, File, JsonValueException>(){

        @Override
        public File apply(JsonValue value) throws JsonValueException {
            return value.isNull() ? null : new File(value.asString());
        }
    };
    private static final Function<JsonValue, Pattern, JsonValueException> TO_PATTERN = new Function<JsonValue, Pattern, JsonValueException>(){

        @Override
        public Pattern apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : Pattern.compile(value.asString());
            }
            catch (PatternSyntaxException pse) {
                throw new JsonValueException(value, (Throwable)pse);
            }
        }
    };
    private static final Function<JsonValue, JsonPointer, JsonValueException> TO_POINTER = new Function<JsonValue, JsonPointer, JsonValueException>(){

        @Override
        public JsonPointer apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : new JsonPointer(value.asString());
            }
            catch (JsonValueException jve) {
                throw jve;
            }
            catch (JsonException je) {
                throw new JsonValueException(value, (Throwable)je);
            }
        }
    };
    private static final Function<JsonValue, URL, JsonValueException> TO_URL = new Function<JsonValue, URL, JsonValueException>(){

        @Override
        public URL apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : new URL(value.asString());
            }
            catch (MalformedURLException e) {
                throw new JsonValueException(value, (Throwable)e);
            }
        }
    };
    private static final Function<JsonValue, URI, JsonValueException> TO_URI = new Function<JsonValue, URI, JsonValueException>(){

        @Override
        public URI apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : new URI(value.asString());
            }
            catch (URISyntaxException use) {
                throw new JsonValueException(value, (Throwable)use);
            }
        }
    };
    private static final Function<JsonValue, UUID, JsonValueException> TO_UUID = new Function<JsonValue, UUID, JsonValueException>(){

        @Override
        public UUID apply(JsonValue value) throws JsonValueException {
            try {
                return value.isNull() ? null : UUID.fromString(value.asString());
            }
            catch (IllegalArgumentException iae) {
                throw new JsonValueException(value, (Throwable)iae);
            }
        }
    };
    private static final Function<JsonValue, JsonValue, JsonValueException> IDENTITY = new Function<JsonValue, JsonValue, JsonValueException>(){

        @Override
        public JsonValue apply(JsonValue value) throws JsonValueException {
            return value.copy();
        }
    };

    private JsonValueFunctions() {
    }

    public static Function<JsonValue, Charset, JsonValueException> charset() {
        return TO_CHARSET;
    }

    public static Function<JsonValue, Duration, JsonValueException> duration() {
        return TO_DURATION;
    }

    public static <T extends Enum<T>> Function<JsonValue, T, JsonValueException> enumConstant(final Class<T> type) {
        return new Function<JsonValue, T, JsonValueException>(){

            @Override
            public T apply(JsonValue value) throws JsonValueException {
                return Utils.asEnum(value.asString(), type);
            }
        };
    }

    public static Function<JsonValue, File, JsonValueException> file() {
        return TO_FILE;
    }

    public static Function<JsonValue, Pattern, JsonValueException> pattern() {
        return TO_PATTERN;
    }

    public static Function<JsonValue, JsonPointer, JsonValueException> pointer() {
        return TO_POINTER;
    }

    public static Function<JsonValue, URI, JsonValueException> uri() {
        return TO_URI;
    }

    public static Function<JsonValue, URL, JsonValueException> url() {
        return TO_URL;
    }

    public static Function<JsonValue, UUID, JsonValueException> uuid() {
        return TO_UUID;
    }

    public static <V, E extends Exception> Function<JsonValue, List<V>, E> listOf(final Function<JsonValue, V, E> transformFunction) throws E {
        return new Function<JsonValue, List<V>, E>(){

            @Override
            public List<V> apply(JsonValue value) throws Exception {
                if (value.isCollection()) {
                    ArrayList list = new ArrayList(value.size());
                    for (JsonValue elem : value) {
                        list.add(elem.as(transformFunction));
                    }
                    return list;
                }
                return null;
            }
        };
    }

    public static <V, E extends Exception> Function<JsonValue, Set<V>, E> setOf(final Function<JsonValue, V, E> transformFunction) throws E {
        return new Function<JsonValue, Set<V>, E>(){

            @Override
            public Set<V> apply(JsonValue value) throws Exception {
                if (value.isCollection()) {
                    LinkedHashSet set = new LinkedHashSet(value.size());
                    for (JsonValue elem : value) {
                        set.add(elem.as(transformFunction));
                    }
                    return set;
                }
                return null;
            }
        };
    }

    public static <V> Function<JsonValue, Set<V>, JsonValueException> setOf(Class<V> type) {
        return JsonValueFunctions.setOf(new TypeFunction<V>(type));
    }

    public static Function<JsonValue, JsonValue, JsonValueException> deepTransformBy(Function<JsonValue, ?, JsonValueException> function) {
        return new JsonValueTraverseFunction(function);
    }

    public static Function<JsonValue, JsonValue, JsonValueException> identity() {
        return IDENTITY;
    }

    private static class TypeFunction<V>
    implements Function<JsonValue, V, JsonValueException> {
        private final Class<V> type;

        TypeFunction(Class<V> type) {
            this.type = Reject.checkNotNull(type);
        }

        @Override
        public V apply(JsonValue value) throws JsonValueException {
            if (value.isNull()) {
                return null;
            }
            Object object = value.getObject();
            if (this.type.isInstance(object)) {
                return this.type.cast(object);
            }
            throw new JsonValueException(value, "Expecting an element of type " + this.type.getName());
        }
    }
}

