/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.retention;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.retention.FileNamingPolicy;
import org.forgerock.audit.retention.RetentionPolicy;
import org.forgerock.audit.util.LastModifiedTimeFileComparator;

public class FreeDiskSpaceRetentionPolicy
implements RetentionPolicy {
    private final long minFreeSpaceRequired;
    private final Comparator<File> comparator = new LastModifiedTimeFileComparator();

    public FreeDiskSpaceRetentionPolicy(long minFreeSpaceRequired) {
        this.minFreeSpaceRequired = minFreeSpaceRequired;
    }

    @Override
    public List<File> deleteFiles(FileNamingPolicy fileNamingPolicy) {
        List<File> archivedFiles = fileNamingPolicy.listFiles();
        if (archivedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        long freeSpace = archivedFiles.get(0).getUsableSpace();
        if (freeSpace >= this.minFreeSpaceRequired) {
            return Collections.emptyList();
        }
        long freeSpaceNeeded = this.minFreeSpaceRequired - freeSpace;
        Collections.sort(archivedFiles, this.comparator);
        long freedSpace = 0L;
        LinkedList<File> filesToDelete = new LinkedList<File>();
        for (File file : archivedFiles) {
            filesToDelete.add(file);
            if ((freedSpace += file.length()) < freeSpaceNeeded) continue;
            break;
        }
        return filesToDelete;
    }
}

