/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.retention;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.retention.FileNamingPolicy;
import org.forgerock.audit.retention.RetentionPolicy;
import org.forgerock.audit.util.LastModifiedTimeFileComparator;

public class DiskSpaceUsedRetentionPolicy
implements RetentionPolicy {
    private final long maxDiskSpaceToUse;
    private final Comparator<File> comparator = new LastModifiedTimeFileComparator();

    public DiskSpaceUsedRetentionPolicy(long maxDiskSpaceToUse) {
        this.maxDiskSpaceToUse = maxDiskSpaceToUse;
    }

    @Override
    public List<File> deleteFiles(FileNamingPolicy fileNamingPolicy) {
        List<File> archivedFiles = fileNamingPolicy.listFiles();
        long currentDiskSpaceUsed = 0L;
        for (File file : archivedFiles) {
            currentDiskSpaceUsed += file.length();
        }
        if (currentDiskSpaceUsed <= this.maxDiskSpaceToUse) {
            return Collections.emptyList();
        }
        long freeSpaceNeeded = currentDiskSpaceUsed - this.maxDiskSpaceToUse;
        Collections.sort(archivedFiles, this.comparator);
        long freedSpace = 0L;
        LinkedList<File> filesToDelete = new LinkedList<File>();
        for (File file : archivedFiles) {
            filesToDelete.add(file);
            if ((freedSpace += file.length()) < freeSpaceNeeded) continue;
            break;
        }
        return filesToDelete;
    }
}

