/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.audit.events.AuditEvent;
import org.forgerock.audit.util.DateUtil;
import org.forgerock.json.JsonValue;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.TransactionIdContext;
import org.forgerock.util.Reject;

public abstract class AuditEventBuilder<T extends AuditEventBuilder<T>> {
    public static final String EVENT_NAME = "eventName";
    public static final String TIMESTAMP = "timestamp";
    public static final String TRANSACTION_ID = "transactionId";
    public static final String USER_ID = "userId";
    public static final String TRACKING_IDS = "trackingIds";
    protected JsonValue jsonValue = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
    private boolean superValidateCalled = false;
    private boolean superSetDefaultsCalled = false;
    private final Set<String> trackingIdEntries = new LinkedHashSet<String>();

    protected AuditEventBuilder() {
    }

    protected final T self() {
        return (T)this;
    }

    public final AuditEvent toEvent() {
        this.superSetDefaultsCalled = false;
        this.setDefaults();
        if (!this.superSetDefaultsCalled) {
            throw new IllegalStateException("Subclasses overriding setDefaults() must call super.setDefaults()");
        }
        this.superValidateCalled = false;
        this.validate();
        if (!this.superValidateCalled) {
            throw new IllegalStateException("Subclasses overriding validate() must call super.validate()");
        }
        AuditEvent auditEvent = new AuditEvent(this.jsonValue);
        this.jsonValue = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
        return auditEvent;
    }

    protected void setDefaults() {
        if (!this.jsonValue.isDefined(TIMESTAMP)) {
            this.timestamp(System.currentTimeMillis());
        }
        if (!this.trackingIdEntries.isEmpty()) {
            this.jsonValue.put(TRACKING_IDS, (Object)JsonValue.array((Object[])this.trackingIdEntries.toArray()));
        }
        this.superSetDefaultsCalled = true;
    }

    protected void validate() {
        this.requireField(EVENT_NAME);
        this.requireField(TRANSACTION_ID);
        this.superValidateCalled = true;
    }

    protected void requireField(String rootFieldName) {
        if (!this.jsonValue.isDefined(rootFieldName)) {
            throw new IllegalStateException("The field " + rootFieldName + " is mandatory.");
        }
    }

    public final T eventName(String name) {
        this.jsonValue.put(EVENT_NAME, (Object)name);
        return this.self();
    }

    public final T timestamp(long timestamp) {
        Reject.ifTrue((timestamp <= 0L ? 1 : 0) != 0, (String)"The timestamp has to be greater than 0.");
        this.jsonValue.put(TIMESTAMP, (Object)DateUtil.getDateUtil("UTC").formatDateTime(timestamp));
        return this.self();
    }

    public final T transactionId(String id) {
        Reject.ifNull((Object)id);
        this.jsonValue.put(TRANSACTION_ID, (Object)id);
        return this.self();
    }

    public final T userId(String id) {
        this.jsonValue.put(USER_ID, (Object)id);
        return this.self();
    }

    public final T trackingId(String trackingIdValue) {
        Reject.ifNull((Object)trackingIdValue, (String)"trackingId value cannot be null");
        this.trackingIdEntries.add(trackingIdValue);
        return this.self();
    }

    public final T trackingIds(Set<String> trackingIdValues) {
        for (String trackingIdValue : trackingIdValues) {
            this.trackingId(trackingIdValue);
        }
        return this.self();
    }

    public final T transactionIdFromContext(Context context) {
        if (context.containsContext(TransactionIdContext.class)) {
            TransactionIdContext transactionIdContext = (TransactionIdContext)context.asContext(TransactionIdContext.class);
            this.transactionId(transactionIdContext.getTransactionId().getValue());
        }
        return this.self();
    }
}

