/*
 * The contents of this file are subject to the terms of the Common Development and
 * Distribution License (the License). You may not use this file except in compliance with the
 * License.
 *
 * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 * specific language governing permission and limitations under the License.
 *
 * When distributing Covered Software, include this CDDL Header Notice in each file and include
 * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 * Header, with the fields enclosed by brackets [] replaced by your own identifying
 * information: "Portions Copyright [year] [name of copyright owner]".
 *
 * Copyright 2008-2010 Sun Microsystems, Inc.
 * Portions Copyright 2014 ForgeRock AS.
 */

package org.opends.guitools.controlpanel.browser;

import javax.naming.NamingException;

import org.forgerock.i18n.LocalizableMessage;

/**
 * The exception that is launched when we exceed the maximum number of hops
 * following referrals.
 *
 */
public class ReferralLimitExceededException extends NamingException
{
  private static final long serialVersionUID = -5640515839144837865L;

  /**
   * Constructor of the exception.
   * @param message the message associated with the exception.
   */
  public ReferralLimitExceededException(LocalizableMessage message)
  {
    super(message.toString());
  }
}
