/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorData;
import org.opends.server.api.MonitorProvider;
import org.opends.server.util.StaticUtils;

final class JEMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final String name;
    private final Environment env;

    JEMonitor(String name, Environment env) {
        this.name = name;
        this.env = env;
    }

    public String getMonitorInstanceName() {
        return this.name;
    }

    public MonitorData getMonitorData() {
        try {
            StatsConfig statsConfig = new StatsConfig();
            MonitorData monitorAttrs = new MonitorData();
            monitorAttrs.add("JEVersion", (Object)JEVersion.CURRENT_VERSION.getVersionString());
            monitorAttrs.addBean((Object)this.env.getStats(statsConfig), "Environment");
            monitorAttrs.addBean((Object)this.env.getTransactionStats(statsConfig), "Transaction");
            return monitorAttrs;
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            MonitorData monitorAttrs = new MonitorData(1);
            monitorAttrs.add("JEInfo", (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
            return monitorAttrs;
        }
    }
}

