/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.query;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.forgerock.util.query.QueryFilter;

public abstract class QueryFilterParser<F> {
    private static final int VALUE_OF_MAX_DEPTH = 256;

    protected abstract F parseField(String var1);

    public QueryFilter<F> valueOf(String string) {
        FilterTokenizer tokenizer = new FilterTokenizer(string);
        QueryFilter<F> filter = this.valueOfOrExpr(tokenizer, 0);
        if (tokenizer.hasNext()) {
            return this.valueOfIllegalArgument(tokenizer);
        }
        return filter;
    }

    private void checkDepth(FilterTokenizer tokenizer, int depth) {
        if (depth > 256) {
            throw new IllegalArgumentException("The query filter '" + tokenizer + "' cannot be parsed because it contains more than " + 256 + " nexted expressions");
        }
    }

    private QueryFilter<F> valueOfAndExpr(FilterTokenizer tokenizer, int depth) {
        this.checkDepth(tokenizer, depth);
        QueryFilter<Object> filter = this.valueOfNotExpr(tokenizer, depth + 1);
        LinkedList<QueryFilter<F>> subFilters = null;
        while (tokenizer.hasNext() && tokenizer.peek().equalsIgnoreCase("and")) {
            tokenizer.next();
            if (subFilters == null) {
                subFilters = new LinkedList<QueryFilter<F>>();
                subFilters.add(filter);
            }
            subFilters.add(this.valueOfNotExpr(tokenizer, depth + 1));
        }
        if (subFilters != null) {
            filter = QueryFilter.and(subFilters);
        }
        return filter;
    }

    private QueryFilter<F> valueOfIllegalArgument(FilterTokenizer tokenizer) {
        throw new IllegalArgumentException("Invalid query filter '" + tokenizer + "'");
    }

    private QueryFilter<F> valueOfNotExpr(FilterTokenizer tokenizer, int depth) {
        this.checkDepth(tokenizer, depth);
        if (tokenizer.hasNext() && tokenizer.peek().equalsIgnoreCase("!")) {
            tokenizer.next();
            QueryFilter<F> rhs = this.valueOfPrimaryExpr(tokenizer, depth + 1);
            return QueryFilter.not(rhs);
        }
        return this.valueOfPrimaryExpr(tokenizer, depth + 1);
    }

    private QueryFilter<F> valueOfOrExpr(FilterTokenizer tokenizer, int depth) {
        this.checkDepth(tokenizer, depth);
        QueryFilter<Object> filter = this.valueOfAndExpr(tokenizer, depth + 1);
        LinkedList<QueryFilter<F>> subFilters = null;
        while (tokenizer.hasNext() && tokenizer.peek().equalsIgnoreCase("or")) {
            tokenizer.next();
            if (subFilters == null) {
                subFilters = new LinkedList<QueryFilter<F>>();
                subFilters.add(filter);
            }
            subFilters.add(this.valueOfAndExpr(tokenizer, depth + 1));
        }
        if (subFilters != null) {
            filter = QueryFilter.or(subFilters);
        }
        return filter;
    }

    private QueryFilter<F> valueOfPrimaryExpr(FilterTokenizer tokenizer, int depth) {
        Object assertionValue;
        this.checkDepth(tokenizer, depth);
        if (!tokenizer.hasNext()) {
            return this.valueOfIllegalArgument(tokenizer);
        }
        String nextToken = tokenizer.next();
        if (nextToken.equals("(")) {
            QueryFilter<F> filter = this.valueOfOrExpr(tokenizer, depth + 1);
            if (!tokenizer.hasNext() || !tokenizer.next().equals(")")) {
                return this.valueOfIllegalArgument(tokenizer);
            }
            return filter;
        }
        if (nextToken.equalsIgnoreCase("true")) {
            return QueryFilter.alwaysTrue();
        }
        if (nextToken.equalsIgnoreCase("false")) {
            return QueryFilter.alwaysFalse();
        }
        if (nextToken.equals("\"")) {
            return this.valueOfIllegalArgument(tokenizer);
        }
        F pointer = this.parseField(nextToken);
        if (!tokenizer.hasNext()) {
            return this.valueOfIllegalArgument(tokenizer);
        }
        String operator = tokenizer.next();
        if (operator.equalsIgnoreCase("pr")) {
            return QueryFilter.present(pointer);
        }
        if (!tokenizer.hasNext()) {
            return this.valueOfIllegalArgument(tokenizer);
        }
        nextToken = tokenizer.next();
        if (nextToken.equals("\"")) {
            if (!tokenizer.hasNext()) {
                return this.valueOfIllegalArgument(tokenizer);
            }
            assertionValue = tokenizer.next();
            if (!tokenizer.hasNext() || !tokenizer.next().equals("\"")) {
                return this.valueOfIllegalArgument(tokenizer);
            }
        } else if (nextToken.equals("'")) {
            if (!tokenizer.hasNext()) {
                return this.valueOfIllegalArgument(tokenizer);
            }
            assertionValue = tokenizer.next();
            if (!tokenizer.hasNext() || !tokenizer.next().equals("'")) {
                return this.valueOfIllegalArgument(tokenizer);
            }
        } else {
            assertionValue = nextToken.equalsIgnoreCase("true") || nextToken.equalsIgnoreCase("false") ? (Serializable)Boolean.valueOf(Boolean.parseBoolean(nextToken)) : (Serializable)(nextToken.indexOf(46) >= 0 ? (Number)Double.parseDouble(nextToken) : (Number)Long.parseLong(nextToken));
        }
        try {
            return this.comparisonFilter(pointer, operator, assertionValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.valueOfIllegalArgument(tokenizer);
        }
    }

    private QueryFilter<F> comparisonFilter(F field, String operator, Object valueAssertion) {
        if (operator.equalsIgnoreCase("eq")) {
            return QueryFilter.equalTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("gt")) {
            return QueryFilter.greaterThan(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("ge")) {
            return QueryFilter.greaterThanOrEqualTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("lt")) {
            return QueryFilter.lessThan(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("le")) {
            return QueryFilter.lessThanOrEqualTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("co")) {
            return QueryFilter.contains(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("sw")) {
            return QueryFilter.startsWith(field, valueAssertion);
        }
        if (operator.matches("[a-zA-Z_0-9.]+")) {
            return QueryFilter.extendedMatch(field, operator, valueAssertion);
        }
        throw new IllegalArgumentException("\"" + operator + "\" is not a valid filter operator");
    }

    private static final class FilterTokenizer
    implements Iterator<String> {
        private static final int NEED_END_STRING = 2;
        private static final int NEED_START_STRING = 1;
        private static final int NEED_TOKEN = 0;
        private String filterString;
        private String nextToken;
        private int pos;
        private int state;
        private char stringDelimiter;

        private FilterTokenizer(String filterString) {
            this.filterString = filterString;
            this.pos = 0;
            this.state = 0;
            this.readNextToken();
        }

        @Override
        public boolean hasNext() {
            return this.nextToken != null;
        }

        @Override
        public String next() {
            String next = this.peek();
            this.readNextToken();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.filterString;
        }

        private String peek() {
            if (this.nextToken == null) {
                throw new NoSuchElementException();
            }
            return this.nextToken;
        }

        private void readNextToken() {
            switch (this.state) {
                case 1: {
                    int stringStart = this.pos;
                    while (this.pos < this.filterString.length() && this.filterString.charAt(this.pos) != this.stringDelimiter) {
                        if (this.filterString.charAt(this.pos) == '\\') {
                            if (this.pos + 1 == this.filterString.length()) {
                                throw new IllegalArgumentException("The filter string cannot end with an escape character");
                            }
                            this.filterString = new StringBuilder(this.filterString).deleteCharAt(this.pos).toString();
                        }
                        ++this.pos;
                    }
                    this.nextToken = this.filterString.substring(stringStart, this.pos);
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.nextToken = this.pos < this.filterString.length() ? this.filterString.substring(this.pos, ++this.pos) : null;
                    this.state = 0;
                    break;
                }
                default: {
                    if (!this.skipWhiteSpace()) {
                        this.nextToken = null;
                        break;
                    }
                    int tokenStart = this.pos;
                    block4 : switch (this.filterString.charAt(this.pos++)) {
                        case '(': 
                        case ')': {
                            break;
                        }
                        case '\"': {
                            this.state = 1;
                            this.stringDelimiter = (char)34;
                            break;
                        }
                        case '\'': {
                            this.state = 1;
                            this.stringDelimiter = (char)39;
                            break;
                        }
                        default: {
                            while (this.pos < this.filterString.length()) {
                                char c = this.filterString.charAt(this.pos);
                                if (c == '(' || c == ')' || c == ' ') break block4;
                                ++this.pos;
                            }
                            break block4;
                        }
                    }
                    this.nextToken = this.filterString.substring(tokenStart, this.pos);
                }
            }
        }

        private boolean skipWhiteSpace() {
            while (this.pos < this.filterString.length() && this.filterString.charAt(this.pos) == ' ') {
                ++this.pos;
            }
            return this.pos < this.filterString.length();
        }
    }
}

