/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.AuditService;
import org.forgerock.audit.AuditServiceConfiguration;
import org.forgerock.audit.AuditServiceImpl;
import org.forgerock.audit.DependencyProvider;
import org.forgerock.audit.DependencyProviderBase;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.EventTopicsMetaDataBuilder;
import org.forgerock.audit.events.handlers.AuditEventHandler;
import org.forgerock.audit.events.handlers.AuditEventHandlerFactory;
import org.forgerock.audit.events.handlers.DependencyProviderAuditEventHandlerFactory;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AuditServiceBuilder.class);
    private final AuditServiceFactory auditServiceFactory;
    private AuditServiceConfiguration auditServiceConfiguration = new AuditServiceConfiguration();
    private AuditEventHandlerFactory auditEventHandlerFactory = new DependencyProviderAuditEventHandlerFactory(new DependencyProviderBase());
    private Map<String, HandlerRegistration> handlerRegistrations = new LinkedHashMap<String, HandlerRegistration>();
    private Set<AuditEventHandler> prebuiltHandlers = new LinkedHashSet<AuditEventHandler>();
    private EventTopicsMetaData eventTopicsMetaData = EventTopicsMetaDataBuilder.coreTopicSchemas().build();

    @VisibleForTesting
    AuditServiceBuilder(AuditServiceFactory auditServiceFactory) {
        this.auditServiceFactory = auditServiceFactory;
    }

    public static AuditServiceBuilder newAuditService() {
        return new AuditServiceBuilder(new AuditServiceFactory());
    }

    public AuditServiceBuilder withConfiguration(AuditServiceConfiguration auditServiceConfiguration) {
        Reject.ifNull((Object)auditServiceConfiguration, (String)"Audit service configuration cannot be null");
        this.auditServiceConfiguration = auditServiceConfiguration;
        return this;
    }

    public AuditServiceBuilder withEventTopicsMetaData(EventTopicsMetaData eventTopicsMetaData) {
        Reject.ifNull((Object)eventTopicsMetaData, (String)"Audit service event topic meta-data cannot be null");
        this.eventTopicsMetaData = eventTopicsMetaData;
        return this;
    }

    public AuditServiceBuilder withDependencyProvider(DependencyProvider dependencyProvider) {
        Reject.ifNull((Object)dependencyProvider, (String)"Audit event handler DependencyProvider cannot be null");
        this.auditEventHandlerFactory = new DependencyProviderAuditEventHandlerFactory(dependencyProvider);
        return this;
    }

    public AuditServiceBuilder withAuditEventHandlerFactory(AuditEventHandlerFactory auditEventHandlerFactory) {
        Reject.ifNull((Object)auditEventHandlerFactory, (String)"AuditEventHandlerFactory cannot be null");
        this.auditEventHandlerFactory = auditEventHandlerFactory;
        return this;
    }

    public AuditServiceBuilder withAuditEventHandler(Class<? extends AuditEventHandler> clazz, EventHandlerConfiguration configuration) throws AuditException {
        Reject.ifNull(clazz, (String)"Audit event handler clazz cannot be null");
        Reject.ifNull((Object)configuration, (String)"Audit event handler configuration cannot be null");
        Reject.ifNull((Object)configuration.getName(), (String)"Audit event handler name cannot be null");
        this.rejectIfHandlerNameAlreadyTaken(configuration.getName());
        this.handlerRegistrations.put(configuration.getName(), new HandlerRegistration(clazz, configuration, null));
        return this;
    }

    public AuditServiceBuilder withAuditEventHandler(AuditEventHandler auditEventHandler) throws AuditException {
        Reject.ifNull((Object)auditEventHandler, (String)"Audit event handler cannot be null");
        this.rejectIfHandlerNameAlreadyTaken(auditEventHandler.getName());
        this.prebuiltHandlers.add(auditEventHandler);
        return this;
    }

    private void rejectIfHandlerNameAlreadyTaken(String name) throws AuditException {
        if (this.handlerRegistrations.containsKey(name)) {
            throw new AuditException("There is already a handler registered for " + name);
        }
        for (AuditEventHandler handler : this.prebuiltHandlers) {
            if (handler.getName() == null || !handler.getName().equals(name)) continue;
            throw new AuditException("There is already a handler registered for " + name);
        }
    }

    public AuditService build() {
        Set<AuditEventHandler> handlers = this.buildAuditEventHandlers(this.eventTopicsMetaData);
        return this.auditServiceFactory.newAuditService(this.auditServiceConfiguration, this.eventTopicsMetaData, handlers);
    }

    private Set<AuditEventHandler> buildAuditEventHandlers(EventTopicsMetaData eventTopicsMetaData) {
        LinkedHashSet<AuditEventHandler> handlers = new LinkedHashSet<AuditEventHandler>(this.prebuiltHandlers);
        for (HandlerRegistration handlerRegistration : this.handlerRegistrations.values()) {
            logger.debug("Registering handler '{}' for {} topics", (Object)((EventHandlerConfiguration)handlerRegistration.configuration).getName(), (Object)((EventHandlerConfiguration)handlerRegistration.configuration).getTopics().toString());
            try {
                handlers.add(this.auditEventHandlerFactory.create(((EventHandlerConfiguration)handlerRegistration.configuration).getName(), handlerRegistration.clazz, (EventHandlerConfiguration)handlerRegistration.configuration, eventTopicsMetaData));
            }
            catch (AuditException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.debug("Registered {}", (Object)((Object)handlers).toString());
        return handlers;
    }

    static class 1 {
    }

    @VisibleForTesting
    static class AuditServiceFactory {
        AuditServiceFactory() {
        }

        AuditService newAuditService(AuditServiceConfiguration configuration, EventTopicsMetaData eventTopicsMetaData, Set<AuditEventHandler> auditEventHandlers) {
            return new AuditServiceImpl(configuration, eventTopicsMetaData, auditEventHandlers);
        }
    }

    private static class HandlerRegistration<C extends EventHandlerConfiguration> {
        final Class<? extends AuditEventHandler> clazz;
        final C configuration;

        private HandlerRegistration(Class<? extends AuditEventHandler> clazz, C configuration) {
            this.clazz = clazz;
            this.configuration = configuration;
        }

        /* synthetic */ HandlerRegistration(Class x0, EventHandlerConfiguration x1, 1 x2) {
            this(x0, x1);
        }
    }
}

