/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.forgerock.audit.events.handlers.FileBasedEventHandlerConfiguration;
import org.forgerock.audit.events.handlers.writers.AsynchronousTextWriter;
import org.forgerock.audit.events.handlers.writers.RotatableWriter;
import org.forgerock.audit.events.handlers.writers.TextWriter;
import org.forgerock.audit.events.handlers.writers.TextWriterAdapter;
import org.forgerock.audit.handlers.csv.CsvAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.csv.CsvFormatter;
import org.forgerock.audit.handlers.csv.CsvRotationHooks;
import org.forgerock.audit.handlers.csv.CsvWriter;
import org.forgerock.audit.rotation.RotationHooks;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

class StandardCsvWriter
implements CsvWriter {
    private static final Logger logger = LoggerFactory.getLogger(StandardCsvWriter.class);
    private final CsvFormatter csvFormatter;
    private final String[] headers;
    private final Writer csvWriter;
    private RotatableWriter rotatableWriter;

    StandardCsvWriter(File csvFile, String[] headers, CsvPreference csvPreference, CsvAuditEventHandlerConfiguration config) throws IOException {
        Reject.ifTrue((boolean)config.getSecurity().isEnabled(), (String)"StandardCsvWriter should not be used if security is enabled");
        boolean fileAlreadyInitialized = csvFile.exists();
        if (fileAlreadyInitialized) {
            try (CsvMapReader reader = new CsvMapReader((Reader)new BufferedReader(new FileReader(csvFile)), csvPreference);){
                String[] actualHeaders = reader.getHeader(true);
                if (actualHeaders == null) {
                    fileAlreadyInitialized = false;
                } else {
                    if (actualHeaders.length != headers.length) {
                        throw new IOException("Resuming an existing CSV file but the headers do not match.");
                    }
                    for (int idx = 0; idx < actualHeaders.length; ++idx) {
                        if (actualHeaders[idx].equals(headers[idx])) continue;
                        throw new IOException("Resuming an existing CSV file but the headers do not match.");
                    }
                }
            }
        }
        this.headers = (String[])Reject.checkNotNull((Object)headers, (String)"The headers can't be null.");
        this.csvFormatter = new CsvFormatter(csvPreference);
        this.csvWriter = this.constructWriter(csvFile, fileAlreadyInitialized, config);
        if (this.rotatableWriter != null) {
            this.rotatableWriter.registerRotationHooks((RotationHooks)new CsvRotationHooks(this.csvFormatter, headers));
        }
        if (!fileAlreadyInitialized) {
            this.writeHeader(headers);
            this.csvWriter.flush();
        }
    }

    private Writer constructWriter(File csvFile, boolean append, CsvAuditEventHandlerConfiguration config) throws IOException {
        TextWriter.Stream textWriter;
        if (config.getFileRotation().isRotationEnabled()) {
            this.rotatableWriter = new RotatableWriter(csvFile, (FileBasedEventHandlerConfiguration)config, append);
            textWriter = this.rotatableWriter;
        } else {
            textWriter = new TextWriter.Stream((OutputStream)new FileOutputStream(csvFile, append));
        }
        if (config.getBuffering().isEnabled()) {
            CsvAuditEventHandlerConfiguration.EventBufferingConfiguration bufferConfig = config.getBuffering();
            textWriter = new AsynchronousTextWriter("CsvHandler", bufferConfig.isAutoFlush(), (TextWriter)textWriter);
        }
        return new TextWriterAdapter((TextWriter)textWriter);
    }

    @Override
    public boolean forceRotation() throws IOException {
        return this.rotatableWriter != null ? this.rotatableWriter.forceRotation() : false;
    }

    public void writeHeader(String ... headers) throws IOException {
        this.csvWriter.write(this.csvFormatter.formatHeader(headers));
    }

    @Override
    public void writeEvent(Map<String, String> values) throws IOException {
        this.csvWriter.write(this.csvFormatter.formatEvent(values, this.headers));
    }

    @Override
    public void flush() throws IOException {
        this.csvWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }
}

