/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Reject;
import org.forgerock.util.generator.IdGenerator;

public final class TransactionId {
    private final String value;
    private final AtomicInteger subTransactionIdCounter;

    public TransactionId() {
        this(IdGenerator.DEFAULT.generate());
    }

    public TransactionId(String value) {
        this(value, 0);
    }

    private TransactionId(String value, int counter) {
        Reject.ifTrue((value == null || value.isEmpty() ? 1 : 0) != 0, (String)"The value must not be null nor empty.");
        this.value = value;
        this.subTransactionIdCounter = new AtomicInteger(counter);
    }

    public String getValue() {
        return this.value;
    }

    public TransactionId createSubTransactionId() {
        String subTransactionId = this.value + "/" + this.subTransactionIdCounter.getAndIncrement();
        return new TransactionId(subTransactionId);
    }

    public JsonValue toJson() {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"value", (Object)this.value), JsonValue.field((String)"subTransactionIdCounter", (Object)this.subTransactionIdCounter.get())}));
    }

    public static TransactionId valueOf(JsonValue value) {
        return new TransactionId(value.get("value").required().asString(), value.get("subTransactionIdCounter").required().asInteger());
    }
}

