/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.util.HashMap;
import java.util.Map;

public final class Status {
    private static final Map<Integer, Status> KNOWN_STATUSES = new HashMap<Integer, Status>();
    private final int code;
    private final String reasonPhrase;
    private final Family family;
    public static final Status CONTINUE = Status.newStatus(100, "Continue");
    public static final Status SWITCHING_PROTOCOLS = Status.newStatus(101, "Switching Protocols");
    public static final Status OK = Status.newStatus(200, "OK");
    public static final Status CREATED = Status.newStatus(201, "Created");
    public static final Status ACCEPTED = Status.newStatus(202, "Accepted");
    public static final Status NON_AUTHORITATIVE_INFO = Status.newStatus(203, "Non-Authoritative Information");
    public static final Status NO_CONTENT = Status.newStatus(204, "No Content");
    public static final Status RESET_CONTENT = Status.newStatus(205, "Reset Content");
    public static final Status MULTIPLE_CHOICES = Status.newStatus(300, "Multiple Choices");
    public static final Status MOVED_PERMANENTLY = Status.newStatus(301, "Moved Permanently");
    public static final Status FOUND = Status.newStatus(302, "Found");
    public static final Status SEE_OTHER = Status.newStatus(303, "See Other");
    public static final Status USE_PROXY = Status.newStatus(305, "Use Proxy");
    public static final Status UNUSED = Status.newStatus(306, "Unused");
    public static final Status TEMPORARY_REDIRECT = Status.newStatus(307, "Temporary Redirect");
    public static final Status BAD_REQUEST = Status.newStatus(400, "Bad Request");
    public static final Status UNAUTHORIZED = Status.newStatus(401, "Unauthorized");
    public static final Status PAYMENT_REQUIRED = Status.newStatus(402, "Payment Required");
    public static final Status FORBIDDEN = Status.newStatus(403, "Forbidden");
    public static final Status NOT_FOUND = Status.newStatus(404, "Not Found");
    public static final Status METHOD_NOT_ALLOWED = Status.newStatus(405, "Method Not Allowed");
    public static final Status NOT_ACCEPTABLE = Status.newStatus(406, "Not Acceptable");
    public static final Status REQUEST_TIMEOUT = Status.newStatus(408, "Request Timeout");
    public static final Status CONFLICT = Status.newStatus(409, "Conflict");
    public static final Status GONE = Status.newStatus(410, "Gone");
    public static final Status LENGTH_REQUIRED = Status.newStatus(411, "Length Required");
    public static final Status PAYLOAD_TOO_LARGE = Status.newStatus(413, "Payload Too Large");
    public static final Status URI_TOO_LONG = Status.newStatus(414, "URI Too Long");
    public static final Status UNSUPPORTED_MEDIA_TYPE = Status.newStatus(415, "Unsupported Media Type");
    public static final Status EXPECTATION_FAILED = Status.newStatus(417, "Expectation Failed");
    public static final Status TEAPOT = Status.newStatus(418, "I'm a teapot");
    public static final Status UPGRADE_REQUIRED = Status.newStatus(426, "Upgrade Required");
    public static final Status TOO_MANY_REQUESTS = Status.newStatus(429, "Too Many Requests");
    public static final Status INTERNAL_SERVER_ERROR = Status.newStatus(500, "Internal Server Error");
    public static final Status NOT_IMPLEMENTED = Status.newStatus(501, "Not Implemented");
    public static final Status BAD_GATEWAY = Status.newStatus(502, "Bad Gateway");
    public static final Status SERVICE_UNAVAILABLE = Status.newStatus(503, "Service Unavailable");
    public static final Status GATEWAY_TIMEOUT = Status.newStatus(504, "Gateway Timeout");
    public static final Status HTTP_VERSION_NOT_SUPPORTED = Status.newStatus(505, "HTTP Version Not Supported");

    private Status(int code, String reasonPhrase) {
        this.code = code;
        this.reasonPhrase = reasonPhrase;
        this.family = Family.valueOf(code);
    }

    public String toString() {
        return "[Status: " + this.code + " " + (this.reasonPhrase == null ? "No reason given" : this.reasonPhrase) + "]";
    }

    public int getCode() {
        return this.code;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Family getFamily() {
        return this.family;
    }

    public boolean isInformational() {
        return Family.INFORMATIONAL.equals((Object)this.getFamily());
    }

    public boolean isSuccessful() {
        return Family.SUCCESSFUL.equals((Object)this.getFamily());
    }

    public boolean isRedirection() {
        return Family.REDIRECTION.equals((Object)this.getFamily());
    }

    public boolean isClientError() {
        return Family.CLIENT_ERROR.equals((Object)this.getFamily());
    }

    public boolean isServerError() {
        return Family.SERVER_ERROR.equals((Object)this.getFamily());
    }

    public static Status valueOf(int code) {
        return Status.valueOf(code, "Unknown");
    }

    public static Status valueOf(int code, String reason) {
        Status status = KNOWN_STATUSES.get(code);
        if (status != null) {
            return status;
        }
        return Status.newStatus(code, reason);
    }

    private static Status newStatus(int code, String reason) {
        if (KNOWN_STATUSES.containsKey(code)) {
            throw new IllegalArgumentException(String.format("The code %s is already registered.", code));
        }
        Status status = new Status(code, reason);
        KNOWN_STATUSES.put(code, status);
        return status;
    }

    public static enum Family {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        UNKNOWN;


        public static Family valueOf(int code) {
            if (code < 100 || code >= 1000) {
                throw new IllegalArgumentException(String.format("Given code '%d' is invalid", code));
            }
            if (code >= 100 && code < 200) {
                return INFORMATIONAL;
            }
            if (code >= 200 && code < 300) {
                return SUCCESSFUL;
            }
            if (code >= 300 && code < 400) {
                return REDIRECTION;
            }
            if (code >= 400 && code < 500) {
                return CLIENT_ERROR;
            }
            if (code >= 500 && code < 600) {
                return SERVER_ERROR;
            }
            return UNKNOWN;
        }
    }
}

