/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Cookie {
    private String name;
    private String value;
    private String comment;
    private String commentURL;
    private Boolean discard;
    private String domain;
    private Date expires;
    private Boolean httpOnly;
    private Integer maxAge;
    private String path;
    private final List<Integer> port = new ArrayList<Integer>();
    private Boolean secure;
    private Integer version;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)obj;
        return Cookie.objectsAreEqual(this.comment, other.comment) && Cookie.objectsAreEqual(this.commentURL, other.commentURL) && Cookie.objectsAreEqual(this.discard, other.discard) && Cookie.objectsAreEqual(this.domain, other.domain) && Cookie.objectsAreEqual(this.expires, other.expires) && Cookie.objectsAreEqual(this.httpOnly, other.httpOnly) && Cookie.objectsAreEqual(this.maxAge, other.maxAge) && Cookie.objectsAreEqual(this.name, other.name) && Cookie.objectsAreEqual(this.path, other.path) && Cookie.objectsAreEqual(this.port, other.port) && Cookie.objectsAreEqual(this.secure, other.secure) && Cookie.objectsAreEqual(this.value, other.value) && Cookie.objectsAreEqual(this.version, other.version);
    }

    public String getComment() {
        return this.comment;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public Boolean getDiscard() {
        return this.discard;
    }

    public String getDomain() {
        return this.domain;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Boolean isHttpOnly() {
        return this.httpOnly == null ? false : this.httpOnly;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<Integer> getPort() {
        return this.port;
    }

    public Boolean isSecure() {
        return this.secure == null ? false : this.secure;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.commentURL == null ? 0 : this.commentURL.hashCode());
        result = 31 * result + (this.discard == null ? 0 : this.discard.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.expires == null ? 0 : this.expires.hashCode());
        result = 31 * result + (this.httpOnly == null ? 0 : this.httpOnly.hashCode());
        result = 31 * result + (this.maxAge == null ? 0 : this.maxAge.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.secure == null ? 0 : this.secure.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public Cookie setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Cookie setCommentURL(String commentURL) {
        this.commentURL = commentURL;
        return this;
    }

    public Cookie setDiscard(Boolean discard) {
        this.discard = discard;
        return this;
    }

    public Cookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Cookie setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    public Cookie setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public Cookie setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public Cookie setName(String name) {
        this.name = name;
        return this;
    }

    public Cookie setPath(String path) {
        this.path = path;
        return this;
    }

    public Cookie setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public Cookie setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.name != null) {
            builder.append("name=").append(this.name).append(" ");
        }
        if (this.value != null) {
            builder.append("value=").append(this.value).append(" ");
        }
        if (this.comment != null) {
            builder.append("comment=").append(this.comment).append(" ");
        }
        if (this.commentURL != null) {
            builder.append("commentURL=").append(this.commentURL).append(" ");
        }
        if (this.discard != null) {
            builder.append("discard=").append(this.discard).append(" ");
        }
        if (this.domain != null) {
            builder.append("domain=").append(this.domain).append(" ");
        }
        if (this.expires != null) {
            builder.append("expires=").append(this.expires).append(" ");
        }
        if (this.httpOnly != null) {
            builder.append("httpOnly=").append(this.httpOnly).append(" ");
        }
        if (this.maxAge != null) {
            builder.append("maxAge=").append(this.maxAge).append(" ");
        }
        if (this.path != null) {
            builder.append("path=").append(this.path).append(" ");
        }
        if (this.port != null) {
            builder.append("port=").append(this.port).append(" ");
        }
        if (this.secure != null) {
            builder.append("secure=").append(this.secure).append(" ");
        }
        if (this.version != null) {
            builder.append("version=").append(this.version);
        }
        builder.append("]");
        return builder.toString();
    }

    private static boolean objectsAreEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

