/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.io.BranchingStreamWrapper;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.ByteArrayBranchingStream;
import org.forgerock.http.io.FileBuffer;
import org.forgerock.http.io.MemoryBuffer;
import org.forgerock.http.io.TemporaryBuffer;
import org.forgerock.util.Factory;

public final class IO {
    public static final int DEFAULT_TMP_INIT_LENGTH = 8192;
    public static final int DEFAULT_TMP_MEMORY_LIMIT = 65536;
    public static final int DEFAULT_TMP_FILE_LIMIT = 0x40000000;
    private static final int BUF_SIZE = 8192;
    private static final InputStream NULL_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };

    public static BranchingInputStream newBranchingInputStream(byte[] bytes) {
        return new ByteArrayBranchingStream(bytes);
    }

    public static BranchingInputStream newBranchingInputStream(InputStream in, Factory<Buffer> bufferFactory) {
        return new BranchingStreamWrapper(in, bufferFactory);
    }

    public static Buffer newFileBuffer(File file, int limit) throws FileNotFoundException {
        return new FileBuffer(file, limit);
    }

    public static Buffer newMemoryBuffer(int initial, int limit) {
        return new MemoryBuffer(initial, limit);
    }

    public static Buffer newTemporaryBuffer(int initialLength, int memoryLimit, int fileLimit, File directory) {
        return new TemporaryBuffer(initialLength, memoryLimit, fileLimit, directory);
    }

    public static Factory<Buffer> newTemporaryStorage() {
        return IO.newTemporaryStorage(null);
    }

    public static Factory<Buffer> newTemporaryStorage(File directory) {
        return IO.newTemporaryStorage(directory, 8192, 65536, 0x40000000);
    }

    public static Factory<Buffer> newTemporaryStorage(final File directory, final int initialLength, final int memoryLimit, final int fileLimit) {
        return new Factory<Buffer>(){

            public Buffer newInstance() {
                return IO.newTemporaryBuffer(initialLength, memoryLimit, fileLimit, directory);
            }
        };
    }

    public static InputStream nullInputStream() {
        return NULL_INPUT_STREAM;
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public static void stream(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = in.read(buf, 0, 8192)) != -1) {
            out.write(buf, 0, n);
        }
    }

    public static int stream(InputStream in, OutputStream out, int len) throws IOException {
        int remaining;
        int n;
        byte[] buf = new byte[8192];
        for (remaining = len; remaining > 0 && (n = in.read(buf, 0, Math.min(remaining, 8192))) >= 0; remaining -= n) {
            out.write(buf, 0, n);
        }
        return len - remaining;
    }

    public static void stream(Reader in, Writer out) throws IOException {
        int n;
        char[] buf = new char[8192];
        while ((n = in.read(buf, 0, 8192)) != -1) {
            out.write(buf, 0, n);
        }
    }

    private IO() {
    }
}

