/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.List;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.util.Reject;

public final class WarningHeader
extends Header {
    public static final String NAME = "Warning";
    public static final int NOT_PRESENT = 100;
    public static final int RESPONSE_STALE = 110;
    public static final int REVALIDATION_FAILED = 111;
    public static final int DISCONNECTED_OPERATION = 112;
    public static final int HEURISTIC_EXPIRATION = 113;
    public static final int MISCELLANEOUS_WARNING = 199;
    public static final int TRANFORMATION_APPLIED = 214;
    public static final int MISCELLANEOUS_PERSISTENT_WARNING = 299;
    private final List<Warning> warnings = new ArrayList<Warning>();

    public static WarningHeader valueOf(Message message) {
        return new WarningHeader(WarningHeader.toWarnings(HeaderUtil.parseMultiValuedHeader(message, NAME)));
    }

    public static WarningHeader valueOf(String string) {
        return new WarningHeader(WarningHeader.toWarnings(HeaderUtil.parseMultiValuedHeader(string)));
    }

    private static List<Warning> toWarnings(List<String> header) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        for (String entry : header) {
            String[] parts = entry.split(" ");
            if (parts.length < 3) continue;
            warnings.add(new Warning(Integer.parseInt(parts[0]), parts[1], parts[2]));
        }
        return warnings;
    }

    public static WarningHeader newWarning(String agentName, String fmt, Object ... args) {
        return new WarningHeader(100, agentName, String.format(fmt, args));
    }

    private WarningHeader(List<Warning> warnings) {
        this.warnings.addAll(warnings);
    }

    public WarningHeader(int code, String agent, String text) {
        Reject.ifNull((Object)agent, (String)text);
        this.warnings.add(new Warning(code, agent, text));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public WarningHeader add(int code, String agent, String text) {
        WarningHeader header = new WarningHeader(this.warnings);
        header.warnings.add(new Warning(code, agent, text));
        return header;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> headerValues = new ArrayList<String>();
        for (Warning warning : this.warnings) {
            headerValues.add(warning.toString().trim());
        }
        return headerValues;
    }

    static class Factory
    extends HeaderFactory<WarningHeader> {
        Factory() {
        }

        @Override
        public WarningHeader parse(String value) {
            return WarningHeader.valueOf(value);
        }

        @Override
        public WarningHeader parse(List<String> values) {
            return new WarningHeader(WarningHeader.toWarnings(values));
        }
    }

    private static final class Warning {
        private final int code;
        private final String agent;
        private final String text;

        private Warning(int code, String agent, String text) {
            this.code = code;
            this.agent = agent;
            this.text = text;
        }

        public String toString() {
            return String.valueOf(this.code) + " " + this.agent + " " + this.text;
        }
    }
}

