/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;

public class ContentTypeHeader
extends Header {
    public static final String NAME = "Content-Type";
    private final String type;
    private final String charset;
    private final String boundary;

    public static ContentTypeHeader valueOf(Message message) {
        return ContentTypeHeader.valueOf(HeaderUtil.parseSingleValuedHeader(message, NAME));
    }

    public static ContentTypeHeader valueOf(String string) {
        List<String> parts = HeaderUtil.split(string, ';');
        if (parts.size() > 0) {
            String type = parts.get(0);
            Map<String, String> parameters = HeaderUtil.parseParameters(parts);
            String charset = parameters.get("charset");
            String boundary = parameters.get("boundary");
            return new ContentTypeHeader(type, charset, boundary);
        }
        return new ContentTypeHeader(null, null, null);
    }

    public ContentTypeHeader() {
        this(null, null, null);
    }

    public ContentTypeHeader(String type, String charset, String boundary) {
        this.type = type;
        this.charset = charset;
        this.boundary = boundary;
    }

    public String getType() {
        return this.type;
    }

    public Charset getCharset() {
        return this.charset != null ? Charset.forName(this.charset) : null;
    }

    public String getBoundary() {
        return this.boundary;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        if (this.type == null || this.type.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        if (this.charset != null) {
            sb.append("; charset=").append(this.charset);
        }
        if (this.boundary != null) {
            sb.append("; boundary=").append(this.boundary);
        }
        return sb.length() > 0 ? Collections.singletonList(sb.toString()) : Collections.emptyList();
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<ContentTypeHeader> {
        Factory() {
        }

        @Override
        public ContentTypeHeader parse(String value) {
            return ContentTypeHeader.valueOf(value);
        }
    }
}

