/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.routing.Version;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;

public final class ContentApiVersionHeader
extends Header {
    public static final String NAME = "Content-API-Version";
    private static final String PROTOCOL = "protocol";
    private static final String RESOURCE = "resource";
    private final Version protocolVersion;
    private final Version resourceVersion;

    public static ContentApiVersionHeader valueOf(Message message) {
        String headerValue = HeaderUtil.parseSingleValuedHeader(message, NAME);
        return ContentApiVersionHeader.valueOf(headerValue);
    }

    public static ContentApiVersionHeader valueOf(String headerValue) {
        Pair<Version, Version> parsedValue = AcceptApiVersionHeader.parse(headerValue);
        return new ContentApiVersionHeader((Version)parsedValue.getFirst(), (Version)parsedValue.getSecond());
    }

    public ContentApiVersionHeader(Version protocolVersion, Version resourceVersion) {
        Reject.ifNull((Object)resourceVersion);
        this.protocolVersion = protocolVersion;
        this.resourceVersion = resourceVersion;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Version getProtocolVersion() {
        return this.protocolVersion;
    }

    public Version getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public List<String> getValues() {
        if (this.protocolVersion == null) {
            return Collections.singletonList(String.format("resource=%s", this.resourceVersion));
        }
        return Collections.singletonList(String.format("protocol=%s,resource=%s", this.protocolVersion, this.resourceVersion));
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<ContentApiVersionHeader> {
        Factory() {
        }

        @Override
        public ContentApiVersionHeader parse(String value) {
            return ContentApiVersionHeader.valueOf(value);
        }
    }
}

