/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import java.util.Arrays;
import java.util.List;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.filter.OptionsFilter;
import org.forgerock.http.filter.SessionFilter;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.session.SessionManager;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

public final class Filters {
    private Filters() {
    }

    public static Filter newOptionsFilter(String ... allowedMethods) {
        return new OptionsFilter(allowedMethods);
    }

    public static Filter newSessionFilter(SessionManager sessionManager) {
        return new SessionFilter(sessionManager);
    }

    public static Filter chainOf(Filter ... filters) {
        return Filters.chainOf(Arrays.asList(filters));
    }

    public static Filter chainOf(final List<Filter> filters) {
        return new Filter(){

            @Override
            public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
                return Handlers.chainOf(next, filters).handle(context, request);
            }
        };
    }
}

