/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.rest2ldap.AbstractLDAPAttributeMapper;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.RequestState;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class SimpleAttributeMapper
extends AbstractLDAPAttributeMapper<SimpleAttributeMapper> {
    private Function<ByteString, ?, NeverThrowsException> decoder;
    private Function<Object, ByteString, NeverThrowsException> encoder;

    SimpleAttributeMapper(AttributeDescription ldapAttributeName) {
        super(ldapAttributeName);
    }

    public SimpleAttributeMapper decoder(Function<ByteString, ?, NeverThrowsException> f) {
        this.decoder = f;
        return this;
    }

    public SimpleAttributeMapper defaultJSONValue(Object defaultValue) {
        this.defaultJSONValues = defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList();
        return this;
    }

    public SimpleAttributeMapper encoder(Function<Object, ByteString, NeverThrowsException> f) {
        this.encoder = f;
        return this;
    }

    public SimpleAttributeMapper isBinary() {
        this.decoder = Utils.byteStringToBase64();
        this.encoder = Utils.base64ToByteString();
        return this;
    }

    public String toString() {
        return "simple(" + this.ldapAttributeName + ")";
    }

    @Override
    Promise<Filter, ResourceException> getLDAPFilter(RequestState requestState, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        if (subPath.isEmpty()) {
            try {
                ByteString va = valueAssertion != null ? (ByteString)this.encoder().apply(valueAssertion) : null;
                return Promises.newResultPromise((Object)Utils.toFilter(type, this.ldapAttributeName.toString(), va));
            }
            catch (Exception e) {
                return Promises.newExceptionPromise((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because it contained an illegal filter assertion value '%s' for field '%s'", String.valueOf(valueAssertion), path), (Throwable)e));
            }
        }
        return Promises.newResultPromise((Object)Filter.alwaysFalse());
    }

    @Override
    Promise<Attribute, ResourceException> getNewLDAPAttributes(RequestState requestState, JsonPointer path, List<Object> newValues) {
        try {
            return Promises.newResultPromise((Object)Utils.jsonToAttribute(newValues, this.ldapAttributeName, this.encoder()));
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because an error occurred while encoding the values for the field '%s': %s", path, ex.getMessage())));
        }
    }

    @Override
    SimpleAttributeMapper getThis() {
        return this;
    }

    @Override
    Promise<JsonValue, ResourceException> read(RequestState requestState, JsonPointer path, Entry e) {
        try {
            Set s;
            Object value = this.attributeIsSingleValued() ? e.parseAttribute(this.ldapAttributeName).as(this.decoder(), this.defaultJSONValues.isEmpty() ? null : this.defaultJSONValues.get(0)) : ((s = e.parseAttribute(this.ldapAttributeName).asSetOf(this.decoder(), (Collection)this.defaultJSONValues)).isEmpty() ? null : new ArrayList(s));
            return Promises.newResultPromise((Object)(value != null ? new JsonValue(value) : null));
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(ex)));
        }
    }

    private Function<ByteString, ?, NeverThrowsException> decoder() {
        return this.decoder == null ? Utils.byteStringToJson(this.ldapAttributeName) : this.decoder;
    }

    private Function<Object, ByteString, NeverThrowsException> encoder() {
        return this.encoder == null ? Utils.jsonToByteString(this.ldapAttributeName) : this.encoder;
    }
}

