/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class HttpAuthenticationFilter
implements Filter,
Closeable {
    private final Schema schema = Schema.getDefaultSchema();
    private final String altAuthenticationPasswordHeader;
    private final String altAuthenticationUsernameHeader;
    private final AuthenticationMethod authenticationMethod;
    private final ConnectionFactory bindLDAPConnectionFactory;
    private final boolean reuseAuthenticatedConnection;
    private final String saslAuthzIdTemplate;
    private final DN searchBaseDN;
    private final String searchFilterTemplate;
    private final ConnectionFactory searchLDAPConnectionFactory;
    private final SearchScope searchScope;
    private final boolean supportAltAuthentication;
    private final boolean supportHTTPBasicAuthentication;

    HttpAuthenticationFilter(JsonValue configuration) {
        String ldapFactoryName;
        JsonValue authnConfig = configuration.get("authenticationFilter");
        this.supportHTTPBasicAuthentication = authnConfig.get("supportHTTPBasicAuthentication").required().asBoolean();
        this.supportAltAuthentication = authnConfig.get("supportAltAuthentication").required().asBoolean();
        if (this.supportAltAuthentication) {
            this.altAuthenticationUsernameHeader = authnConfig.get("altAuthenticationUsernameHeader").required().asString();
            this.altAuthenticationPasswordHeader = authnConfig.get("altAuthenticationPasswordHeader").required().asString();
        } else {
            this.altAuthenticationUsernameHeader = null;
            this.altAuthenticationPasswordHeader = null;
        }
        this.reuseAuthenticatedConnection = authnConfig.get("reuseAuthenticatedConnection").required().asBoolean();
        this.authenticationMethod = HttpAuthenticationFilter.parseAuthenticationMethod(authnConfig);
        switch (this.authenticationMethod) {
            case SASL_PLAIN: {
                this.saslAuthzIdTemplate = authnConfig.get("saslAuthzIdTemplate").required().asString();
                this.searchBaseDN = null;
                this.searchScope = null;
                this.searchFilterTemplate = null;
                this.searchLDAPConnectionFactory = null;
                break;
            }
            case SEARCH_SIMPLE: {
                this.searchBaseDN = DN.valueOf((String)authnConfig.get("searchBaseDN").required().asString(), (Schema)this.schema);
                this.searchScope = HttpAuthenticationFilter.parseSearchScope(authnConfig);
                this.searchFilterTemplate = authnConfig.get("searchFilterTemplate").required().asString();
                ldapFactoryName = authnConfig.get("searchLDAPConnectionFactory").required().asString();
                this.searchLDAPConnectionFactory = Rest2LDAP.configureConnectionFactory(configuration.get("ldapConnectionFactories").required(), ldapFactoryName);
                this.saslAuthzIdTemplate = null;
                break;
            }
            default: {
                this.saslAuthzIdTemplate = null;
                this.searchBaseDN = null;
                this.searchScope = null;
                this.searchFilterTemplate = null;
                this.searchLDAPConnectionFactory = null;
            }
        }
        ldapFactoryName = authnConfig.get("bindLDAPConnectionFactory").required().asString();
        this.bindLDAPConnectionFactory = Rest2LDAP.configureConnectionFactory(configuration.get("ldapConnectionFactories").required(), ldapFactoryName);
    }

    private static AuthenticationMethod parseAuthenticationMethod(JsonValue configuration) {
        if (configuration.isDefined("method")) {
            String method = configuration.get("method").asString();
            if ("simple".equalsIgnoreCase(method)) {
                return AuthenticationMethod.SIMPLE;
            }
            if ("sasl-plain".equalsIgnoreCase(method)) {
                return AuthenticationMethod.SASL_PLAIN;
            }
            if ("search-simple".equalsIgnoreCase(method)) {
                return AuthenticationMethod.SEARCH_SIMPLE;
            }
            throw new JsonValueException(configuration, "Illegal authentication method: must be either 'simple', 'sasl-plain', or 'search-simple'");
        }
        return AuthenticationMethod.SEARCH_SIMPLE;
    }

    private static SearchScope parseSearchScope(JsonValue configuration) {
        if (configuration.isDefined("searchScope")) {
            String scope = configuration.get("searchScope").asString();
            if ("sub".equalsIgnoreCase(scope)) {
                return SearchScope.WHOLE_SUBTREE;
            }
            if ("one".equalsIgnoreCase(scope)) {
                return SearchScope.SINGLE_LEVEL;
            }
            throw new JsonValueException(configuration, "Illegal search scope: must be either 'sub' or 'one'");
        }
        return SearchScope.WHOLE_SUBTREE;
    }

    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
        try {
            char[] password;
            String username;
            String headerAuthorization;
            String headerUsername = this.supportAltAuthentication ? request.getHeaders().getFirst(this.altAuthenticationUsernameHeader) : null;
            String headerPassword = this.supportAltAuthentication ? request.getHeaders().getFirst(this.altAuthenticationPasswordHeader) : null;
            String string = headerAuthorization = this.supportHTTPBasicAuthentication ? request.getHeaders().getFirst("Authorization") : null;
            if (headerUsername != null) {
                if (headerPassword == null || headerUsername.isEmpty() || headerPassword.isEmpty()) {
                    throw ResourceException.newResourceException((int)401);
                }
                username = headerUsername;
                password = headerPassword.toCharArray();
            } else if (headerAuthorization != null) {
                StringTokenizer st = new StringTokenizer(headerAuthorization);
                String method = st.nextToken();
                if (method == null || !"BASIC".equalsIgnoreCase(method)) {
                    throw ResourceException.newResourceException((int)401);
                }
                String b64Credentials = st.nextToken();
                if (b64Credentials == null) {
                    throw ResourceException.newResourceException((int)401);
                }
                String credentials = ByteString.valueOfBase64((String)b64Credentials).toString();
                String[] usernameAndPassword = credentials.split(":");
                if (usernameAndPassword.length != 2) {
                    throw ResourceException.newResourceException((int)401);
                }
                username = usernameAndPassword[0];
                password = usernameAndPassword[1].toCharArray();
            } else {
                throw ResourceException.newResourceException((int)401);
            }
            switch (this.authenticationMethod) {
                case SIMPLE: {
                    Map<Object, Object> authzid = new LinkedHashMap<String, String>(2);
                    authzid.put("dn", username);
                    authzid.put("id", username);
                    return this.doBind(context, request, next, (BindRequest)Requests.newSimpleBindRequest((String)username, (char[])password), username, authzid);
                }
                case SASL_PLAIN: {
                    String bindId;
                    Map<Object, Object> authzid;
                    if (this.saslAuthzIdTemplate.startsWith("dn:")) {
                        String bindDN = DN.format((String)this.saslAuthzIdTemplate.substring(3), (Schema)this.schema, (Object[])new Object[]{username}).toString();
                        bindId = "dn:" + bindDN;
                        authzid = new LinkedHashMap(2);
                        authzid.put("dn", bindDN);
                        authzid.put("id", username);
                    } else {
                        bindId = String.format(this.saslAuthzIdTemplate, username);
                        authzid = Collections.singletonMap("id", username);
                    }
                    return this.doBind(context, request, next, (BindRequest)Requests.newPlainSASLBindRequest((String)bindId, (char[])password), username, authzid);
                }
            }
            AtomicReference<Connection> savedConnection = new AtomicReference<Connection>();
            return this.searchLDAPConnectionFactory.getConnectionAsync().thenAsync(this.doSearchForUser(username, savedConnection)).thenAsync(this.doBindAfterSearch(context, request, next, username, password, savedConnection), this.returnErrorAfterFailedSearch(savedConnection));
        }
        catch (Throwable t) {
            return this.asErrorResponse(t);
        }
    }

    private AsyncFunction<Connection, SearchResultEntry, LdapException> doSearchForUser(final String username, final AtomicReference<Connection> savedConnection) {
        return new AsyncFunction<Connection, SearchResultEntry, LdapException>(){

            public Promise<SearchResultEntry, LdapException> apply(Connection connection) throws LdapException {
                savedConnection.set(connection);
                org.forgerock.opendj.ldap.Filter filter = org.forgerock.opendj.ldap.Filter.format((String)HttpAuthenticationFilter.this.searchFilterTemplate, (Object[])new Object[]{username});
                return connection.searchSingleEntryAsync(Requests.newSearchRequest((DN)HttpAuthenticationFilter.this.searchBaseDN, (SearchScope)HttpAuthenticationFilter.this.searchScope, (org.forgerock.opendj.ldap.Filter)filter, (String[])new String[]{"1.1"}));
            }
        };
    }

    private AsyncFunction<SearchResultEntry, Response, NeverThrowsException> doBindAfterSearch(final Context context, final Request request, final Handler next, final String username, final char[] password, final AtomicReference<Connection> savedConnection) {
        return new AsyncFunction<SearchResultEntry, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(SearchResultEntry entry) {
                HttpAuthenticationFilter.this.closeConnection(savedConnection);
                String bindDN = entry.getName().toString();
                LinkedHashMap<String, String> authzid = new LinkedHashMap<String, String>(2);
                authzid.put("dn", bindDN);
                authzid.put("id", username);
                return HttpAuthenticationFilter.this.doBind(context, request, next, (BindRequest)Requests.newSimpleBindRequest((String)bindDN, (char[])password), username, authzid);
            }
        };
    }

    private Promise<Response, NeverThrowsException> doBind(Context context, Request request, Handler next, final BindRequest bindRequest, String authcid, Map<String, Object> authzid) {
        final AtomicReference<Connection> savedConnection = new AtomicReference<Connection>();
        return this.bindLDAPConnectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, BindResult, LdapException>(){

            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                savedConnection.set(connection);
                return connection.bindAsync(bindRequest);
            }
        }).thenAsync(this.doChain(context, request, next, authcid, authzid, savedConnection), this.returnErrorAfterFailedBind()).thenFinally(new Runnable(){

            @Override
            public void run() {
                HttpAuthenticationFilter.this.closeConnection(savedConnection);
            }
        });
    }

    private AsyncFunction<BindResult, Response, NeverThrowsException> doChain(final Context context, final Request request, final Handler next, final String authcid, final Map<String, Object> authzid, final AtomicReference<Connection> savedConnection) {
        return new AsyncFunction<BindResult, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(BindResult result) {
                Object forwardedContext = new SecurityContext(context, authcid, authzid);
                if (HttpAuthenticationFilter.this.reuseAuthenticatedConnection) {
                    forwardedContext = new AuthenticatedConnectionContext((Context)forwardedContext, Connections.uncloseable((Connection)((Connection)savedConnection.get())));
                }
                return next.handle((Context)forwardedContext, request);
            }
        };
    }

    private AsyncFunction<LdapException, Response, NeverThrowsException> returnErrorAfterFailedSearch(final AtomicReference<Connection> savedConnection) {
        return new AsyncFunction<LdapException, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(LdapException e) {
                if (HttpAuthenticationFilter.this.closeConnection(savedConnection)) {
                    if (e instanceof EntryNotFoundException || e instanceof MultipleEntriesFoundException) {
                        return HttpAuthenticationFilter.this.asErrorResponse((Throwable)LdapException.newLdapException((ResultCode)ResultCode.INVALID_CREDENTIALS, (Throwable)e));
                    }
                    if (e instanceof AuthenticationException || e instanceof AuthorizationException) {
                        return HttpAuthenticationFilter.this.asErrorResponse((Throwable)LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_LOCAL_ERROR, (Throwable)e));
                    }
                    return HttpAuthenticationFilter.this.asErrorResponse((Throwable)e);
                }
                return HttpAuthenticationFilter.this.asErrorResponse((Throwable)e);
            }
        };
    }

    private AsyncFunction<LdapException, Response, NeverThrowsException> returnErrorAfterFailedBind() {
        return new AsyncFunction<LdapException, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(LdapException e) {
                return HttpAuthenticationFilter.this.asErrorResponse((Throwable)e);
            }
        };
    }

    private Promise<Response, NeverThrowsException> asErrorResponse(Throwable t) {
        ResourceException e = Rest2LDAP.asResourceException(t);
        Response response = new Response().setStatus(Status.valueOf((int)e.getCode())).setEntity(e.toJsonValue().getObject());
        return Promises.newResultPromise((Object)response);
    }

    private boolean closeConnection(AtomicReference<Connection> savedConnection) {
        Connection connection = savedConnection.get();
        if (connection != null) {
            connection.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        Utils.closeSilently((Closeable[])new Closeable[]{this.searchLDAPConnectionFactory, this.bindLDAPConnectionFactory});
    }

    private static enum AuthenticationMethod {
        SASL_PLAIN,
        SEARCH_SIMPLE,
        SIMPLE;

    }
}

