/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ReturnCode;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;

public class ClientException
extends Exception
implements LocalizableException {
    private static final long serialVersionUID = 1384120263337669664L;
    private ReturnCode returnCode;
    private final LocalizableMessage message;

    public static ClientException adaptInputException(Throwable cause) {
        return new ClientException(ReturnCode.ERROR_USER_DATA, CliMessages.ERR_CONSOLE_INPUT_ERROR.get((Object)cause.getMessage()), cause);
    }

    public ClientException(ReturnCode exitCode, LocalizableMessage message) {
        super(message.toString());
        this.returnCode = exitCode;
        this.message = message;
    }

    public ClientException(ReturnCode exitCode, LocalizableMessage message, Throwable cause) {
        super(message.toString(), cause);
        this.returnCode = exitCode;
        this.message = message;
    }

    public int getReturnCode() {
        return this.returnCode.get();
    }

    public LocalizableMessage getMessageObject() {
        return this.message;
    }
}

