/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.forgerock.http.util.Paths;

public final class ResourcePath
implements Comparable<ResourcePath>,
Iterable<String> {
    private static final ResourcePath EMPTY = new ResourcePath();
    private static final Pattern PATH_SPLITTER = Pattern.compile("/");
    private final String path;
    private final String normalizedPath;
    private final int size;

    public static ResourcePath empty() {
        return EMPTY;
    }

    public static ResourcePath format(String template, Object ... pathElements) {
        String[] encodedPathElements = new String[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            encodedPathElements[i] = Paths.urlEncode((Object)pathElements[i]);
        }
        return ResourcePath.resourcePath(String.format(template, encodedPathElements));
    }

    public static ResourcePath resourcePath(String path) {
        return ResourcePath.valueOf(path);
    }

    public static ResourcePath valueOf(String path) {
        int endIndex;
        if (path.isEmpty()) {
            return EMPTY;
        }
        String[] elements = PATH_SPLITTER.split(path, -1);
        int sz = elements.length;
        int startIndex = elements[0].isEmpty() ? 1 : 0;
        int n = endIndex = sz > 1 && elements[sz - 1].isEmpty() ? sz - 1 : sz;
        if (startIndex == endIndex) {
            return EMPTY;
        }
        StringBuilder trimmedPath = new StringBuilder(path.length());
        StringBuilder normalizedPath = new StringBuilder(path.length());
        for (int i = startIndex; i < endIndex; ++i) {
            String element = elements[i];
            if (element.isEmpty()) {
                throw new IllegalArgumentException("Resource path '" + path + "' contains empty path elements");
            }
            String normalizedElement = ResourcePath.normalizePathElement(element, true);
            if (i != startIndex) {
                trimmedPath.append('/');
                normalizedPath.append('/');
            }
            trimmedPath.append(element);
            normalizedPath.append(normalizedElement);
        }
        return new ResourcePath(trimmedPath.toString(), normalizedPath.toString(), endIndex - startIndex);
    }

    private static String normalizePathElement(String element, boolean needsDecoding) {
        if (needsDecoding) {
            return Paths.urlEncode((Object)Paths.urlDecode((Object)element).toLowerCase(Locale.ENGLISH));
        }
        return element.toLowerCase(Locale.ENGLISH);
    }

    public ResourcePath() {
        this.normalizedPath = "";
        this.path = "";
        this.size = 0;
    }

    public ResourcePath(Collection<? extends Object> pathElements) {
        int i = 0;
        StringBuilder pathBuilder = new StringBuilder();
        StringBuilder normalizedPathBuilder = new StringBuilder();
        for (Object object : pathElements) {
            String s = object.toString();
            if (i > 0) {
                pathBuilder.append('/');
                normalizedPathBuilder.append('/');
            }
            String encodedPathElement = Paths.urlEncode((Object)s);
            pathBuilder.append(encodedPathElement);
            String normalizedPathElement = ResourcePath.normalizePathElement(s, false);
            normalizedPathBuilder.append(Paths.urlEncode((Object)normalizedPathElement));
            ++i;
        }
        this.path = pathBuilder.toString();
        this.normalizedPath = normalizedPathBuilder.toString();
        this.size = pathElements.size();
    }

    public ResourcePath(Object ... pathElements) {
        this(Arrays.asList(pathElements));
    }

    private ResourcePath(String path, String normalizedPath, int size) {
        this.path = path;
        this.normalizedPath = normalizedPath;
        this.size = size;
    }

    public ResourcePath child(Object pathElement) {
        String s = pathElement.toString();
        String encodedPathElement = Paths.urlEncode((Object)s);
        String normalizedPathElement = ResourcePath.normalizePathElement(s, false);
        String normalizedEncodedPathElement = Paths.urlEncode((Object)normalizedPathElement);
        if (this.isEmpty()) {
            return new ResourcePath(encodedPathElement, normalizedEncodedPathElement, 1);
        }
        String newPath = this.path + "/" + encodedPathElement;
        String newNormalizedPath = this.normalizedPath + "/" + normalizedEncodedPathElement;
        return new ResourcePath(newPath, newNormalizedPath, this.size + 1);
    }

    @Override
    public int compareTo(ResourcePath o) {
        return this.normalizedPath.compareTo(o.normalizedPath);
    }

    public ResourcePath concat(ResourcePath suffix) {
        if (this.isEmpty()) {
            return suffix;
        }
        if (suffix.isEmpty()) {
            return this;
        }
        String newPath = this.path + "/" + suffix.path;
        String newNormalizedPath = this.normalizedPath + "/" + suffix.normalizedPath;
        return new ResourcePath(newPath, newNormalizedPath, this.size + suffix.size);
    }

    public ResourcePath concat(String suffix) {
        return this.concat(ResourcePath.resourcePath(suffix));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResourcePath) {
            return this.normalizedPath.equals(((ResourcePath)obj).normalizedPath);
        }
        return false;
    }

    public String get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int startIndex = 0;
        int endIndex = this.nextElementEndIndex(this.path, 0);
        for (int i = 0; i < index; ++i) {
            startIndex = endIndex + 1;
            endIndex = this.nextElementEndIndex(this.path, startIndex);
        }
        return Paths.urlDecode((Object)this.path.substring(startIndex, endIndex));
    }

    public int hashCode() {
        return this.normalizedPath.hashCode();
    }

    public ResourcePath head(int endIndex) {
        return this.subSequence(0, endIndex);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int startIndex = 0;
            private int endIndex = ResourcePath.access$100(ResourcePath.this, ResourcePath.access$000(ResourcePath.this), 0);

            @Override
            public boolean hasNext() {
                return this.startIndex < ResourcePath.this.path.length();
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String element = ResourcePath.this.path.substring(this.startIndex, this.endIndex);
                this.startIndex = this.endIndex + 1;
                this.endIndex = ResourcePath.this.nextElementEndIndex(ResourcePath.this.path, this.startIndex);
                return Paths.urlDecode((Object)element);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String leaf() {
        return this.get(this.size() - 1);
    }

    public ResourcePath parent() {
        switch (this.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return EMPTY;
            }
        }
        String newPath = this.path.substring(0, this.path.lastIndexOf(47));
        String newNormalizedPath = this.normalizedPath.substring(0, this.normalizedPath.lastIndexOf(47));
        return new ResourcePath(newPath, newNormalizedPath, this.size - 1);
    }

    public int size() {
        return this.size;
    }

    public boolean startsWith(ResourcePath prefix) {
        if (this.size == prefix.size) {
            return this.equals(prefix);
        }
        if (this.size < prefix.size) {
            return false;
        }
        if (prefix.size == 0) {
            return true;
        }
        return this.normalizedPath.startsWith(prefix.normalizedPath) && this.normalizedPath.charAt(prefix.normalizedPath.length()) == '/';
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(ResourcePath.resourcePath(prefix));
    }

    public ResourcePath subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.size || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (beginIndex == 0 && endIndex == this.size) {
            return this;
        }
        if (endIndex - beginIndex == 0) {
            return EMPTY;
        }
        String subPath = this.subPath(this.path, beginIndex, endIndex);
        String subNormalizedPath = this.subPath(this.normalizedPath, beginIndex, endIndex);
        return new ResourcePath(subPath, subNormalizedPath, endIndex - beginIndex);
    }

    public ResourcePath tail(int beginIndex) {
        return this.subSequence(beginIndex, this.size);
    }

    public String toString() {
        return this.path;
    }

    private int nextElementEndIndex(String s, int startIndex) {
        int index = s.indexOf(47, startIndex);
        return index < 0 ? s.length() : index;
    }

    private String subPath(String s, int beginIndex, int endIndex) {
        int startCharIndex = 0;
        int endCharIndex = this.nextElementEndIndex(s, 0);
        for (int i = 0; i < beginIndex; ++i) {
            startCharIndex = endCharIndex + 1;
            endCharIndex = this.nextElementEndIndex(s, startCharIndex);
        }
        for (int i = beginIndex + 1; i < endIndex; ++i) {
            int tmpStartCharIndex = endCharIndex + 1;
            endCharIndex = this.nextElementEndIndex(s, tmpStartCharIndex);
        }
        return s.substring(startCharIndex, endCharIndex);
    }
}

