/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.json.resource.AbstractAsynchronousConnection;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;

final class InternalConnection
extends AbstractAsynchronousConnection {
    private final RequestHandler requestHandler;

    InternalConnection(RequestHandler handler) {
        this.requestHandler = handler;
    }

    @Override
    public Promise<ActionResponse, ResourceException> actionAsync(Context context, ActionRequest request) {
        return this.requestHandler.handleAction(context, request);
    }

    @Override
    public void close() {
    }

    @Override
    public Promise<ResourceResponse, ResourceException> createAsync(Context context, CreateRequest request) {
        return this.requestHandler.handleCreate(context, request).then(this.filterResponse(request));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> deleteAsync(Context context, DeleteRequest request) {
        return this.requestHandler.handleDelete(context, request).then(this.filterResponse(request));
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Promise<ResourceResponse, ResourceException> patchAsync(Context context, PatchRequest request) {
        return this.requestHandler.handlePatch(context, request).then(this.filterResponse(request));
    }

    @Override
    public Promise<QueryResponse, ResourceException> queryAsync(Context context, final QueryRequest request, final QueryResourceHandler handler) {
        return this.requestHandler.handleQuery(context, request, new QueryResourceHandler(){

            @Override
            public boolean handleResource(ResourceResponse resource) {
                return handler.handleResource(Resources.filterResource(resource, request.getFields()));
            }
        });
    }

    @Override
    public Promise<ResourceResponse, ResourceException> readAsync(Context context, ReadRequest request) {
        return this.requestHandler.handleRead(context, request).then(this.filterResponse(request));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> updateAsync(Context context, UpdateRequest request) {
        return this.requestHandler.handleUpdate(context, request).then(this.filterResponse(request));
    }

    private Function<ResourceResponse, ResourceResponse, ResourceException> filterResponse(final Request request) {
        return new Function<ResourceResponse, ResourceResponse, ResourceException>(){

            public ResourceResponse apply(ResourceResponse response) throws ResourceException {
                return Resources.filterResource(response, request.getFields());
            }
        };
    }
}

