/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.core;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import org.forgerock.util.Utils;

public final class ProductInformation {
    private static final ProductInformation DEFAULT = new ProductInformation("opendj");
    private final Properties properties;
    private final String versionFull;
    private final String versionPrintable;

    public static ProductInformation getInstance() {
        return DEFAULT;
    }

    private ProductInformation(String productName) {
        String resourceName = "/META-INF/product/" + productName + ".properties";
        InputStream stream = this.getClass().getResourceAsStream(resourceName);
        if (stream == null) {
            throw new MissingResourceException("Can't find product information " + resourceName, productName, "");
        }
        this.properties = new Properties();
        BufferedInputStream is = new BufferedInputStream(stream);
        try {
            this.properties.load(is);
        }
        catch (IOException e) {
            try {
                throw new MissingResourceException("Can't load product information " + resourceName + " due to IO exception: " + e.getMessage(), productName, "");
            }
            catch (Throwable throwable) {
                Utils.closeSilently((Closeable[])new Closeable[]{is});
                throw throwable;
            }
        }
        Utils.closeSilently((Closeable[])new Closeable[]{is});
        this.versionFull = this.productName() + " " + this.version() + (this.patchFixIds().length() > 0 ? "+" + this.patchFixIds() : "");
        this.versionPrintable = this.versionFull + System.getProperty("line.separator") + "Build " + this.buildId() + System.getProperty("line.separator");
    }

    public String buildId() {
        return this.properties.getProperty("build.id");
    }

    public boolean buildIsDebug() {
        return Boolean.valueOf(this.properties.getProperty("build.isdebug"));
    }

    public String buildJavaVendor() {
        return this.properties.getProperty("build.java.vendor");
    }

    public String buildJavaVersion() {
        return this.properties.getProperty("build.java.version");
    }

    public String buildJvmVendor() {
        return this.properties.getProperty("build.jvm.vendor");
    }

    public String buildJvmVersion() {
        return this.properties.getProperty("build.jvm.version");
    }

    public String buildOs() {
        return this.properties.getProperty("build.os");
    }

    public String buildUser() {
        return this.properties.getProperty("build.user");
    }

    public String documentationAdminGuideUrl() {
        return this.properties.getProperty("doc.guide.admin.url");
    }

    public String documentationHomePageUrl() {
        return this.properties.getProperty("doc.homepage.url");
    }

    public String documentationReferenceGuideUrl() {
        return this.properties.getProperty("doc.guide.ref.url");
    }

    public String documentationWikiUrl() {
        return this.properties.getProperty("doc.wiki.url");
    }

    public String patchFixIds() {
        return this.properties.getProperty("patch.fix.ids");
    }

    public String productName() {
        return this.properties.getProperty("product.name");
    }

    public String productPublicationDate() {
        return this.properties.getProperty("product.publication.date");
    }

    public String productReleaseDate() {
        return this.properties.getProperty("product.release.date");
    }

    public String productShortName() {
        return this.properties.getProperty("product.name.short");
    }

    public String scmRevision() {
        return this.properties.getProperty("scm.revision");
    }

    public String scmUrl() {
        return this.properties.getProperty("scm.url");
    }

    public String version() {
        return this.properties.getProperty("version");
    }

    public int versionBuildNumber() {
        return Integer.valueOf(this.properties.getProperty("version.build"));
    }

    public String versionCompact() {
        return this.properties.getProperty("version.compact");
    }

    public String versionFull() {
        return this.versionFull;
    }

    public int versionMajorNumber() {
        return Integer.valueOf(this.properties.getProperty("version.major"));
    }

    public int versionMinorNumber() {
        return Integer.valueOf(this.properties.getProperty("version.minor"));
    }

    public int versionPointNumber() {
        return Integer.valueOf(this.properties.getProperty("version.point"));
    }

    public String versionPrintable() {
        return this.versionPrintable;
    }

    public String versionQualifier() {
        return this.properties.getProperty("version.qualifier");
    }

    public String versionRevision() {
        return this.properties.getProperty("scm.revision");
    }
}

