/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.TreeStatistics;
import com.persistit.util.Util;

public class TreeState {
    private String _name;
    private long _rootPageAddr;
    private int _depth;
    private long _changeCount;
    private final TreeStatistics _treeStatistics = new TreeStatistics();

    public String getName() {
        return this._name;
    }

    public long getRootPageAddr() {
        return this._rootPageAddr;
    }

    public long getChangeCount() {
        return this._changeCount;
    }

    public int getDepth() {
        return this._depth;
    }

    int load(byte[] bytes, int index, int length) {
        int nameLength;
        int n = nameLength = length < 20 ? -1 : Util.getShort(bytes, index + 18);
        if (nameLength < 1 || nameLength + 20 > length) {
            throw new IllegalStateException("Invalid tree record is too short for tree " + this._name + ": " + length);
        }
        this._name = new String(bytes, index + 20, nameLength);
        this._rootPageAddr = Util.getLong(bytes, index);
        this._changeCount = Util.getLong(bytes, index + 8);
        this._depth = Util.getShort(bytes, index + 16);
        int at = index + 20 + nameLength;
        int slen = length - (20 + nameLength);
        if (slen > 8) {
            this._treeStatistics.load(bytes, at, slen);
        }
        return length;
    }

    public TreeStatistics getTreeStatistics() {
        return this._treeStatistics;
    }

    public String toString() {
        return String.format("%s root=%,d depth=%d changes=%,d", this._name, this._rootPageAddr, this._depth, this._changeCount);
    }
}

