/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.CLI;
import com.persistit.CheckpointManager;
import com.persistit.JournalManager;
import com.persistit.Management;
import com.persistit.Task;
import com.persistit.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BackupTask
extends Task {
    private static final int BUFFER_SIZE = 0x100000;
    private static final int PROGRESS_MARK_AT = 100000000;
    private boolean _start;
    private boolean _end;
    private boolean _showFiles;
    private boolean _compressed;
    private boolean _checkpoint;
    private boolean _copyback;
    private String _toFile;
    final List<String> _files = new ArrayList<String>();
    private volatile String _backupStatus;

    @CLI.Cmd(value="backup")
    static Task setupTask(@CLI.Arg(value="file|string|Archive file path") String file, @CLI.Arg(value="_flag|a|Start appendOnly mode") boolean start, @CLI.Arg(value="_flag|e|End appendOnly mode") boolean end, @CLI.Arg(value="_flag|c|Request checkpoint before backup") boolean checkpoint, @CLI.Arg(value="_flag|z|Compress output to ZIP format") boolean compressed, @CLI.Arg(value="_flag|f|Emit a list of files that need to be copied") boolean showFiles, @CLI.Arg(value="_flag|y|Copyback pages before starting") boolean copyback) throws Exception {
        BackupTask task = new BackupTask();
        task._toFile = file;
        task._start = start;
        task._end = end;
        task._showFiles = showFiles;
        task._compressed = compressed;
        task._checkpoint = checkpoint;
        task._copyback = copyback;
        return task;
    }

    private void validate() {
        if (this._toFile == null) {
            this._toFile = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTask() throws Exception {
        this.validate();
        Management management = this._persistit.getManagement();
        boolean wasAppendOnly = management.getJournalInfo().isAppendOnly();
        if (this._checkpoint) {
            this.postMessage("Waiting for checkpoint", 0);
            CheckpointManager.Checkpoint cp = this._persistit.checkpoint();
            if (cp == null) {
                this.postMessage("Checkpoint failed", 0);
            } else {
                this.postMessage("Checkpoint " + cp + " written", 0);
            }
        }
        if (this._copyback && !wasAppendOnly) {
            this.postMessage("Copying back pages from journal", 0);
            long start = this._persistit.getJournalManager().getCopiedPageCount();
            this._persistit.copyBackPages();
            long end = this._persistit.getJournalManager().getCopiedPageCount();
            this.postMessage(end - start + " pages copied", 0);
        }
        try {
            if (this._showFiles || !this._toFile.isEmpty()) {
                management.setAppendOnly(true);
                this.populateBackupFiles();
                if (!this._toFile.isEmpty()) {
                    this.doBackup();
                }
            }
            management.setAppendOnly(this._start ? true : (this._end ? false : wasAppendOnly));
        }
        catch (Exception e) {
            try {
                this._backupStatus = "Failed: " + e;
                management.setAppendOnly(this._start ? true : (this._end ? false : wasAppendOnly));
            }
            catch (Throwable throwable) {
                management.setAppendOnly(this._start ? true : (this._end ? false : wasAppendOnly));
                throw throwable;
            }
        }
    }

    @Override
    protected void postMessage(String message, int level) {
        super.postMessage(message, level);
        this._backupStatus = message;
    }

    private void populateBackupFiles() throws Exception {
        Management.VolumeInfo[] volumes;
        for (Management.VolumeInfo info : volumes = this._persistit.getManagement().getVolumeInfoArray()) {
            if (info.isTransient()) continue;
            this._files.add(info.getPath());
        }
        Management.JournalInfo info = this._persistit.getManagement().getJournalInfo();
        long baseAddress = info.getBaseAddress();
        long currentAddress = info.getCurrentJournalAddress();
        long blockSize = info.getBlockSize();
        String path = JournalManager.fileToPath(new File(info.getCurrentJournalFile()));
        for (long generation = baseAddress / blockSize; generation <= currentAddress / blockSize; ++generation) {
            File file = JournalManager.generationToFile(path, generation);
            this._files.add(file.getAbsolutePath());
        }
        StringBuilder sb = new StringBuilder();
        for (String string : this._files) {
            sb.append(string);
            sb.append(Util.NEW_LINE);
        }
        this._backupStatus = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackup() throws Exception {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this._toFile), 0x100000));){
            byte[] buffer = new byte[65536];
            zos.setLevel(this._compressed ? 8 : 0);
            long size = 0L;
            for (String file : this._files) {
                size += new File(file).length();
            }
            this.postMessage("Total size of files in backup set: " + this.formatedSize(size), 0);
            for (String path : this._files) {
                File file = new File(path);
                this.postMessage("Backing up " + path + " size=" + this.formatedSize(file.length()), 1);
                ZipEntry ze = new ZipEntry(path);
                ze.setSize(file.length());
                ze.setTime(file.lastModified());
                zos.putNextEntry(ze);
                long progress = 0L;
                long fileSize = 0L;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 0x100000);){
                    int readCount = 0;
                    while ((readCount = is.read(buffer, 0, buffer.length)) != -1) {
                        zos.write(buffer, 0, readCount);
                        fileSize += (long)readCount;
                        if ((progress += (long)readCount) > 100000000L) {
                            progress -= 100000000L;
                            this.appendMessage(" (" + this.formatedSize(fileSize) + ")", 1);
                        }
                        this.poll();
                    }
                }
            }
            this.postMessage("Backup of " + this._files.size() + " files to " + this._toFile + " completed", 0);
        }
    }

    public void doRestore(String path) throws Exception {
        ZipEntry ze;
        File zipFile = new File(path);
        byte[] buffer = new byte[65536];
        this.postMessage("Unzipping files from " + zipFile + " size=" + this.formatedSize(zipFile.length()), 0);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile), 0x100000));
        while ((ze = zis.getNextEntry()) != null) {
            this.postMessage("Unzipping " + ze, 0);
            File file = new File(ze.getName());
            if (file.exists()) {
                this.rename(file);
            }
            long progress = 0L;
            long fileSize = 0L;
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, false));
            int writeCount = 0;
            while ((writeCount = zis.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, writeCount);
                fileSize += (long)writeCount;
                if ((progress += (long)writeCount) <= 100000000L) continue;
                progress -= 100000000L;
                this.appendMessage(" " + this.formatedSize(fileSize), 1);
            }
            ((OutputStream)os).close();
        }
        zis.close();
    }

    private void rename(File file) throws Exception {
        for (int k = 0; k < 1000; ++k) {
            String candidate = k == 0 ? file.getAbsolutePath() + "~" : file.getAbsoluteFile() + "~" + k;
            File newFile = new File(candidate);
            if (newFile.exists()) continue;
            file.renameTo(newFile);
            return;
        }
        throw new IOException("Unable to rename file " + file);
    }

    private String formatedSize(long size) {
        long value = size;
        int scale = 0;
        while (value > 9999L) {
            value = (value + 499L) / 1000L;
            ++scale;
        }
        return String.format("%,d", value) + " KMGTPE".substring(scale, scale + 1);
    }

    @Override
    public String getStatus() {
        return this._backupStatus;
    }

    public List<String> getFileList() {
        return this._files;
    }
}

