/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.ErrorLogPublisherCfgClient;
import org.forgerock.opendj.server.config.meta.LogPublisherCfgDefn;
import org.forgerock.opendj.server.config.server.ErrorLogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogPublisherCfg;

public final class ErrorLogPublisherCfgDefn
extends ManagedObjectDefinition<ErrorLogPublisherCfgClient, ErrorLogPublisherCfg> {
    private static final ErrorLogPublisherCfgDefn INSTANCE = new ErrorLogPublisherCfgDefn();
    private static final EnumPropertyDefinition<DefaultSeverity> PD_DEFAULT_SEVERITY;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_OVERRIDE_SEVERITY;

    public static ErrorLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private ErrorLogPublisherCfgDefn() {
        super("error-log-publisher", LogPublisherCfgDefn.getInstance());
    }

    @Override
    public ErrorLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends ErrorLogPublisherCfgClient> impl) {
        return new ErrorLogPublisherCfgClientImpl(impl);
    }

    @Override
    public ErrorLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends ErrorLogPublisherCfg> impl) {
        return new ErrorLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<ErrorLogPublisherCfg> getServerConfigurationClass() {
        return ErrorLogPublisherCfg.class;
    }

    public EnumPropertyDefinition<DefaultSeverity> getDefaultSeverityPropertyDefinition() {
        return PD_DEFAULT_SEVERITY;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return LogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getOverrideSeverityPropertyDefinition() {
        return PD_OVERRIDE_SEVERITY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = EnumPropertyDefinition.createBuilder(INSTANCE, "default-severity");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-severity"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("error", "warning");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(DefaultSeverity.class);
        PD_DEFAULT_SEVERITY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_SEVERITY);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.ErrorLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.LogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "override-severity");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "override-severity"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "override-severity"));
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_OVERRIDE_SEVERITY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_OVERRIDE_SEVERITY);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class ErrorLogPublisherCfgServerImpl
    implements ErrorLogPublisherCfg {
        private ServerManagedObject<? extends ErrorLogPublisherCfg> impl;
        private final SortedSet<DefaultSeverity> pDefaultSeverity;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final SortedSet<String> pOverrideSeverity;

        private ErrorLogPublisherCfgServerImpl(ServerManagedObject<? extends ErrorLogPublisherCfg> impl) {
            this.impl = impl;
            this.pDefaultSeverity = impl.getPropertyValues(INSTANCE.getDefaultSeverityPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pOverrideSeverity = impl.getPropertyValues((PropertyDefinition)INSTANCE.getOverrideSeverityPropertyDefinition());
        }

        @Override
        public void addErrorChangeListener(ConfigurationChangeListener<ErrorLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeErrorChangeListener(ConfigurationChangeListener<ErrorLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DefaultSeverity> getDefaultSeverity() {
            return this.pDefaultSeverity;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<String> getOverrideSeverity() {
            return this.pOverrideSeverity;
        }

        @Override
        public Class<? extends ErrorLogPublisherCfg> configurationClass() {
            return ErrorLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ErrorLogPublisherCfgClientImpl
    implements ErrorLogPublisherCfgClient {
        private ManagedObject<? extends ErrorLogPublisherCfgClient> impl;

        private ErrorLogPublisherCfgClientImpl(ManagedObject<? extends ErrorLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DefaultSeverity> getDefaultSeverity() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultSeverityPropertyDefinition());
        }

        @Override
        public void setDefaultSeverity(Collection<DefaultSeverity> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultSeverityPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getOverrideSeverity() {
            return this.impl.getPropertyValues(INSTANCE.getOverrideSeverityPropertyDefinition());
        }

        @Override
        public void setOverrideSeverity(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getOverrideSeverityPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends ErrorLogPublisherCfgClient, ? extends ErrorLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum DefaultSeverity {
        ALL("all"),
        DEBUG("debug"),
        ERROR("error"),
        INFO("info"),
        NONE("none"),
        NOTICE("notice"),
        WARNING("warning");

        private final String name;

        private DefaultSeverity(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

