/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentGroup;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommandBuilder;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.DocGenerationHelper;
import com.forgerock.opendj.cli.Menu;
import com.forgerock.opendj.cli.MenuBuilder;
import com.forgerock.opendj.cli.MenuCallback;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.SubCommandUsageHandler;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.opendj.config.ACIPropertyDefinition;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.ConfigurationFramework;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.DurationUnit;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectOption;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelationOption;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.CreateSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.DeleteSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.GetPropSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.HelpSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.ListSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.SetPropSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;
import org.forgerock.opendj.config.dsconfig.SubCommandHandlerFactory;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.DN;

public final class DSConfig
extends ConsoleApplication {
    static final String DSCONFIGTOOLNAME = "dsconfig";
    static final String PROPERTY_SCRIPT_NAME = "org.opends.server.scriptName";
    public static final String CUSTOM_TYPE = "custom";
    public static final String GENERIC_TYPE = "generic";
    private long sessionStartTime;
    private boolean sessionStartTimePrinted;
    private int sessionEquivalentOperationNumber;
    private LDAPManagementContextFactory factory;
    private boolean globalArgumentsInitialized;
    private SubCommandHandlerFactory handlerFactory;
    private final Map<SubCommand, SubCommandHandler> handlers = new HashMap<SubCommand, SubCommandHandler>();
    private boolean hasSubCommand = true;
    private final SubCommandArgumentParser parser = new SubCommandArgumentParser(((Object)((Object)this)).getClass().getName(), DsconfigMessages.INFO_DSCFG_TOOL_DESCRIPTION.get(), false);
    private BooleanArgument advancedModeArgument;
    private BooleanArgument noPromptArgument;
    private BooleanArgument displayEquivalentArgument;
    private StringArgument equivalentCommandFileArgument;
    private BooleanArgument quietArgument;
    private BooleanArgument scriptFriendlyArgument;
    private BooleanArgument showUsageArgument;
    private BooleanArgument verboseArgument;
    private BooleanArgument batchArgument;
    private StringArgument batchFileArgument;
    private StringArgument propertiesFileArgument;
    private BooleanArgument noPropertiesFileArgument;

    static <T> MenuResult<T> interactivePrintOrThrowError(ConsoleApplication app, LocalizableMessage msg, ReturnCode errorCode) throws ClientException {
        if (!app.isInteractive()) {
            throw new ClientException(errorCode, msg);
        }
        app.errPrintln();
        app.errPrintln(msg);
        return MenuResult.cancel();
    }

    public static void main(String[] args) {
        int exitCode = DSConfig.main(args, System.out, System.err);
        if (exitCode != ReturnCode.SUCCESS.get()) {
            System.exit(Utils.filterExitCode((int)exitCode));
        }
    }

    public static int main(String[] args, OutputStream outStream, OutputStream errStream) {
        DSConfig app = new DSConfig(outStream, errStream);
        app.sessionStartTime = System.currentTimeMillis();
        if (!ConfigurationFramework.getInstance().isInitialized()) {
            try {
                ConfigurationFramework.getInstance().initialize();
            }
            catch (ConfigException e) {
                app.errPrintln(e.getMessageObject());
                return ReturnCode.ERROR_INITIALIZING_SERVER.get();
            }
        }
        return app.run(args);
    }

    private DSConfig(OutputStream out, OutputStream err) {
        super(new PrintStream(out), new PrintStream(err));
        this.parser.setShortToolDescription(DsconfigMessages.REF_SHORT_DESC_DSCONFIG.get());
        this.parser.setDocToolDescriptionSupplement(DsconfigMessages.REF_DSCFG_DOC_TOOL_DESCRIPTION.get());
        this.parser.setDocSubcommandsDescriptionSupplement(DsconfigMessages.REF_DSCFG_DOC_SUBCOMMANDS_DESCRIPTION.get());
        this.parser.setVersionHandler(ToolVersionHandler.newToolVersionHandler((String)"opendj-config"));
        if (System.getProperty("org.forgerock.opendj.gendoc") != null) {
            this.parser.setUsageHandler((SubCommandUsageHandler)new DSConfigSubCommandUsageHandler());
        }
    }

    public boolean isAdvancedMode() {
        return this.advancedModeArgument.isPresent();
    }

    public boolean isInteractive() {
        return !this.noPromptArgument.isPresent();
    }

    public boolean isMenuDrivenMode() {
        return !this.hasSubCommand;
    }

    public boolean isQuiet() {
        return this.quietArgument.isPresent();
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendlyArgument.isPresent();
    }

    public boolean isVerbose() {
        return this.verboseArgument.isPresent();
    }

    private void initializeGlobalArguments() throws ArgumentException {
        if (!this.globalArgumentsInitialized) {
            this.verboseArgument = CommonArguments.verboseArgument();
            this.quietArgument = CommonArguments.quietArgument();
            this.scriptFriendlyArgument = CommonArguments.scriptFriendlyArgument();
            this.noPromptArgument = CommonArguments.noPromptArgument();
            this.advancedModeArgument = CommonArguments.advancedModeArgument();
            this.showUsageArgument = CommonArguments.showUsageArgument();
            this.batchArgument = ((BooleanArgument.Builder)BooleanArgument.builder((String)"batch").description(DsconfigMessages.INFO_DESCRIPTION_BATCH.get())).buildArgument();
            this.batchFileArgument = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"batchFilePath").shortIdentifier(Character.valueOf('F'))).description(DsconfigMessages.INFO_DESCRIPTION_BATCH_FILE_PATH.get())).valuePlaceholder(DsconfigMessages.INFO_BATCH_FILE_PATH_PLACEHOLDER.get())).buildArgument();
            this.displayEquivalentArgument = ((BooleanArgument.Builder)BooleanArgument.builder((String)"displayCommand").description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_DISPLAY_EQUIVALENT.get())).buildArgument();
            this.equivalentCommandFileArgument = ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"commandFilePath").description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_EQUIVALENT_COMMAND_FILE_PATH.get())).valuePlaceholder(CliMessages.INFO_PATH_PLACEHOLDER.get())).buildArgument();
            this.propertiesFileArgument = ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"propertiesFilePath").description(CliMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get())).valuePlaceholder(CliMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get())).buildArgument();
            this.noPropertiesFileArgument = ((BooleanArgument.Builder)BooleanArgument.builder((String)"noPropertiesFile").description(CliMessages.INFO_DESCRIPTION_NO_PROP_FILE.get())).buildArgument();
            ArgumentGroup toolOptionsGroup = new ArgumentGroup(DsconfigMessages.INFO_DSCFG_DESCRIPTION_OPTIONS_ARGS.get(), 2);
            this.parser.addGlobalArgument((Argument)this.advancedModeArgument, toolOptionsGroup);
            this.parser.addGlobalArgument((Argument)this.showUsageArgument);
            this.parser.setUsageArgument((Argument)this.showUsageArgument, (OutputStream)this.getOutputStream());
            this.parser.addGlobalArgument((Argument)this.verboseArgument);
            this.parser.addGlobalArgument((Argument)this.quietArgument);
            this.parser.addGlobalArgument((Argument)this.scriptFriendlyArgument);
            this.parser.addGlobalArgument((Argument)this.noPromptArgument);
            this.parser.addGlobalArgument((Argument)this.batchArgument);
            this.parser.addGlobalArgument((Argument)this.batchFileArgument);
            this.parser.addGlobalArgument((Argument)this.displayEquivalentArgument);
            this.parser.addGlobalArgument((Argument)this.equivalentCommandFileArgument);
            this.parser.addGlobalArgument((Argument)this.propertiesFileArgument);
            this.parser.setFilePropertiesArgument(this.propertiesFileArgument);
            this.parser.addGlobalArgument((Argument)this.noPropertiesFileArgument);
            this.parser.setNoPropertiesFileArgument(this.noPropertiesFileArgument);
            this.globalArgumentsInitialized = true;
        }
    }

    private void initializeSubCommands() throws ArgumentException {
        if (this.handlerFactory == null) {
            this.handlerFactory = new SubCommandHandlerFactory(this.parser);
            Comparator<SubCommand> c = new Comparator<SubCommand>(){

                @Override
                public int compare(SubCommand o1, SubCommand o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            TreeMap<Tag, TreeSet<SubCommand>> groups = new TreeMap<Tag, TreeSet<SubCommand>>();
            TreeSet<SubCommand> allSubCommands = new TreeSet<SubCommand>(c);
            for (SubCommandHandler subCommandHandler : this.handlerFactory.getAllSubCommandHandlers()) {
                SubCommand sc = subCommandHandler.getSubCommand();
                this.handlers.put(sc, subCommandHandler);
                allSubCommands.add(sc);
                for (Tag tag : subCommandHandler.getTags()) {
                    TreeSet<SubCommand> group = (TreeSet<SubCommand>)groups.get(tag);
                    if (group == null) {
                        group = new TreeSet<SubCommand>(c);
                        groups.put(tag, group);
                    }
                    group.add(sc);
                }
            }
            for (Map.Entry entry : groups.entrySet()) {
                Tag tag = (Tag)entry.getKey();
                SortedSet subCommands = (SortedSet)entry.getValue();
                String option = "help-" + tag.getName();
                String synopsis = tag.getSynopsis().toString().toLowerCase();
                BooleanArgument arg = ((BooleanArgument.Builder)BooleanArgument.builder((String)option).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE.get((Object)synopsis))).buildArgument();
                this.parser.addGlobalArgument((Argument)arg);
                this.parser.setUsageGroupArgument((Argument)arg, (Collection)subCommands);
            }
            String option = "help-all";
            BooleanArgument booleanArgument = ((BooleanArgument.Builder)BooleanArgument.builder((String)option).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_ALL.get())).buildArgument();
            this.parser.addGlobalArgument((Argument)booleanArgument);
            this.parser.setUsageGroupArgument((Argument)booleanArgument, allSubCommands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        try {
            this.initializeGlobalArguments();
            this.initializeSubCommands();
        }
        catch (ArgumentException e) {
            this.errPrintln(DsconfigMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)e.getMessage()));
            return ReturnCode.ERROR_USER_DATA.get();
        }
        ConnectionFactoryProvider cfp = null;
        try {
            cfp = new ConnectionFactoryProvider((ArgumentParser)this.parser, (ConsoleApplication)this, "cn=Directory Manager", 4444, true);
            cfp.setIsAnAdminConnection();
            this.parser.parseArguments(args);
            this.checkForConflictingArguments();
        }
        catch (ArgumentException ae) {
            this.parser.displayMessageAndUsageReference(this.getErrStream(), DsconfigMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ReturnCode.CONFLICTING_ARGS.get();
        }
        if (this.parser.usageOrVersionDisplayed()) {
            return ReturnCode.SUCCESS.get();
        }
        if (this.equivalentCommandFileArgument.isPresent()) {
            String file = this.equivalentCommandFileArgument.getValue();
            if (!Utils.canWrite((String)file)) {
                this.errPrintln(DsconfigMessages.ERR_DSCFG_CANNOT_WRITE_EQUIVALENT_COMMAND_LINE_FILE.get((Object)file));
                return ReturnCode.ERROR_UNEXPECTED.get();
            }
            if (new File(file).isDirectory()) {
                this.errPrintln(DsconfigMessages.ERR_DSCFG_EQUIVALENT_COMMAND_LINE_FILE_DIRECTORY.get((Object)file));
                return ReturnCode.ERROR_UNEXPECTED.get();
            }
        }
        try {
            this.factory = new LDAPManagementContextFactory(cfp);
        }
        catch (ArgumentException e) {
            this.parser.displayMessageAndUsageReference(this.getErrStream(), DsconfigMessages.ERR_ERROR_PARSING_ARGS.get((Object)e.getMessage()));
            return ReturnCode.CONFLICTING_ARGS.get();
        }
        try {
            if (this.batchArgument.isPresent() || this.batchFileArgument.isPresent()) {
                this.handleBatch(args);
                int n = ReturnCode.SUCCESS.get();
                return n;
            }
            boolean bl = this.hasSubCommand = this.parser.getSubCommand() != null;
            if (this.hasSubCommand) {
                int n = this.runSubCommand(this.handlers.get(this.parser.getSubCommand()));
                return n;
            }
            if (this.isInteractive()) {
                int n = this.runInteractiveMode();
                return n;
            }
            this.parser.displayMessageAndUsageReference(this.getErrStream(), DsconfigMessages.ERR_ERROR_PARSING_ARGS.get((Object)DsconfigMessages.ERR_DSCFG_ERROR_MISSING_SUBCOMMAND.get()));
            int n = ReturnCode.ERROR_USER_DATA.get();
            return n;
        }
        finally {
            this.factory.close();
        }
    }

    private void checkForConflictingArguments() throws ArgumentException {
        Utils.throwIfArgumentsConflict((Argument)this.quietArgument, (Argument)this.verboseArgument);
        Utils.throwIfArgumentsConflict((Argument)this.batchArgument, (Argument)this.batchFileArgument);
        this.throwIfSetInInteractiveMode((Argument)this.batchFileArgument);
        this.throwIfSetInInteractiveMode((Argument)this.batchArgument);
        this.throwIfSetInInteractiveMode((Argument)this.quietArgument);
        Utils.throwIfArgumentsConflict((Argument)this.scriptFriendlyArgument, (Argument)this.verboseArgument);
        Utils.throwIfArgumentsConflict((Argument)this.noPropertiesFileArgument, (Argument)this.propertiesFileArgument);
    }

    private void throwIfSetInInteractiveMode(Argument arg) throws ArgumentException {
        if (arg.isPresent() && !this.noPromptArgument.isPresent()) {
            throw new ArgumentException(DsconfigMessages.ERR_DSCFG_ERROR_QUIET_AND_INTERACTIVE_INCOMPATIBLE.get((Object)arg.getLongIdentifier(), (Object)this.noPromptArgument.getLongIdentifier()));
        }
    }

    private int runInteractiveMode() {
        DSConfig app = this;
        Comparator c = new Comparator<RelationDefinition<?, ?>>(){

            @Override
            public int compare(RelationDefinition<?, ?> rd1, RelationDefinition<?, ?> rd2) {
                String s1 = rd1.getUserFriendlyName().toString();
                String s2 = rd2.getUserFriendlyName().toString();
                return s1.compareToIgnoreCase(s2);
            }
        };
        TreeSet relations = new TreeSet(c);
        HashMap createHandlers = new HashMap();
        HashMap deleteHandlers = new HashMap();
        HashMap listHandlers = new HashMap();
        HashMap getPropHandlers = new HashMap();
        HashMap setPropHandlers = new HashMap();
        for (CreateSubCommandHandler createSubCommandHandler : this.handlerFactory.getCreateSubCommandHandlers()) {
            relations.add(createSubCommandHandler.getRelationDefinition());
            createHandlers.put(createSubCommandHandler.getRelationDefinition(), createSubCommandHandler);
        }
        for (DeleteSubCommandHandler deleteSubCommandHandler : this.handlerFactory.getDeleteSubCommandHandlers()) {
            relations.add(deleteSubCommandHandler.getRelationDefinition());
            deleteHandlers.put(deleteSubCommandHandler.getRelationDefinition(), deleteSubCommandHandler);
        }
        for (ListSubCommandHandler listSubCommandHandler : this.handlerFactory.getListSubCommandHandlers()) {
            relations.add(listSubCommandHandler.getRelationDefinition());
            listHandlers.put(listSubCommandHandler.getRelationDefinition(), listSubCommandHandler);
        }
        for (GetPropSubCommandHandler getPropSubCommandHandler : this.handlerFactory.getGetPropSubCommandHandlers()) {
            relations.add(getPropSubCommandHandler.getRelationDefinition());
            getPropHandlers.put(getPropSubCommandHandler.getRelationDefinition(), getPropSubCommandHandler);
        }
        for (SetPropSubCommandHandler setPropSubCommandHandler : this.handlerFactory.getSetPropSubCommandHandlers()) {
            relations.add(setPropSubCommandHandler.getRelationDefinition());
            setPropHandlers.put(setPropSubCommandHandler.getRelationDefinition(), setPropSubCommandHandler);
        }
        MenuBuilder builder = new MenuBuilder((ConsoleApplication)app);
        builder.setTitle(DsconfigMessages.INFO_DSCFG_HEADING_MAIN_MENU_TITLE.get());
        builder.setPrompt(DsconfigMessages.INFO_DSCFG_HEADING_MAIN_MENU_PROMPT.get());
        builder.setMultipleColumnThreshold(0);
        for (RelationDefinition relationDefinition : relations) {
            SubMenuCallback callback = new SubMenuCallback(app, relationDefinition, (CreateSubCommandHandler)createHandlers.get(relationDefinition), (DeleteSubCommandHandler)deleteHandlers.get(relationDefinition), (ListSubCommandHandler)listHandlers.get(relationDefinition), (SetPropSubCommandHandler)setPropHandlers.get(relationDefinition));
            builder.addNumberedOption(relationDefinition.getUserFriendlyName(), (MenuCallback)callback, new LocalizableMessage[0]);
        }
        builder.addQuitOption();
        Menu menu = builder.toMenu();
        try {
            this.factory.getManagementContext(app);
        }
        catch (ArgumentException argumentException) {
            this.parser.displayMessageAndUsageReference(this.getErrStream(), argumentException.getMessageObject());
            return ReturnCode.ERROR_USER_DATA.get();
        }
        catch (ClientException clientException) {
            app.errPrintln(clientException.getMessageObject());
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
        try {
            app.println();
            app.println();
            MenuResult menuResult = menu.run();
            if (menuResult.isQuit()) {
                return ReturnCode.SUCCESS.get();
            }
            return (Integer)menuResult.getValue();
        }
        catch (ClientException clientException) {
            app.errPrintln(clientException.getMessageObject());
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
    }

    private int runSubCommand(SubCommandHandler handler) {
        try {
            MenuResult<Integer> result = handler.run(this, this.factory);
            if (result.isSuccess()) {
                if (this.isInteractive() && handler.isCommandBuilderUseful()) {
                    this.printCommandBuilder(this.getCommandBuilder(handler));
                }
                return (Integer)result.getValue();
            }
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
        catch (ArgumentException e) {
            this.errPrintln(e.getMessageObject());
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            this.errPrintln();
            if (cause instanceof ManagedObjectDecodingException) {
                ArgumentExceptionFactory.displayManagedObjectDecodingException(this, (ManagedObjectDecodingException)cause);
            } else if (cause instanceof MissingMandatoryPropertiesException) {
                ArgumentExceptionFactory.displayMissingMandatoryPropertyException(this, (MissingMandatoryPropertiesException)cause);
            } else if (cause instanceof OperationRejectedException) {
                ArgumentExceptionFactory.displayOperationRejectedException(this, (OperationRejectedException)cause);
            } else {
                this.errPrintln(e.getMessageObject());
            }
            this.errPrintln();
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
        catch (Exception e) {
            this.errPrintln(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true), (Object[])new Object[0]));
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
    }

    CommandBuilder getCommandBuilder(Object subCommand) {
        String subCommandName;
        SubCommandHandler handler;
        String commandName = this.getScriptName();
        if (subCommand instanceof SubCommandHandler) {
            handler = (SubCommandHandler)subCommand;
            subCommandName = handler.getSubCommand().getName();
        } else {
            handler = null;
            subCommandName = (String)subCommand;
        }
        CommandBuilder commandBuilder = new CommandBuilder(commandName, subCommandName);
        if (handler != null) {
            commandBuilder.append(handler.getCommandBuilder());
        }
        if (this.factory != null && this.factory.getContextCommandBuilder() != null) {
            commandBuilder.append(this.factory.getContextCommandBuilder());
        }
        if (this.verboseArgument.isPresent()) {
            commandBuilder.addArgument((Argument)this.verboseArgument);
        }
        if (this.scriptFriendlyArgument.isPresent()) {
            commandBuilder.addArgument((Argument)this.scriptFriendlyArgument);
        }
        commandBuilder.addArgument((Argument)this.noPromptArgument);
        if (this.propertiesFileArgument.isPresent()) {
            commandBuilder.addArgument((Argument)this.propertiesFileArgument);
        }
        if (this.noPropertiesFileArgument.isPresent()) {
            commandBuilder.addArgument((Argument)this.noPropertiesFileArgument);
        }
        return commandBuilder;
    }

    private String getScriptName() {
        String commandName = System.getProperty(PROPERTY_SCRIPT_NAME);
        if (commandName != null && commandName.length() != 0) {
            return commandName;
        }
        return DSCONFIGTOOLNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printCommandBuilder(CommandBuilder commandBuilder) {
        if (this.displayEquivalentArgument.isPresent()) {
            this.println();
            this.println(DsconfigMessages.INFO_DSCFG_NON_INTERACTIVE.get((Object)commandBuilder));
        }
        if (this.equivalentCommandFileArgument.isPresent()) {
            String file = this.equivalentCommandFileArgument.getValue();
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(file, true));
                if (!this.sessionStartTimePrinted) {
                    writer.write(Utils.SHELL_COMMENT_SEPARATOR + this.getSessionStartTimeMessage());
                    writer.newLine();
                    this.sessionStartTimePrinted = true;
                }
                ++this.sessionEquivalentOperationNumber;
                writer.newLine();
                writer.write(Utils.SHELL_COMMENT_SEPARATOR + DsconfigMessages.INFO_DSCFG_EQUIVALENT_COMMAND_LINE_SESSION_OPERATION_NUMBER.get((Object)this.sessionEquivalentOperationNumber));
                writer.newLine();
                writer.write(Utils.SHELL_COMMENT_SEPARATOR + Utils.getCurrentOperationDateMessage());
                writer.newLine();
                writer.write(commandBuilder.toString());
                writer.newLine();
                writer.newLine();
                writer.flush();
            }
            catch (IOException ioe) {
                try {
                    this.errPrintln(DsconfigMessages.ERR_DSCFG_ERROR_WRITING_EQUIVALENT_COMMAND_LINE.get((Object)file, (Object)ioe));
                }
                catch (Throwable throwable) {
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{writer});
            }
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{writer});
        }
    }

    private String getSessionStartTimeMessage() {
        String date = Utils.formatDateTimeStringForEquivalentCommand((Date)new Date(this.sessionStartTime));
        return DsconfigMessages.INFO_DSCFG_SESSION_START_TIME_MESSAGE.get((Object)this.getScriptName(), (Object)date).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBatch(String[] args) {
        BufferedReader bReader = null;
        try {
            String line;
            if (this.batchArgument.isPresent()) {
                bReader = new BufferedReader(new InputStreamReader(System.in));
            } else if (this.batchFileArgument.isPresent()) {
                String batchFilePath = this.batchFileArgument.getValue().trim();
                bReader = new BufferedReader(new FileReader(batchFilePath));
            } else {
                throw new IllegalArgumentException("Either --batch or --batchFilePath argument should have been set");
            }
            List<String> initialArgs = this.removeBatchArgs(args);
            String command = "";
            while ((line = bReader.readLine()) != null) {
                if ("".equals(line) || line.startsWith("#")) continue;
                if (line.endsWith("\\")) {
                    command = command + line.substring(0, line.length() - 1);
                    continue;
                }
                command = command + line;
                command = command.trim();
                command = this.replaceSpacesInQuotes(command);
                command = command.replace("\\ ", "##");
                String displayCommand = command.replace("\\ ", " ");
                this.println(LocalizableMessage.raw((CharSequence)displayCommand, (Object[])new Object[0]));
                String[] allArgsArray = this.buildCommandArgs(initialArgs, command);
                int exitCode = DSConfig.main(allArgsArray, this.getOutputStream(), this.getErrorStream());
                if (exitCode != ReturnCode.SUCCESS.get()) {
                    System.exit(Utils.filterExitCode((int)exitCode));
                }
                this.println();
                command = "";
            }
        }
        catch (IOException ex) {
            try {
                this.errPrintln(DsconfigMessages.ERR_DSCFG_ERROR_READING_BATCH_FILE.get((Object)ex));
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{bReader});
                throw throwable;
            }
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{bReader});
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{bReader});
    }

    private String[] buildCommandArgs(List<String> initialArgs, String batchCommand) {
        String[] commandArgs = this.toCommandArgs(batchCommand);
        int length = commandArgs.length + initialArgs.size();
        ArrayList<String> allArguments = new ArrayList<String>(length);
        Collections.addAll(allArguments, commandArgs);
        allArguments.addAll(initialArgs);
        return allArguments.toArray(new String[length]);
    }

    private String[] toCommandArgs(String command) {
        String[] fileArguments = command.split("\\s+");
        for (int ii = 0; ii < fileArguments.length; ++ii) {
            fileArguments[ii] = fileArguments[ii].replace("##", " ");
        }
        return fileArguments;
    }

    private List<String> removeBatchArgs(String[] args) {
        ArrayList<String> initialArgs = new ArrayList<String>();
        Collections.addAll(initialArgs, args);
        Iterator it = initialArgs.iterator();
        while (it.hasNext()) {
            String elem = (String)it.next();
            if (this.batchArgument.isPresent() && elem.contains(this.batchArgument.getLongIdentifier())) {
                it.remove();
                break;
            }
            if (!this.batchFileArgument.isPresent() || !elem.startsWith("-" + this.batchFileArgument.getShortIdentifier()) && !elem.contains(this.batchFileArgument.getLongIdentifier())) continue;
            it.remove();
            it.next();
            it.remove();
            break;
        }
        return initialArgs;
    }

    private String replaceSpacesInQuotes(String line) {
        StringBuilder newLine = new StringBuilder();
        boolean inQuotes = false;
        for (int ii = 0; ii < line.length(); ++ii) {
            char ch = line.charAt(ii);
            if (ch == '\"' || ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes && ch == ' ') {
                newLine.append("\\ ");
                continue;
            }
            newLine.append(ch);
        }
        return newLine.toString();
    }

    private class SubMenuCallback
    implements MenuCallback<Integer> {
        private final Menu<Integer> menu;

        public SubMenuCallback(ConsoleApplication app, RelationDefinition<?, ?> rd, CreateSubCommandHandler<?, ?> ch, DeleteSubCommandHandler dh, ListSubCommandHandler lh, SetPropSubCommandHandler sh) {
            LocalizableMessage msg;
            SubCommandHandlerMenuCallback callback;
            LocalizableMessage userFriendlyName = rd.getUserFriendlyName();
            LocalizableMessage userFriendlyPluralName = null;
            if (rd instanceof InstantiableRelationDefinition) {
                InstantiableRelationDefinition ir = (InstantiableRelationDefinition)rd;
                userFriendlyPluralName = ir.getUserFriendlyPluralName();
            } else if (rd instanceof SetRelationDefinition) {
                SetRelationDefinition sr = (SetRelationDefinition)rd;
                userFriendlyPluralName = sr.getUserFriendlyPluralName();
            }
            MenuBuilder builder = new MenuBuilder(app);
            builder.setTitle(DsconfigMessages.INFO_DSCFG_HEADING_COMPONENT_MENU_TITLE.get((Object)userFriendlyName));
            builder.setPrompt(DsconfigMessages.INFO_DSCFG_HEADING_COMPONENT_MENU_PROMPT.get());
            if (lh != null) {
                callback = new SubCommandHandlerMenuCallback(lh);
                msg = this.getMsg(DsconfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_SINGULAR, userFriendlyName, DsconfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_PLURAL, userFriendlyPluralName);
                builder.addNumberedOption(msg, (MenuCallback)callback, new LocalizableMessage[0]);
            }
            if (ch != null) {
                callback = new SubCommandHandlerMenuCallback(ch);
                builder.addNumberedOption(DsconfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_CREATE.get((Object)userFriendlyName), (MenuCallback)callback, new LocalizableMessage[0]);
            }
            if (sh != null) {
                callback = new SubCommandHandlerMenuCallback(sh);
                msg = this.getMsg(DsconfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_SINGULAR, userFriendlyName, DsconfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_PLURAL, userFriendlyPluralName);
                builder.addNumberedOption(msg, (MenuCallback)callback, new LocalizableMessage[0]);
            }
            if (dh != null) {
                callback = new SubCommandHandlerMenuCallback(dh);
                builder.addNumberedOption(DsconfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_DELETE.get((Object)userFriendlyName), (MenuCallback)callback, new LocalizableMessage[0]);
            }
            builder.addBackOption(true);
            builder.addQuitOption();
            this.menu = builder.toMenu();
        }

        private LocalizableMessage getMsg(LocalizableMessageDescriptor.Arg1<Object> singularMsg, LocalizableMessage userFriendlyName, LocalizableMessageDescriptor.Arg1<Object> pluralMsg, LocalizableMessage userFriendlyPluralName) {
            return userFriendlyPluralName != null ? pluralMsg.get((Object)userFriendlyPluralName) : singularMsg.get((Object)userFriendlyName);
        }

        public final MenuResult<Integer> invoke(ConsoleApplication app) throws ClientException {
            try {
                app.println();
                app.println();
                MenuResult result = this.menu.run();
                if (result.isCancel()) {
                    return MenuResult.again();
                }
                return result;
            }
            catch (ClientException e) {
                app.errPrintln(e.getMessageObject());
                return MenuResult.success((Object)1);
            }
        }
    }

    private class SubCommandHandlerMenuCallback
    implements MenuCallback<Integer> {
        private final SubCommandHandler handler;

        public SubCommandHandlerMenuCallback(SubCommandHandler handler) {
            this.handler = handler;
        }

        public MenuResult<Integer> invoke(ConsoleApplication app) throws ClientException {
            try {
                MenuResult<Integer> result = this.handler.run(app, DSConfig.this.factory);
                if (result.isQuit()) {
                    return result;
                }
                if (result.isSuccess() && DSConfig.this.isInteractive() && this.handler.isCommandBuilderUseful()) {
                    DSConfig.this.printCommandBuilder(DSConfig.this.getCommandBuilder(this.handler));
                }
                app.println();
                app.pressReturnToContinue();
                return MenuResult.again();
            }
            catch (ArgumentException e) {
                app.errPrintln(e.getMessageObject());
                return MenuResult.success((Object)1);
            }
            catch (ClientException e) {
                app.errPrintln(e.getMessageObject());
                return MenuResult.success((Object)e.getReturnCode());
            }
        }
    }

    private final class DSConfigSubCommandUsageHandler
    implements SubCommandUsageHandler {
        private String op = "<para>";
        private String cp = "</para>";

        private DSConfigSubCommandUsageHandler() {
        }

        public String getArgumentAdditionalInfo(SubCommand sc, Argument a, String nameOption) {
            StringBuilder sb = new StringBuilder();
            AbstractManagedObjectDefinition<?, ?> defn = this.getManagedObjectDefinition(sc);
            if (this.isHidden(defn)) {
                return "";
            }
            if (DocGenerationHelper.doesHandleProperties((Argument)a)) {
                LocalizableMessage name = defn.getUserFriendlyName();
                sb.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_ARG_ADDITIONAL_INFO.get((Object)name, (Object)name, (Object)nameOption)).append(this.cp).append(StaticUtils.EOL);
            } else {
                this.listSubtypes(sb, sc, a, defn);
            }
            return sb.toString();
        }

        private boolean isHidden(AbstractManagedObjectDefinition<?, ?> defn) {
            return defn == null || defn.hasOption(ManagedObjectOption.HIDDEN);
        }

        private void listSubtypes(StringBuilder sb, SubCommand sc, Argument a, AbstractManagedObjectDefinition<?, ?> defn) {
            if (a.isHidden()) {
                return;
            }
            LocalizableMessage placeholder = a.getValuePlaceholder();
            HashMap<String, Object> map = new HashMap<String, Object>();
            LocalizableMessage name = defn.getUserFriendlyName();
            map.put("dependencies", DsconfigMessages.REF_DSCFG_SUBTYPE_DEPENDENCIES.get((Object)name, (Object)name, (Object)placeholder));
            map.put("typesIntro", DsconfigMessages.REF_DSCFG_SUBTYPE_TYPES_INTRO.get((Object)name));
            LinkedList children = new LinkedList();
            for (AbstractManagedObjectDefinition<?, ?> childDefn : this.getLeafChildren(defn)) {
                if (this.isHidden(childDefn)) continue;
                HashMap<String, String> child = new HashMap<String, String>();
                child.put("name", childDefn.getName());
                child.put("default", (String)DsconfigMessages.REF_DSCFG_CHILD_DEFAULT.get((Object)placeholder, (Object)childDefn.getUserFriendlyName()));
                child.put("enabled", (String)DsconfigMessages.REF_DSCFG_CHILD_ENABLED_BY_DEFAULT.get((Object)this.propertyExists(childDefn, "enabled")));
                String link = this.getLink(DSConfig.this.getScriptName() + "-" + sc.getName() + "-" + childDefn.getName());
                child.put("link", (String)DsconfigMessages.REF_DSCFG_CHILD_LINK.get((Object)link, (Object)defn.getUserFriendlyName()));
                children.add(child);
            }
            map.put("children", children);
            DocGenerationHelper.applyTemplate((StringBuilder)sb, (String)"dscfgListSubtypes.ftl", map);
        }

        private boolean propertyExists(AbstractManagedObjectDefinition<?, ?> defn, String name) {
            if (this.isHidden(defn)) {
                return false;
            }
            try {
                return defn.getPropertyDefinition(name) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public String getProperties(SubCommand sc) {
            AbstractManagedObjectDefinition<?, ?> defn = this.getManagedObjectDefinition(sc);
            if (this.isHidden(defn)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (AbstractManagedObjectDefinition<?, ?> childDefn : this.getLeafChildren(defn)) {
                if (this.isHidden(childDefn)) continue;
                ArrayList props = new ArrayList(childDefn.getAllPropertyDefinitions());
                Collections.sort(props);
                HashMap<String, String> map = new HashMap<String, String>();
                String propPrefix = DSConfig.this.getScriptName() + "-" + sc.getName() + "-" + childDefn.getName();
                map.put("id", propPrefix);
                map.put("title", (String)childDefn.getUserFriendlyName());
                map.put("intro", (String)DsconfigMessages.REF_DSCFG_PROPS_INTRO.get((Object)defn.getUserFriendlyPluralName(), (Object)childDefn.getName()));
                map.put("list", this.toVariableList(props, defn));
                DocGenerationHelper.applyTemplate((StringBuilder)sb, (String)"dscfgAppendProps.ftl", map);
            }
            return sb.toString();
        }

        private AbstractManagedObjectDefinition<?, ?> getManagedObjectDefinition(SubCommand sc) {
            SubCommandHandler sch = (SubCommandHandler)DSConfig.this.handlers.get(sc);
            if (sch instanceof HelpSubCommandHandler) {
                return null;
            }
            RelationDefinition<?, ?> rd = this.getRelationDefinition(sch);
            if (this.isHidden(rd)) {
                return null;
            }
            return rd.getChildDefinition();
        }

        private boolean isHidden(RelationDefinition defn) {
            return defn == null || defn.hasOption(RelationOption.HIDDEN);
        }

        private List<AbstractManagedObjectDefinition<?, ?>> getLeafChildren(AbstractManagedObjectDefinition<?, ?> defn) {
            ArrayList results = new ArrayList();
            this.addIfLeaf(results, defn);
            Collections.sort(results, new Comparator<AbstractManagedObjectDefinition<?, ?>>(){

                @Override
                public int compare(AbstractManagedObjectDefinition<?, ?> o1, AbstractManagedObjectDefinition<?, ?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return results;
        }

        private void addIfLeaf(Collection<AbstractManagedObjectDefinition<?, ?>> results, AbstractManagedObjectDefinition<?, ?> defn) {
            if (defn.getChildren().isEmpty()) {
                results.add(defn);
            } else {
                for (AbstractManagedObjectDefinition<?, ?> child : defn.getChildren()) {
                    this.addIfLeaf(results, child);
                }
            }
        }

        private RelationDefinition<?, ?> getRelationDefinition(SubCommandHandler sch) {
            if (sch instanceof CreateSubCommandHandler) {
                return ((CreateSubCommandHandler)sch).getRelationDefinition();
            }
            if (sch instanceof DeleteSubCommandHandler) {
                return ((DeleteSubCommandHandler)sch).getRelationDefinition();
            }
            if (sch instanceof ListSubCommandHandler) {
                return ((ListSubCommandHandler)sch).getRelationDefinition();
            }
            if (sch instanceof GetPropSubCommandHandler) {
                return ((GetPropSubCommandHandler)sch).getRelationDefinition();
            }
            if (sch instanceof SetPropSubCommandHandler) {
                return ((SetPropSubCommandHandler)sch).getRelationDefinition();
            }
            return null;
        }

        private String toVariableList(List<PropertyDefinition<?>> props, AbstractManagedObjectDefinition<?, ?> defn) {
            StringBuilder b = new StringBuilder();
            HashMap map = new HashMap();
            LinkedList properties = new LinkedList();
            for (PropertyDefinition<?> prop : props) {
                if (prop.hasOption(PropertyOption.HIDDEN)) continue;
                HashMap<String, Object> property = new HashMap<String, Object>();
                property.put("term", prop.getName());
                property.put("descTitle", CliMessages.REF_TITLE_DESCRIPTION.get());
                property.put("description", this.getDescriptionString(prop));
                StringBuilder sb = new StringBuilder();
                this.appendDefaultBehavior(sb, prop);
                this.appendAllowedValues(sb, prop);
                this.appendVarListEntry(sb, DsconfigMessages.REF_DSCFG_PROPS_LABEL_MULTI_VALUED.get().toString(), this.getYN(prop, PropertyOption.MULTI_VALUED));
                this.appendVarListEntry(sb, DsconfigMessages.REF_DSCFG_PROPS_LABEL_REQUIRED.get().toString(), this.getYN(prop, PropertyOption.MANDATORY));
                this.appendVarListEntry(sb, DsconfigMessages.REF_DSCFG_PROPS_LABEL_ADMIN_ACTION_REQUIRED.get().toString(), this.getAdminActionRequired(prop, defn));
                this.appendVarListEntry(sb, DsconfigMessages.REF_DSCFG_PROPS_LABEL_ADVANCED_PROPERTY.get().toString(), this.getYNAdvanced(prop, PropertyOption.ADVANCED));
                this.appendVarListEntry(sb, DsconfigMessages.REF_DSCFG_PROPS_LABEL_READ_ONLY.get().toString(), this.getYN(prop, PropertyOption.READ_ONLY));
                property.put("list", sb.toString());
                properties.add(property);
            }
            map.put("properties", properties);
            DocGenerationHelper.applyTemplate((StringBuilder)b, (String)"dscfgVariableList.ftl", map);
            return b.toString();
        }

        private StringBuilder appendVarListEntry(StringBuilder b, String term, Object definition) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("term", term);
            map.put("definition", definition);
            DocGenerationHelper.applyTemplate((StringBuilder)b, (String)"dscfgVarListEntry.ftl", map);
            return b;
        }

        private void appendDefaultBehavior(StringBuilder b, PropertyDefinition<?> prop) {
            StringBuilder sb = new StringBuilder();
            this.appendDefaultBehaviorString(sb, prop);
            this.appendVarListEntry(b, DsconfigMessages.REF_DSCFG_PROPS_LABEL_DEFAULT_VALUE.get().toString(), sb.toString());
        }

        private void appendAllowedValues(StringBuilder b, PropertyDefinition<?> prop) {
            StringBuilder sb = new StringBuilder();
            this.appendSyntax(sb, prop);
            this.appendVarListEntry(b, DsconfigMessages.REF_DSCFG_PROPS_LABEL_ALLOWED_VALUES.get().toString(), sb.toString());
        }

        private Object getDescriptionString(PropertyDefinition<?> prop) {
            return (prop.getSynopsis() != null ? prop.getSynopsis() + " " : "") + (prop.getDescription() != null ? prop.getDescription() : "");
        }

        private String getAdminActionRequired(PropertyDefinition<?> prop, AbstractManagedObjectDefinition<?, ?> defn) {
            AdministratorAction adminAction = prop.getAdministratorAction();
            if (adminAction != null) {
                LocalizableMessage synopsis = adminAction.getSynopsis();
                AdministratorAction.Type actionType = adminAction.getType();
                StringBuilder action = new StringBuilder();
                if (actionType == AdministratorAction.Type.COMPONENT_RESTART) {
                    action.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_ADMIN_ACTION_COMPONENT_RESTART.get((Object)defn.getUserFriendlyName())).append(this.cp);
                } else if (actionType == AdministratorAction.Type.SERVER_RESTART) {
                    action.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_ADMIN_ACTION_SERVER_RESTART.get()).append(this.cp);
                } else if (actionType == AdministratorAction.Type.NONE) {
                    action.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_ADMIN_ACTION_NONE.get()).append(this.cp);
                }
                if (synopsis != null) {
                    action.append(this.op).append((CharSequence)synopsis).append(this.cp);
                }
                return action.toString();
            }
            return this.op + DsconfigMessages.REF_DSCFG_ADMIN_ACTION_NONE.get() + this.cp;
        }

        private String getYN(PropertyDefinition<?> prop, PropertyOption option) {
            LocalizableMessage msg = prop.hasOption(option) ? DsconfigMessages.REF_DSCFG_PROP_YES.get() : DsconfigMessages.REF_DSCFG_PROP_NO.get();
            return this.op + msg + this.cp;
        }

        private String getYNAdvanced(PropertyDefinition<?> prop, PropertyOption option) {
            LocalizableMessage msg = prop.hasOption(option) ? DsconfigMessages.REF_DSCFG_PROP_YES_ADVANCED.get() : DsconfigMessages.REF_DSCFG_PROP_NO.get();
            return this.op + msg + this.cp;
        }

        private void appendDefaultBehaviorString(StringBuilder b, PropertyDefinition<?> prop) {
            DefaultBehaviorProvider<?> defaultBehavior = prop.getDefaultBehaviorProvider();
            if (defaultBehavior instanceof UndefinedDefaultBehaviorProvider) {
                b.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_DEFAULT_BEHAVIOR_NONE.get()).append(this.cp).append(StaticUtils.EOL);
            } else if (defaultBehavior instanceof DefinedDefaultBehaviorProvider) {
                DefinedDefaultBehaviorProvider behavior = (DefinedDefaultBehaviorProvider)defaultBehavior;
                Collection<String> defaultValues = behavior.getDefaultValues();
                if (defaultValues.isEmpty()) {
                    b.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_DEFAULT_BEHAVIOR_NONE.get()).append(this.cp).append(StaticUtils.EOL);
                } else if (defaultValues.size() == 1) {
                    b.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_DEFAULT_BEHAVIOR.get((Object)defaultValues.iterator().next())).append(this.cp).append(StaticUtils.EOL);
                } else {
                    Iterator<String> it = defaultValues.iterator();
                    b.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_DEFAULT_BEHAVIOR.get((Object)it.next())).append(this.cp);
                    while (it.hasNext()) {
                        b.append(StaticUtils.EOL).append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_DEFAULT_BEHAVIOR.get((Object)it.next())).append(this.cp);
                    }
                    b.append(StaticUtils.EOL);
                }
            } else if (defaultBehavior instanceof AliasDefaultBehaviorProvider) {
                AliasDefaultBehaviorProvider behavior = (AliasDefaultBehaviorProvider)defaultBehavior;
                b.append(this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_DEFAULT_BEHAVIOR.get((Object)behavior.getSynopsis())).append(this.cp).append(StaticUtils.EOL);
            } else if (defaultBehavior instanceof RelativeInheritedDefaultBehaviorProvider) {
                RelativeInheritedDefaultBehaviorProvider behavior = (RelativeInheritedDefaultBehaviorProvider)defaultBehavior;
                this.appendDefaultBehaviorString(b, behavior.getManagedObjectDefinition().getPropertyDefinition(behavior.getPropertyName()));
            } else if (defaultBehavior instanceof AbsoluteInheritedDefaultBehaviorProvider) {
                AbsoluteInheritedDefaultBehaviorProvider behavior = (AbsoluteInheritedDefaultBehaviorProvider)defaultBehavior;
                this.appendDefaultBehaviorString(b, behavior.getManagedObjectDefinition().getPropertyDefinition(behavior.getPropertyName()));
            }
        }

        private void appendSyntax(final StringBuilder b, PropertyDefinition<?> prop) {
            PropertyDefinitionVisitor<String, Void> visitor = new PropertyDefinitionVisitor<String, Void>(){

                @Override
                public String visitACI(ACIPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_ACI_SYNTAX_REL_URL.get()).append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitAggregation(AggregationPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op);
                    InstantiableRelationDefinition rel = prop.getRelationDefinition();
                    if (DSConfigSubCommandUsageHandler.this.isHidden(rel)) {
                        return null;
                    }
                    String relFriendlyName = rel.getUserFriendlyName().toString();
                    b.append((CharSequence)DsconfigMessages.REF_DSCFG_AGGREGATION.get((Object)relFriendlyName)).append(". ");
                    LocalizableMessage synopsis = prop.getSourceConstraintSynopsis();
                    if (synopsis != null) {
                        b.append((CharSequence)synopsis);
                    }
                    b.append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitAttributeType(AttributeTypePropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_ANY_ATTRIBUTE.get()).append(".").append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitBoolean(BooleanPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append("true").append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    b.append(DSConfigSubCommandUsageHandler.this.op).append("false").append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitClass(ClassPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_JAVA_PLUGIN.get()).append(" ").append(org.forgerock.util.Utils.joinAsString((String)StaticUtils.EOL, prop.getInstanceOfInterface())).append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitDN(DNPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_VALID_DN.get());
                    DN baseDN = prop.getBaseDN();
                    if (baseDN != null) {
                        b.append(": ").append(baseDN);
                    } else {
                        b.append(".");
                    }
                    b.append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitDuration(DurationPropertyDefinition prop, Void p) {
                    b.append((CharSequence)DsconfigMessages.REF_DSCFG_DURATION_SYNTAX_REL_URL.get()).append(StaticUtils.EOL);
                    b.append(DSConfigSubCommandUsageHandler.this.op);
                    if (prop.isAllowUnlimited()) {
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_ALLOW_UNLIMITED.get()).append(" ");
                    }
                    if (prop.getMaximumUnit() != null) {
                        String maxUnitName = prop.getMaximumUnit().getLongName();
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_DURATION_MAX_UNIT.get((Object)maxUnitName)).append(".");
                    }
                    DurationUnit baseUnit = prop.getBaseUnit();
                    long lowerLimit = this.valueOf(baseUnit, prop.getLowerLimit());
                    String unitName = baseUnit.getLongName();
                    b.append((CharSequence)DsconfigMessages.REF_DSCFG_DURATION_LOWER_LIMIT.get((Object)lowerLimit, (Object)unitName)).append(".");
                    if (prop.getUpperLimit() != null) {
                        long upperLimit = this.valueOf(baseUnit, prop.getUpperLimit());
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_DURATION_UPPER_LIMIT.get((Object)upperLimit, (Object)unitName)).append(".");
                    }
                    b.append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                private long valueOf(DurationUnit baseUnit, long upperLimit) {
                    return Double.valueOf(baseUnit.fromMilliSeconds(upperLimit)).longValue();
                }

                @Override
                public String visitEnum(EnumPropertyDefinition prop, Void p) {
                    E[] constants;
                    b.append("<variablelist>").append(StaticUtils.EOL);
                    Class en = prop.getEnumClass();
                    for (Object enumConstant : constants = en.getEnumConstants()) {
                        LocalizableMessage valueSynopsis = prop.getValueSynopsis((Enum)enumConstant);
                        DSConfigSubCommandUsageHandler.this.appendVarListEntry(b, enumConstant.toString(), DSConfigSubCommandUsageHandler.this.op + valueSynopsis + DSConfigSubCommandUsageHandler.this.cp);
                    }
                    b.append("</variablelist>").append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitInteger(IntegerPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_INT.get()).append(". ").append((CharSequence)DsconfigMessages.REF_DSCFG_INT_LOWER_LIMIT.get((Object)prop.getLowerLimit())).append(".");
                    if (prop.getUpperLimit() != null) {
                        b.append(" ").append((CharSequence)DsconfigMessages.REF_DSCFG_INT_UPPER_LIMIT.get((Object)prop.getUpperLimit())).append(".");
                    }
                    if (prop.isAllowUnlimited()) {
                        b.append(" ").append((CharSequence)DsconfigMessages.REF_DSCFG_ALLOW_UNLIMITED.get());
                    }
                    if (prop.getUnitSynopsis() != null) {
                        b.append(" ").append((CharSequence)DsconfigMessages.REF_DSCFG_INT_UNIT.get((Object)prop.getUnitSynopsis())).append(".");
                    }
                    b.append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitIPAddress(IPAddressPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_IP_ADDRESS.get()).append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitIPAddressMask(IPAddressMaskPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_IP_ADDRESS_MASK.get()).append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitSize(SizePropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op);
                    if (prop.getLowerLimit() != 0L) {
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_INT_LOWER_LIMIT.get((Object)prop.getLowerLimit())).append(".");
                    }
                    if (prop.getUpperLimit() != null) {
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_INT_UPPER_LIMIT.get((Object)prop.getUpperLimit())).append(".");
                    }
                    if (prop.isAllowUnlimited()) {
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_ALLOW_UNLIMITED.get());
                    }
                    b.append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitString(StringPropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op);
                    if (prop.getPatternSynopsis() != null) {
                        b.append((CharSequence)prop.getPatternSynopsis());
                    } else {
                        b.append((CharSequence)DsconfigMessages.REF_DSCFG_STRING.get());
                    }
                    b.append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }

                @Override
                public String visitUnknown(PropertyDefinition prop, Void p) {
                    b.append(DSConfigSubCommandUsageHandler.this.op).append((CharSequence)DsconfigMessages.REF_DSCFG_UNKNOWN.get()).append(DSConfigSubCommandUsageHandler.this.cp).append(StaticUtils.EOL);
                    return null;
                }
            };
            prop.accept(visitor, null);
        }

        private String getLink(String target) {
            return " <xref linkend=\"" + target + "\" />";
        }
    }
}

