/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.ManagedObjectPathSerializer;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.server.config.client.RootCfgClient;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;
import org.forgerock.opendj.server.config.server.RootCfg;

public final class ManagedObjectPath<C extends ConfigurationClient, S extends Configuration> {
    private static final ManagedObjectPath<RootCfgClient, RootCfg> EMPTY_PATH = new ManagedObjectPath<RootCfgClient, RootCfg>(new LinkedList(), null, RootCfgDefn.getInstance());
    private static final Pattern PE_REGEXP = Pattern.compile("^\\s*relation=\\s*([^+]+)\\s*(\\+\\s*type=\\s*([^+]+)\\s*)?(\\+\\s*name=\\s*([^+]+)\\s*)?$");
    private final AbstractManagedObjectDefinition<C, S> d;
    private final List<Element<?, ?>> elements;
    private final RelationDefinition<? super C, ? super S> r;

    public static ManagedObjectPath<RootCfgClient, RootCfg> emptyPath() {
        return EMPTY_PATH;
    }

    public static ManagedObjectPath<?, ?> valueOf(String s) {
        String ns = s.trim();
        if (ns.equals("/")) {
            return EMPTY_PATH;
        }
        LinkedList elements = new LinkedList();
        Element<?, ?> lastElement = null;
        AbstractManagedObjectDefinition definition = RootCfgDefn.getInstance();
        if (!ns.startsWith("/")) {
            throw new IllegalArgumentException("Invalid path \"" + ns + "\": must begin with a \"/\"");
        }
        int start = 1;
        while (true) {
            RelationDefinition<?, ?> r;
            String es;
            Matcher m;
            int end;
            for (end = start; end < ns.length(); ++end) {
                char c = ns.charAt(end);
                if (c != '/') continue;
                if (end == ns.length() - 1) {
                    throw new IllegalArgumentException("Invalid path \"" + ns + "\": must not end with a trailing \"/\"");
                }
                if (ns.charAt(end + 1) != '/') break;
                ++end;
            }
            if (!(m = PE_REGEXP.matcher(es = ns.substring(start, end))).matches()) {
                throw new IllegalArgumentException("Invalid path element \"" + es + "\" in path \"" + ns + "\"");
            }
            String relation = m.group(1);
            String type = m.group(3);
            String name = m.group(5);
            try {
                r = definition.getRelationDefinition(relation);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid path element \"" + es + "\" in path \"" + ns + "\": unknown relation \"" + relation + "\"");
            }
            lastElement = ManagedObjectPath.createElement(r, ns, es, type, name);
            elements.add(lastElement);
            definition = lastElement.getManagedObjectDefinition();
            if (end >= ns.length()) break;
            start = end + 1;
        }
        return ManagedObjectPath.create(elements, lastElement);
    }

    private static <C extends ConfigurationClient, S extends Configuration> ManagedObjectPath<C, S> create(LinkedList<Element<?, ?>> elements, Element<C, S> lastElement) {
        return new ManagedObjectPath<C, S>(elements, lastElement.getRelationDefinition(), lastElement.getManagedObjectDefinition());
    }

    private static <C extends ConfigurationClient, S extends Configuration> Element<? extends C, ? extends S> createElement(RelationDefinition<C, S> r, String path, String element, String type, String name) {
        RelationDefinition ir;
        AbstractManagedObjectDefinition<C, S> d = null;
        if (type != null) {
            for (AbstractManagedObjectDefinition<C, S> child : r.getChildDefinition().getAllChildren()) {
                if (!child.getName().equals(type)) continue;
                d = child;
                break;
            }
            if (d == null) {
                throw new IllegalArgumentException("Invalid path element \"" + element + "\" in path \"" + path + "\": unknown sub-type \"" + type + "\"");
            }
        } else {
            d = r.getChildDefinition();
        }
        if (r instanceof InstantiableRelationDefinition) {
            ir = (InstantiableRelationDefinition)r;
            if (name == null) {
                throw new IllegalArgumentException("Invalid path element \"" + element + "\" in path \"" + path + "\": no instance name for instantiable relation");
            }
            return InstantiableElement.create(ir, d, name);
        }
        if (r instanceof SetRelationDefinition) {
            ir = (SetRelationDefinition)r;
            if (name != null) {
                throw new IllegalArgumentException("Invalid path element \"" + element + "\" in path \"" + path + "\": instance name specified for set relation");
            }
            return SetElement.create((SetRelationDefinition)ir, d);
        }
        if (r instanceof OptionalRelationDefinition) {
            OptionalRelationDefinition or = (OptionalRelationDefinition)r;
            if (name != null) {
                throw new IllegalArgumentException("Invalid path element \"" + element + "\" in path \"" + path + "\": instance name specified for optional relation");
            }
            return OptionalElement.create(or, d);
        }
        if (r instanceof SingletonRelationDefinition) {
            SingletonRelationDefinition sr = (SingletonRelationDefinition)r;
            if (name != null) {
                throw new IllegalArgumentException("Invalid path element \"" + element + "\" in path \"" + path + "\": instance name specified for singleton relation");
            }
            return SingletonElement.create(sr, d);
        }
        throw new IllegalArgumentException("Invalid path element \"" + element + "\" in path \"" + path + "\": unsupported relation type");
    }

    private ManagedObjectPath(LinkedList<Element<?, ?>> elements, RelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.elements = Collections.unmodifiableList(elements);
        this.r = r;
        this.d = d;
    }

    public <C1 extends C, S1 extends S> ManagedObjectPath<C1, S1> asSubType(AbstractManagedObjectDefinition<C1, S1> nd) {
        if (this.r instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition ir = (InstantiableRelationDefinition)this.r;
            if (this.elements.size() == 0) {
                return this.parent().child(ir, nd, "null");
            }
            return this.parent().child(ir, nd, this.elements.get(this.elements.size() - 1).getName());
        }
        if (this.r instanceof SetRelationDefinition) {
            SetRelationDefinition sr = (SetRelationDefinition)this.r;
            return this.parent().child(sr, nd);
        }
        if (this.r instanceof OptionalRelationDefinition) {
            OptionalRelationDefinition or = (OptionalRelationDefinition)this.r;
            return this.parent().child(or, nd);
        }
        SingletonRelationDefinition sr = (SingletonRelationDefinition)this.r;
        return this.parent().child(sr, nd);
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(InstantiableRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d, String name) {
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("Empty or blank managed object names are not allowed");
        }
        LinkedList celements = new LinkedList(this.elements);
        celements.add(new InstantiableElement(r, d, name));
        return new ManagedObjectPath<M, N>(celements, r, d);
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(InstantiableRelationDefinition<M, N> r, String name) {
        return this.child(r, r.getChildDefinition(), name);
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(OptionalRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d) {
        LinkedList celements = new LinkedList(this.elements);
        celements.add(new OptionalElement(r, d));
        return new ManagedObjectPath<M, N>(celements, r, d);
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(OptionalRelationDefinition<M, N> r) {
        return this.child(r, r.getChildDefinition());
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(SingletonRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d) {
        LinkedList celements = new LinkedList(this.elements);
        celements.add(new SingletonElement(r, d));
        return new ManagedObjectPath<M, N>(celements, r, d);
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(SingletonRelationDefinition<M, N> r) {
        return this.child(r, r.getChildDefinition());
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(SetRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d) {
        LinkedList celements = new LinkedList(this.elements);
        celements.add(new SetElement(r, d));
        return new ManagedObjectPath<M, N>(celements, r, d);
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<? extends M, ? extends N> child(SetRelationDefinition<M, N> r, String name) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        return this.child(r, d.getChild(name));
    }

    public <M extends ConfigurationClient, N extends Configuration> ManagedObjectPath<M, N> child(SetRelationDefinition<M, N> r) {
        return this.child(r, r.getChildDefinition());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ManagedObjectPath) {
            ManagedObjectPath other = (ManagedObjectPath)obj;
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public AbstractManagedObjectDefinition<C, S> getManagedObjectDefinition() {
        return this.d;
    }

    public String getName() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1).getName();
    }

    public RelationDefinition<? super C, ? super S> getRelationDefinition() {
        return this.r;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean matches(ManagedObjectPath<?, ?> other) {
        DN thisDN = this.toDN();
        DN otherDN = other.toDN();
        return thisDN.equals((Object)otherDN);
    }

    public ManagedObjectPath<?, ?> parent() {
        return this.parent(1);
    }

    public ManagedObjectPath<?, ?> parent(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Negative offset");
        }
        if (offset > this.elements.size()) {
            throw new IllegalArgumentException("Offset is greater than the number of path elements");
        }
        if (offset == 0) {
            return this;
        }
        if (this.elements.size() == offset) {
            return ManagedObjectPath.emptyPath();
        }
        LinkedList celements = new LinkedList(this.elements.subList(0, this.elements.size() - offset));
        return ManagedObjectPath.create(celements, celements.getLast());
    }

    public ManagedObjectPath<C, S> rename(String newName) {
        if (this.elements.size() == 0) {
            throw new IllegalStateException("Cannot rename an empty path");
        }
        if (this.r instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition ir = (InstantiableRelationDefinition)this.r;
            return this.parent().child(ir, this.d, newName);
        }
        throw new IllegalStateException("Not an instantiable relation");
    }

    public void serialize(ManagedObjectPathSerializer serializer) {
        for (Element<?, ?> element : this.elements) {
            element.serialize(serializer);
        }
    }

    public int size() {
        return this.elements.size();
    }

    public DN toDN() {
        DNSerializer serializer = new DNSerializer();
        this.serialize(serializer);
        return serializer.toDN();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        if (this.isEmpty()) {
            builder.append('/');
        } else {
            StringSerializer serializer = new StringSerializer(builder);
            this.serialize(serializer);
        }
    }

    private static final class StringSerializer
    implements ManagedObjectPathSerializer {
        private final StringBuilder builder;

        private StringSerializer(StringBuilder builder) {
            this.builder = builder;
        }

        public <M extends ConfigurationClient, N extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d, String name) {
            this.serializeElement(r, d);
            this.builder.append("+name=");
            this.builder.append(name.replace("/", "//"));
        }

        public <M extends ConfigurationClient, N extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d) {
            this.serializeElement(r, d);
        }

        public <M extends ConfigurationClient, N extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d) {
            this.serializeElement(r, d);
        }

        public <M extends ConfigurationClient, N extends Configuration> void appendManagedObjectPathElement(SetRelationDefinition<? super M, ? super N> r, AbstractManagedObjectDefinition<M, N> d) {
            this.serializeElement(r, d);
        }

        private <M, N> void serializeElement(RelationDefinition<?, ?> r, AbstractManagedObjectDefinition<?, ?> d) {
            this.builder.append("/relation=");
            this.builder.append(r.getName());
            if (r.getChildDefinition() != d) {
                this.builder.append("+type=");
                this.builder.append(d.getName());
            }
        }
    }

    private static final class SingletonElement<C extends ConfigurationClient, S extends Configuration>
    extends Element<C, S> {
        private final SingletonRelationDefinition<? super C, ? super S> r;

        private static <C extends ConfigurationClient, S extends Configuration> SingletonElement<C, S> create(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            return new SingletonElement<C, S>(r, d);
        }

        private SingletonElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            super(d);
            this.r = r;
        }

        @Override
        public SingletonRelationDefinition<? super C, ? super S> getRelationDefinition() {
            return this.r;
        }

        @Override
        public void serialize(ManagedObjectPathSerializer serializer) {
            serializer.appendManagedObjectPathElement(this.r, this.getManagedObjectDefinition());
        }
    }

    private static final class SetElement<C extends ConfigurationClient, S extends Configuration>
    extends Element<C, S> {
        private final SetRelationDefinition<? super C, ? super S> r;

        private static <C extends ConfigurationClient, S extends Configuration> SetElement<C, S> create(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            return new SetElement<C, S>(r, d);
        }

        private SetElement(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            super(d);
            this.r = r;
        }

        @Override
        public SetRelationDefinition<? super C, ? super S> getRelationDefinition() {
            return this.r;
        }

        @Override
        public void serialize(ManagedObjectPathSerializer serializer) {
            serializer.appendManagedObjectPathElement(this.r, this.getManagedObjectDefinition());
        }
    }

    private static final class OptionalElement<C extends ConfigurationClient, S extends Configuration>
    extends Element<C, S> {
        private final OptionalRelationDefinition<? super C, ? super S> r;

        private static <C extends ConfigurationClient, S extends Configuration> OptionalElement<C, S> create(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            return new OptionalElement<C, S>(r, d);
        }

        private OptionalElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            super(d);
            this.r = r;
        }

        @Override
        public OptionalRelationDefinition<? super C, ? super S> getRelationDefinition() {
            return this.r;
        }

        @Override
        public void serialize(ManagedObjectPathSerializer serializer) {
            serializer.appendManagedObjectPathElement(this.r, this.getManagedObjectDefinition());
        }
    }

    private static final class InstantiableElement<C extends ConfigurationClient, S extends Configuration>
    extends Element<C, S> {
        private final String name;
        private final InstantiableRelationDefinition<? super C, ? super S> r;

        private static <C extends ConfigurationClient, S extends Configuration> InstantiableElement<C, S> create(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            return new InstantiableElement<C, S>(r, d, name);
        }

        private InstantiableElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            super(d);
            this.r = r;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InstantiableRelationDefinition<? super C, ? super S> getRelationDefinition() {
            return this.r;
        }

        @Override
        public void serialize(ManagedObjectPathSerializer serializer) {
            serializer.appendManagedObjectPathElement(this.r, this.getManagedObjectDefinition(), this.name);
        }
    }

    private static abstract class Element<C extends ConfigurationClient, S extends Configuration> {
        private final AbstractManagedObjectDefinition<C, S> definition;

        protected Element(AbstractManagedObjectDefinition<C, S> definition) {
            this.definition = definition;
        }

        public final AbstractManagedObjectDefinition<C, S> getManagedObjectDefinition() {
            return this.definition;
        }

        public String getName() {
            return null;
        }

        public abstract RelationDefinition<? super C, ? super S> getRelationDefinition();

        public abstract void serialize(ManagedObjectPathSerializer var1);
    }

    private static final class DNSerializer
    implements ManagedObjectPathSerializer {
        private DN dn = DN.rootDN();
        private final LDAPProfile profile = LDAPProfile.getInstance();

        private DNSerializer() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            this.appendManagedObjectPathElement(r);
            String type = this.profile.getRelationChildRDNType(r);
            AttributeType attrType = Schema.getDefaultSchema().getAttributeType(type);
            this.dn = this.dn.child(new RDN(attrType, (Object)name));
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            this.appendManagedObjectPathElement(r);
            String type = this.profile.getRelationChildRDNType(r);
            AttributeType attrType = Schema.getDefaultSchema().getAttributeType(type);
            this.dn = this.dn.child(new RDN(attrType, (Object)d.getName()));
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            this.appendManagedObjectPathElement(r);
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            this.appendManagedObjectPathElement(r);
        }

        private void appendManagedObjectPathElement(RelationDefinition<?, ?> r) {
            DN localName = DN.valueOf((String)this.profile.getRelationRDNSequence(r));
            this.dn = this.dn.child(localName);
        }

        private DN toDN() {
            return this.dn;
        }
    }
}

