/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class UUIDSyntaxImpl
extends AbstractSyntaxImpl {
    UUIDSyntaxImpl() {
    }

    @Override
    public String getName() {
        return "UUID";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public String getEqualityMatchingRule() {
        return "1.3.6.1.1.16.2";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "1.3.6.1.1.16.3";
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString();
        if (valueString.length() != 36) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH.get((Object)valueString, (Object)valueString.length()));
            return false;
        }
        block6: for (int i = 0; i < 36; ++i) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (valueString.charAt(i) == '-') continue block6;
                    invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH.get((Object)valueString, (Object)i, (Object)String.valueOf(valueString.charAt(i))));
                    return false;
                }
                default: {
                    switch (valueString.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            continue block6;
                        }
                    }
                    invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX.get((Object)valueString, (Object)i, (Object)String.valueOf(valueString.charAt(i))));
                    return false;
                }
            }
        }
        return true;
    }
}

