/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

final class ObjectIdentifierEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    ObjectIdentifierEqualityMatchingRuleImpl() {
        super("objectIdentifierMatch");
    }

    static String resolveNames(Schema schema, String oidOrName) throws DecodeException {
        if (StaticUtils.isDigit(oidOrName.charAt(0))) {
            return oidOrName;
        }
        String lowerCaseName = StaticUtils.toLowerCase(oidOrName);
        try {
            String oid = schema.getOIDForName(lowerCaseName);
            if (oid != null) {
                return oid;
            }
        }
        catch (UnknownSchemaElementException e) {
            throw DecodeException.error(e.getMessageObject(), (Throwable)((Object)e));
        }
        return lowerCaseName;
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        return ObjectIdentifierEqualityMatchingRuleImpl.normalizeAttributeValuePrivate(schema, value);
    }

    static ByteString normalizeAttributeValuePrivate(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        String oid = SchemaUtils.readOID(reader, schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS));
        return ByteString.valueOfUtf8(ObjectIdentifierEqualityMatchingRuleImpl.resolveNames(schema, oid));
    }

    @Override
    String keyToHumanReadableString(ByteSequence key) {
        return key.toByteString().toString();
    }
}

