/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LoadBalancer;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

final class RequestLoadBalancer
extends LoadBalancer {
    private final Function<Request, Integer, NeverThrowsException> nextFactoryFunction;

    RequestLoadBalancer(String loadBalancerName, Collection<? extends ConnectionFactory> factories, Options options, Function<Request, Integer, NeverThrowsException> nextFactoryFunction) {
        super(loadBalancerName, factories, options);
        this.nextFactoryFunction = nextFactoryFunction;
    }

    @Override
    public final Connection getConnection() throws LdapException {
        return new ConnectionImpl();
    }

    @Override
    public final Promise<Connection, LdapException> getConnectionAsync() {
        return Promises.newResultPromise((Object)new ConnectionImpl());
    }

    private class ConnectionImpl
    extends AbstractAsynchronousConnection {
        private final ConnectionState state = new ConnectionState();

        private ConnectionImpl() {
        }

        @Override
        public String toString() {
            return RequestLoadBalancer.this.getLoadBalancerName() + "Connection";
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return LdapPromises.newSuccessfulLdapPromise(null);
        }

        @Override
        public LdapPromise<Result> addAsync(final AddRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.addAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, BindResult, LdapException>(){

                public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.bindAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.state.notifyConnectionClosed();
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(final CompareRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, CompareResult, LdapException>(){

                public Promise<CompareResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.compareAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> deleteAsync(final DeleteRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.deleteAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, R, LdapException>(){

                public Promise<R, LdapException> apply(Connection connection) throws LdapException {
                    return connection.extendedRequestAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(final ModifyRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(final ModifyDNRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyDNAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(final SearchRequest request, final IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler entryHandler) {
            return this.getConnectionAndSendRequest(request, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.searchAsync(request, intermediateResponseHandler, entryHandler);
                }
            });
        }

        private <R> LdapPromise<R> getConnectionAndSendRequest(Request request, AsyncFunction<Connection, R, LdapException> sendRequest) {
            if (this.state.isClosed()) {
                throw new IllegalStateException();
            }
            final AtomicReference connectionHolder = new AtomicReference();
            return this.getConnectionAsync(request).thenOnResult(new ResultHandler<Connection>(){

                public void handleResult(Connection connection) {
                    connectionHolder.set(connection);
                }
            }).thenAsync(sendRequest).thenFinally(new Runnable(){

                @Override
                public void run() {
                    Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                }
            });
        }

        private LdapPromise<Connection> getConnectionAsync(Request request) {
            try {
                int index = (Integer)RequestLoadBalancer.this.nextFactoryFunction.apply((Object)request);
                ConnectionFactory factory = RequestLoadBalancer.this.getMonitoredConnectionFactory(index);
                return LdapPromises.asPromise(factory.getConnectionAsync().thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    public void handleException(LdapException e) {
                        ConnectionImpl.this.state.notifyConnectionError(false, e);
                    }
                }));
            }
            catch (LdapException e) {
                this.state.notifyConnectionError(false, e);
                return LdapPromises.newFailedLdapPromise(e);
            }
        }
    }
}

