/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.WeakHashMap;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class DN
implements Iterable<RDN>,
Comparable<DN> {
    static final byte NORMALIZED_RDN_SEPARATOR = 0;
    static final byte NORMALIZED_AVA_SEPARATOR = 1;
    static final byte NORMALIZED_ESC_BYTE = 2;
    static final char RDN_CHAR_SEPARATOR = ',';
    static final char AVA_CHAR_SEPARATOR = '+';
    private static final DN ROOT_DN = new DN(CoreSchema.getInstance(), null, null);
    private static final int DN_CACHE_SIZE = 32;
    private static final ThreadLocal<WeakHashMap<Schema, Map<String, DN>>> CACHE = new ThreadLocal<WeakHashMap<Schema, Map<String, DN>>>(){

        @Override
        protected WeakHashMap<Schema, Map<String, DN>> initialValue() {
            return new WeakHashMap<Schema, Map<String, DN>>();
        }
    };
    private final RDN rdn;
    private DN parent;
    private final int size;
    private ByteString normalizedDN;
    private String stringValue;
    private final Schema schema;

    public static String escapeAttributeValue(Object attributeValue) {
        Reject.ifNull((Object)attributeValue);
        String s = String.valueOf(attributeValue);
        StringBuilder builder = new StringBuilder(s.length());
        AVA.escapeAttributeValue(s, builder);
        return builder.toString();
    }

    public static DN format(String template, Object ... attributeValues) {
        return DN.format(template, Schema.getDefaultSchema(), attributeValues);
    }

    public static DN format(String template, Schema schema, Object ... attributeValues) {
        String[] attributeValueStrings = new String[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            attributeValueStrings[i] = DN.escapeAttributeValue(attributeValues[i]);
        }
        String dnString = String.format(template, attributeValueStrings);
        return DN.valueOf(dnString, schema);
    }

    public static DN rootDN() {
        return ROOT_DN;
    }

    public static DN valueOf(String dn) {
        return DN.valueOf(dn, Schema.getDefaultSchema());
    }

    public static DN valueOf(String dn, Schema schema) {
        Reject.ifNull((Object[])new Object[]{dn, schema});
        if (dn.length() == 0) {
            return ROOT_DN;
        }
        Map<String, DN> cache = DN.getCache(schema);
        DN cachedDN = cache.get(dn);
        if (cachedDN != null) {
            return cachedDN;
        }
        return DN.decode(new SubstringReader(dn), schema, cache);
    }

    public static DN valueOf(ByteString dn) {
        return DN.valueOf(dn.toString());
    }

    private static DN decode(SubstringReader reader, Schema schema, Map<String, DN> cache) {
        RDN rdn;
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            return ROOT_DN;
        }
        try {
            rdn = RDN.decode(reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_DN_TYPE_NOT_FOUND.get((Object)reader.getString(), (Object)e.getMessageObject()));
        }
        if (reader.remaining() > 0 && reader.read() == ',') {
            reader.skipWhitespaces();
            if (reader.remaining() == 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get((Object)reader.getString()));
            }
            reader.mark();
            String parentString = reader.read(reader.remaining());
            DN parent = cache.get(parentString);
            if (parent == null) {
                reader.reset();
                parent = DN.decode(reader, schema, cache);
                cache.put(parentString, parent);
            }
            return new DN(schema, parent, rdn);
        }
        return new DN(schema, ROOT_DN, rdn);
    }

    private static Map<String, DN> getCache(Schema schema) {
        WeakHashMap<Schema, Map<String, DN>> threadLocalMap = CACHE.get();
        LinkedHashMap<String, DN> schemaLocalMap = threadLocalMap.get(schema);
        if (schemaLocalMap == null) {
            schemaLocalMap = new LinkedHashMap<String, DN>(32, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, DN> e) {
                    return this.size() > 32;
                }
            };
            threadLocalMap.put(schema, (Map<String, DN>)schemaLocalMap);
        }
        return schemaLocalMap;
    }

    private DN(Schema schema, DN parent, RDN rdn) {
        this(schema, parent, rdn, parent != null ? parent.size + 1 : 0);
    }

    private DN(Schema schema, DN parent, RDN rdn, int size) {
        this.schema = schema;
        this.parent = parent;
        this.rdn = rdn;
        this.size = size;
        this.stringValue = rdn == null ? "" : null;
    }

    public DN child(DN dn) {
        Reject.ifNull((Object)dn);
        if (dn.isRootDN()) {
            return this;
        }
        if (this.isRootDN()) {
            return dn;
        }
        RDN[] rdns = new RDN[dn.size()];
        int i = rdns.length;
        DN next = dn;
        while (next.rdn != null) {
            rdns[--i] = next.rdn;
            next = next.parent;
        }
        DN newDN = this;
        for (i = 0; i < rdns.length; ++i) {
            newDN = new DN(this.schema, newDN, rdns[i]);
        }
        return newDN;
    }

    public DN child(RDN rdn) {
        Reject.ifNull((Object)rdn);
        return new DN(this.schema, this, rdn);
    }

    public DN child(String dn) {
        Reject.ifNull((Object)dn);
        return this.child(DN.valueOf(dn));
    }

    public DN child(String attributeType, Object attributeValue) {
        return this.child(new RDN(attributeType, attributeValue));
    }

    @Override
    public int compareTo(DN dn) {
        return this.toNormalizedByteString().compareTo(dn.toNormalizedByteString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DN) {
            DN otherDN = (DN)obj;
            return this.toNormalizedByteString().equals(otherDN.toNormalizedByteString());
        }
        return false;
    }

    public int hashCode() {
        return this.toNormalizedByteString().hashCode();
    }

    public boolean isChildOf(DN dn) {
        return dn.equals(this.parent);
    }

    public boolean isChildOf(String dn) {
        return this.isChildOf(DN.valueOf(dn));
    }

    public boolean isInScopeOf(DN dn, SearchScope scope) {
        switch (scope.asEnum()) {
            case BASE_OBJECT: {
                return this.equals(dn);
            }
            case SINGLE_LEVEL: {
                return this.isChildOf(dn);
            }
            case SUBORDINATES: {
                return this.isSubordinateOrEqualTo(dn) && !this.equals(dn);
            }
            case WHOLE_SUBTREE: {
                return this.isSubordinateOrEqualTo(dn);
            }
        }
        return false;
    }

    public boolean isInScopeOf(String dn, SearchScope scope) {
        return this.isInScopeOf(DN.valueOf(dn), scope);
    }

    public boolean isParentOf(DN dn) {
        return this.equals(dn.parent);
    }

    public boolean isParentOf(String dn) {
        return this.isParentOf(DN.valueOf(dn));
    }

    public boolean isRootDN() {
        return this.size == 0;
    }

    public boolean isSubordinateOrEqualTo(DN dn) {
        if (this.size < dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return this.parent(this.size - dn.size).equals(dn);
    }

    public boolean isSubordinateOrEqualTo(String dn) {
        return this.isSubordinateOrEqualTo(DN.valueOf(dn));
    }

    public boolean isSuperiorOrEqualTo(DN dn) {
        if (this.size > dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return dn.parent(dn.size - this.size).equals(this);
    }

    public boolean isSuperiorOrEqualTo(String dn) {
        return this.isSuperiorOrEqualTo(DN.valueOf(dn));
    }

    @Override
    public Iterator<RDN> iterator() {
        return new Iterator<RDN>(){
            private DN dn;
            {
                this.dn = DN.this;
            }

            @Override
            public boolean hasNext() {
                return this.dn.rdn != null;
            }

            @Override
            public RDN next() {
                if (this.dn.rdn == null) {
                    throw new NoSuchElementException();
                }
                RDN rdn = this.dn.rdn;
                this.dn = this.dn.parent;
                return rdn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public DN localName(int index) {
        DN localName;
        Reject.ifFalse((index >= 0 ? 1 : 0) != 0, (String)"index less than zero");
        if (index == 0) {
            return ROOT_DN;
        }
        if (index >= this.size) {
            return this;
        }
        DN nextLocalName = localName = new DN(this.schema, null, this.rdn, index);
        DN lastDN = this.parent;
        for (int i = index - 1; i > 0; --i) {
            nextLocalName = nextLocalName.parent = new DN(this.schema, null, lastDN.rdn, i);
            lastDN = lastDN.parent;
        }
        nextLocalName.parent = ROOT_DN;
        return localName;
    }

    public DN parent() {
        return this.parent;
    }

    public DN parent(int index) {
        Reject.ifFalse((index >= 0 ? 1 : 0) != 0, (String)"index less than zero");
        DN parentDN = this;
        for (int i = 0; parentDN != null && i < index; ++i) {
            parentDN = parentDN.parent;
        }
        return parentDN;
    }

    public RDN rdn() {
        return this.rdn;
    }

    public RDN rdn(int index) {
        DN parentDN = this.parent(index);
        return parentDN != null ? parentDN.rdn : null;
    }

    public DN rename(DN fromDN, DN toDN) {
        Reject.ifNull((Object[])new DN[]{fromDN, toDN});
        if (!this.isSubordinateOrEqualTo(fromDN)) {
            return this;
        }
        if (this.equals(fromDN)) {
            return toDN;
        }
        return toDN.child(this.localName(this.size - fromDN.size));
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = this.rdn.toString(new StringBuilder());
            if (!this.parent.isRootDN()) {
                builder.append(',');
                builder.append(this.parent);
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    public ByteString toNormalizedByteString() {
        if (this.normalizedDN == null) {
            if (this.rdn == null) {
                this.normalizedDN = ByteString.empty();
            } else {
                ByteString normalizedParent = this.parent.toNormalizedByteString();
                ByteStringBuilder builder = new ByteStringBuilder(normalizedParent.length() + 16);
                builder.appendBytes(normalizedParent);
                this.rdn.toNormalizedByteString(builder);
                this.normalizedDN = builder.toByteString();
            }
        }
        return this.normalizedDN;
    }

    public String toNormalizedUrlSafeString() {
        if (this.rdn() == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = this.size() - 1;
        this.parent(i).rdn().toNormalizedUrlSafeString(builder);
        --i;
        while (i >= 0) {
            RDN rdn = this.parent(i).rdn();
            if (rdn.size() != 0) {
                builder.append(',');
            }
            rdn.toNormalizedUrlSafeString(builder);
            --i;
        }
        return builder.toString();
    }

    public UUID toUUID() {
        ByteString normDN = this.toNormalizedByteString();
        if (!normDN.isEmpty()) {
            normDN = normDN.subSequence(1, normDN.length());
        }
        return UUID.nameUUIDFromBytes(normDN.toByteArray());
    }

    public CompactDn compact() {
        return new CompactDn(this);
    }

    @Deprecated
    public static final class CompactDn
    implements Comparable<CompactDn> {
        private final byte[] originalValue;
        private volatile byte[] normalizedValue;
        private final Schema schema;

        private CompactDn(DN dn) {
            this.originalValue = StaticUtils.getBytes(dn.toString());
            this.schema = dn.schema;
        }

        @Override
        public int compareTo(CompactDn other) {
            byte[] normValue = this.getNormalizedValue();
            byte[] otherNormValue = other.getNormalizedValue();
            return ByteString.compareTo(normValue, 0, normValue.length, otherNormValue, 0, otherNormValue.length);
        }

        public DN toDn() {
            return DN.valueOf(ByteString.toString(this.originalValue, 0, this.originalValue.length), this.schema);
        }

        public int hashCode() {
            return Arrays.hashCode(this.getNormalizedValue());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CompactDn) {
                CompactDn other = (CompactDn)obj;
                return Arrays.equals(this.getNormalizedValue(), other.getNormalizedValue());
            }
            return false;
        }

        public String toString() {
            return ByteString.toString(this.originalValue, 0, this.originalValue.length);
        }

        private byte[] getNormalizedValue() {
            if (this.normalizedValue == null) {
                this.normalizedValue = this.toDn().toNormalizedByteString().toByteArray();
            }
            return this.normalizedValue;
        }
    }
}

